/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.io.IOException;
import java.util.LinkedList;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.IoStatistics;
import net.sourceforge.fullsync.Synchronizer;
import net.sourceforge.fullsync.Task;
import net.sourceforge.fullsync.TaskFinishedEvent;
import net.sourceforge.fullsync.TaskFinishedListener;
import net.sourceforge.fullsync.TaskTree;
import net.sourceforge.fullsync.ui.GUIUpdateQueue;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.TaskDecisionList;
import net.sourceforge.fullsync.ui.UISettings;
import net.sourceforge.fullsync.ui.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class TaskDecisionPage
extends WizardDialog {
    private GuiController guiController;
    private TaskTree taskTree;
    private boolean processing;
    private int tasksFinished;
    private int tasksTotal;
    private TaskDecisionList list;
    private Combo comboFilter;
    private Label labelProgress;

    public TaskDecisionPage(Shell parent, GuiController guiController, TaskTree taskTree) {
        super(parent);
        this.guiController = guiController;
        this.taskTree = taskTree;
    }

    @Override
    public String getTitle() {
        return Messages.getString("TaskDecisionPage.TaskDecision");
    }

    @Override
    public String getCaption() {
        return Messages.getString("TaskDecisionPage.ChooseTheActions");
    }

    @Override
    public String getDescription() {
        return Messages.getString("TaskDecisionPage.Source") + ": " + this.taskTree.getSource().getConnectionDescription().getDisplayPath() + "\n" + Messages.getString("TaskDecisionPage.Destination") + ": " + this.taskTree.getDestination().getConnectionDescription().getDisplayPath();
    }

    @Override
    public Image getIcon() {
        return GuiController.getInstance().getImage("Tasklist_Icon.png");
    }

    @Override
    public Image getImage() {
        return GuiController.getInstance().getImage("Tasklist_Wizard.png");
    }

    @Override
    public void createContent(Composite content) {
        content.setLayout((Layout)new GridLayout(2, false));
        this.comboFilter = new Combo(content, 12);
        this.comboFilter.add(Messages.getString("TaskDecisionPage.Everything"));
        this.comboFilter.add(Messages.getString("TaskDecisionPage.ChangesOnly"));
        this.comboFilter.select(1);
        this.comboFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!TaskDecisionPage.this.processing) {
                    TaskDecisionPage.this.list.setOnlyChanges(TaskDecisionPage.this.comboFilter.getSelectionIndex() == 1);
                    if (TaskDecisionPage.this.taskTree != null) {
                        TaskDecisionPage.this.list.rebuildActionList();
                    }
                }
            }
        });
        this.labelProgress = new Label(content, 0);
        GridData labelProgressLData = new GridData();
        labelProgressLData.horizontalAlignment = 4;
        labelProgressLData.horizontalIndent = 5;
        labelProgressLData.grabExcessHorizontalSpace = true;
        this.labelProgress.setLayoutData((Object)labelProgressLData);
        Synchronizer synchronizer = GuiController.getInstance().getSynchronizer();
        IoStatistics stats = synchronizer.getIoStatistics(this.taskTree);
        this.labelProgress.setText("Totals: " + stats.getCountActions() + " tasks, " + UISettings.formatSize(stats.getBytesTransferred()));
        this.list = new TaskDecisionList(content, 0);
        this.list.setTaskTree(this.taskTree);
        GridData listLayoutData = new GridData(4, 4, true, true);
        listLayoutData.horizontalSpan = 2;
        this.list.setLayoutData(listLayoutData);
        this.list.setOnlyChanges(true);
        if (this.taskTree != null) {
            this.list.rebuildActionList();
        }
    }

    @Override
    public boolean apply() {
        if (!this.processing) {
            this.setCancelButtonEnabled(false);
            this.performActions();
        }
        return false;
    }

    @Override
    public boolean cancel() {
        if (!this.processing) {
            try {
                this.taskTree.getSource().close();
                this.taskTree.getDestination().close();
            }
            catch (IOException ioe) {
                ExceptionHandler.reportException(ioe);
            }
            return true;
        }
        MessageBox mb = new MessageBox(this.getShell(), 33);
        mb.setText(Messages.getString("TaskDecisionPage.Error"));
        mb.setMessage(Messages.getString("TaskDecisionPage.SyncWindowCantBeClosed"));
        mb.open();
        return false;
    }

    void performActions() {
        Thread worker = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TaskDecisionPage.this.guiController.showBusyCursor(true);
                Display display = TaskDecisionPage.this.getDisplay();
                try {
                    TaskDecisionPage.this.processing = true;
                    TaskDecisionPage.this.list.setChangeAllowed(false);
                    Synchronizer synchronizer = GuiController.getInstance().getSynchronizer();
                    IoStatistics stats = synchronizer.getIoStatistics(TaskDecisionPage.this.taskTree);
                    TaskDecisionPage.this.tasksTotal = stats.getCountActions();
                    TaskDecisionPage.this.tasksFinished = 0;
                    final Color colorFinishedSuccessful = new Color(null, 150, 255, 150);
                    final Color colorFinishedUnsuccessful = new Color(null, 255, 150, 150);
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            TaskDecisionPage.this.setOkButtonEnabled(false);
                        }
                    });
                    final GUIUpdateQueue<TaskFinishedEvent> updateQueue = new GUIUpdateQueue<TaskFinishedEvent>(display, new GUIUpdateQueue.GUIUpdateTask<TaskFinishedEvent>(){

                        @Override
                        public void doUpdate(Display display, LinkedList<TaskFinishedEvent> items) {
                            TableItem item = null;
                            System.err.println("GUIUpdateQueue<TaskFinishedEvent>::doUpdate: " + items.size());
                            for (TaskFinishedEvent event : items) {
                                TaskDecisionPage.this.tasksFinished++;
                                TaskDecisionPage.this.labelProgress.setText(TaskDecisionPage.this.tasksFinished + " " + Messages.getString("TaskDecisionPage.of") + " " + TaskDecisionPage.this.tasksTotal + " " + Messages.getString("TaskDecisionPage.tasksFinished"));
                                Task task = event.getTask();
                                item = TaskDecisionPage.this.list.getTableItemForTask(task);
                                if (item == null) continue;
                                if (event.isSuccessful()) {
                                    item.setBackground(colorFinishedSuccessful);
                                    continue;
                                }
                                item.setBackground(colorFinishedUnsuccessful);
                            }
                            if (null != item) {
                                TaskDecisionPage.this.list.showItem(item);
                            }
                        }
                    });
                    synchronizer.performActions(TaskDecisionPage.this.taskTree, new TaskFinishedListener(){

                        @Override
                        public void taskFinished(TaskFinishedEvent event) {
                            updateQueue.add(event);
                        }
                    });
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageBox mb = new MessageBox(TaskDecisionPage.this.getShell(), 34);
                            mb.setText(Messages.getString("TaskDecisionPage.Finished"));
                            mb.setMessage(Messages.getString("TaskDecisionPage.ProfileFinished"));
                            mb.open();
                            TaskDecisionPage.this.widgetSelected(null);
                        }
                    });
                }
                catch (Exception e) {
                    ExceptionHandler.reportException(e);
                }
                finally {
                    TaskDecisionPage.this.guiController.showBusyCursor(false);
                    TaskDecisionPage.this.processing = false;
                    TaskDecisionPage.this.list.setChangeAllowed(true);
                }
            }
        }, "ActionPerformer");
        worker.start();
    }
}

