/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.net.URI;
import java.net.URISyntaxException;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.ui.ProtocolSpecificComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

abstract class UserPasswordSpecificComposite
extends ProtocolSpecificComposite {
    private Label labelHost = null;
    private Text textHost = null;
    private Label labelPort = null;
    private Spinner spinnerPort = null;
    private Label labelUsername = null;
    private Text textUsername = null;
    private Label labelPassword = null;
    private Text textPassword = null;

    UserPasswordSpecificComposite() {
    }

    @Override
    public void createGUI(Composite parent) {
        this.labelHost = new Label(parent, 0);
        this.labelHost.setText("Host:");
        GridData gridData = this.getGridData();
        gridData.grabExcessHorizontalSpace = true;
        this.textHost = new Text(parent, 2048);
        this.textHost.setLayoutData((Object)this.getGridData());
        int port = this.getDefaultPort();
        if (-1 != port) {
            this.labelPort = new Label(parent, 0);
            this.labelPort.setText("Port:");
            this.spinnerPort = new Spinner(parent, 2048);
            this.spinnerPort.setMinimum(1);
            this.spinnerPort.setMaximum(65535);
            this.spinnerPort.setSelection(port);
            this.spinnerPort.setLayoutData((Object)this.getGridData());
        }
        this.onBeforePasswordHook(parent);
        this.labelUsername = new Label(parent, 0);
        this.labelUsername.setText("Username:");
        this.textUsername = new Text(parent, 2048);
        this.textUsername.setLayoutData((Object)this.getGridData());
        this.labelPassword = new Label(parent, 0);
        this.labelPassword.setText("Password:");
        this.textPassword = new Text(parent, 2048);
        this.textPassword.setLayoutData((Object)this.getGridData());
        this.textPassword.setEchoChar('*');
        super.createGUI(parent);
    }

    protected void onBeforePasswordHook(Composite parent) {
    }

    protected void setUserPasswordEnabled(boolean enabled) {
        this.labelUsername.setEnabled(enabled);
        this.textUsername.setEnabled(enabled);
        this.labelPassword.setEnabled(enabled);
        this.textPassword.setEnabled(enabled);
    }

    private GridData getGridData() {
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.horizontalSpan = 2;
        gridData1.verticalAlignment = 0x1000000;
        return gridData1;
    }

    @Override
    public ConnectionDescription getConnectionDescription() throws URISyntaxException {
        ConnectionDescription desc = super.getConnectionDescription();
        if (null != this.spinnerPort) {
            desc.setUri(new URI(this.m_scheme, null, this.textHost.getText(), this.spinnerPort.getSelection(), desc.getUri().getPath(), null, null));
        } else {
            desc.setUri(new URI(this.m_scheme, this.textHost.getText(), desc.getUri().getPath(), null));
        }
        desc.setParameter("username", this.textUsername.getText());
        desc.setSecretParameter("password", this.textPassword.getText());
        return desc;
    }

    @Override
    public void setConnectionDescription(ConnectionDescription connection) {
        super.setConnectionDescription(connection);
        URI uri = connection.getUri();
        this.textHost.setText(uri.getHost());
        int port = uri.getPort();
        if (-1 == port) {
            port = this.getDefaultPort();
        }
        if (null != this.spinnerPort) {
            this.spinnerPort.setSelection(port);
        }
        this.textUsername.setText(connection.getParameter("username"));
        this.textPassword.setText(connection.getSecretParameter("password"));
    }

    @Override
    public void reset(String scheme) {
        super.reset(scheme);
        this.textHost.setText("");
        if (null != this.spinnerPort) {
            this.spinnerPort.setSelection(this.getDefaultPort());
        }
        this.textUsername.setText("");
        this.textPassword.setText("");
    }

    public abstract int getDefaultPort();
}

