/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.util.Vector;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.WizardDialogListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class WizardDialog
extends SelectionAdapter
implements ShellListener {
    private Shell dialogShell;
    private Composite compositeTop;
    private Composite compositeBottom;
    private Label labelImage;
    private Label labelDescription;
    private Label labelCaption;
    private Composite compositeContent;
    private Button okButton;
    private Button cancelButton;
    private final Shell parent;
    private final int style;
    private final Vector<WizardDialogListener> dialogListeners;

    public WizardDialog(Shell parent) {
        this.parent = parent;
        this.style = 67696;
        this.dialogListeners = new Vector();
    }

    public void show() {
        try {
            this.dialogShell = new Shell(this.parent, this.style);
            this.dialogShell.addShellListener((ShellListener)this);
            Display display = this.dialogShell.getDisplay();
            Color white = display.getSystemColor(1);
            GridLayout dialogShellLayout = new GridLayout();
            dialogShellLayout.horizontalSpacing = 0;
            dialogShellLayout.marginHeight = 0;
            dialogShellLayout.marginWidth = 0;
            dialogShellLayout.verticalSpacing = 0;
            this.dialogShell.setLayout((Layout)dialogShellLayout);
            this.compositeTop = new Composite((Composite)this.dialogShell, 0);
            this.compositeTop.setBackground(white);
            GridData compositeTopLData = new GridData();
            compositeTopLData.grabExcessHorizontalSpace = true;
            compositeTopLData.horizontalAlignment = 4;
            compositeTopLData.horizontalIndent = 0;
            compositeTopLData.verticalIndent = 0;
            this.compositeTop.setLayoutData((Object)compositeTopLData);
            GridLayout compositeTopLayout = new GridLayout(2, false);
            compositeTopLayout.horizontalSpacing = 0;
            compositeTopLayout.marginRight = 0;
            compositeTopLayout.marginBottom = 0;
            compositeTopLayout.marginTop = 0;
            compositeTopLayout.marginLeft = 0;
            compositeTopLayout.marginHeight = 0;
            compositeTopLayout.marginWidth = 0;
            this.compositeTop.setLayout((Layout)compositeTopLayout);
            Composite topTextComposite = new Composite(this.compositeTop, 0);
            topTextComposite.setBackground(white);
            GridLayout topTextCompositeLayout = new GridLayout(1, false);
            topTextCompositeLayout.marginHeight = 10;
            topTextCompositeLayout.marginWidth = 10;
            topTextComposite.setLayout((Layout)topTextCompositeLayout);
            GridData topTextCompositeData = new GridData();
            topTextCompositeData.grabExcessHorizontalSpace = true;
            topTextCompositeData.horizontalAlignment = 4;
            topTextComposite.setLayoutData((Object)topTextCompositeData);
            this.labelImage = new Label(this.compositeTop, 0);
            this.labelImage.setBackground(white);
            this.labelImage.setSize(64, 64);
            GridData labelImageLData = new GridData();
            labelImageLData.horizontalIndent = 0;
            labelImageLData.verticalIndent = 0;
            this.labelImage.setLayoutData((Object)labelImageLData);
            this.labelCaption = new Label(topTextComposite, 0);
            this.labelCaption.setBackground(white);
            this.labelCaption.setFont(GuiController.getInstance().getFont("Tohama", 9, 1));
            GridData labelCaptionLData = new GridData();
            labelCaptionLData.grabExcessHorizontalSpace = true;
            this.labelCaption.setLayoutData((Object)labelCaptionLData);
            this.labelDescription = new Label(topTextComposite, 0);
            this.labelDescription.setBackground(white);
            GridData labelDescriptionLData = new GridData();
            labelDescriptionLData.grabExcessHorizontalSpace = true;
            this.labelDescription.setLayoutData((Object)labelDescriptionLData);
            Label labelSeparatorTop = new Label((Composite)this.dialogShell, 258);
            GridData labelSeparatorTopLData = new GridData();
            labelSeparatorTopLData.horizontalAlignment = 4;
            labelSeparatorTop.setLayoutData((Object)labelSeparatorTopLData);
            this.compositeContent = new Composite((Composite)this.dialogShell, 0);
            GridData compositeContentData = new GridData();
            compositeContentData.grabExcessHorizontalSpace = true;
            compositeContentData.horizontalAlignment = 4;
            compositeContentData.verticalAlignment = 4;
            compositeContentData.grabExcessVerticalSpace = true;
            this.compositeContent.setLayoutData((Object)compositeContentData);
            this.compositeContent.setLayout((Layout)new GridLayout());
            Label labelSeparatorBottom = new Label((Composite)this.dialogShell, 258);
            GridData labelSeparatorBottomData = new GridData();
            labelSeparatorBottomData.horizontalAlignment = 4;
            labelSeparatorBottom.setLayoutData((Object)labelSeparatorBottomData);
            this.compositeBottom = new Composite((Composite)this.dialogShell, 0);
            GridData compositeBottomData = new GridData();
            compositeBottomData.grabExcessHorizontalSpace = true;
            compositeBottomData.horizontalAlignment = 4;
            this.compositeBottom.setLayoutData((Object)compositeBottomData);
            GridLayout compositeBottomLayout = new GridLayout();
            compositeBottomLayout.makeColumnsEqualWidth = true;
            this.compositeBottom.setLayout((Layout)compositeBottomLayout);
            this.updateTop();
            this.createContent(this.compositeContent);
            this.compositeBottom.setLayout((Layout)new GridLayout(2, false));
            this.okButton = new Button(this.compositeBottom, 8);
            this.okButton.setText(Messages.getString("ProfileDetailsPage.Ok"));
            this.okButton.addSelectionListener((SelectionListener)this);
            GridData okButtonLayoutData = new GridData(0x1000008, 0x1000000, true, true);
            okButtonLayoutData.widthHint = 100;
            okButtonLayoutData.heightHint = 25;
            this.okButton.setLayoutData((Object)okButtonLayoutData);
            this.cancelButton = new Button(this.compositeBottom, 8);
            this.cancelButton.setText(Messages.getString("ProfileDetailsPage.Cancel"));
            this.cancelButton.addSelectionListener((SelectionListener)this);
            GridData cancelButtonLayoutData = new GridData(0x1000008, 0x1000000, false, true);
            cancelButtonLayoutData.widthHint = 100;
            cancelButtonLayoutData.heightHint = 25;
            this.cancelButton.setLayoutData((Object)cancelButtonLayoutData);
            this.dialogShell.setDefaultButton(this.okButton);
            this.compositeContent.pack();
            this.dialogShell.layout();
            Point size = this.dialogShell.computeSize(-1, -1);
            size.x = Math.max(size.x, 500);
            size.y = Math.max(size.y, 400);
            if (size.x > display.getBounds().width - this.dialogShell.getBounds().x) {
                size.x = display.getBounds().width - this.dialogShell.getBounds().x - 50;
            }
            if (size.y > display.getBounds().height - this.dialogShell.getBounds().y) {
                size.y = display.getBounds().height - this.dialogShell.getBounds().y - 50;
            }
            this.dialogShell.setSize(size);
            this.dialogShell.open();
            this.dialogOpened();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    protected void dialogOpened() {
        for (WizardDialogListener listener : this.dialogListeners) {
            listener.dialogOpened();
        }
    }

    public void dispose() {
        for (Control control : this.compositeContent.getChildren()) {
            control.dispose();
        }
        this.dialogShell.dispose();
    }

    public Display getDisplay() {
        return this.parent.getDisplay();
    }

    public Shell getShell() {
        return this.dialogShell;
    }

    public void updateTop() {
        this.dialogShell.setImage(this.getIcon());
        this.dialogShell.setText(this.getTitle());
        this.labelCaption.setText(this.getCaption());
        this.labelDescription.setText(this.getDescription());
        this.labelImage.setImage(this.getImage());
    }

    public void addWizardDialogListener(WizardDialogListener listener) {
        if (listener != null && !this.dialogListeners.contains(listener)) {
            this.dialogListeners.add(listener);
        }
    }

    public void removeWizardDialogListener(WizardDialogListener listener) {
        this.dialogListeners.remove(listener);
    }

    public void widgetSelected(SelectionEvent e) {
        if (null != e && e.widget == this.okButton) {
            if (this.apply()) {
                this.dialogShell.dispose();
            }
        } else if (this.cancel()) {
            this.dialogShell.dispose();
        }
    }

    public final void setOkButtonEnabled(boolean enabled) {
        this.okButton.setEnabled(enabled);
    }

    public final void setCancelButtonEnabled(boolean enabled) {
        this.cancelButton.setEnabled(enabled);
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellClosed(ShellEvent e) {
        if (this.cancel()) {
            this.dialogShell.dispose();
        } else {
            e.doit = false;
        }
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public abstract String getTitle();

    public abstract String getCaption();

    public abstract String getDescription();

    public abstract Image getIcon();

    public abstract Image getImage();

    public abstract void createContent(Composite var1);

    public abstract boolean apply();

    public abstract boolean cancel();
}

