/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui.filterrule;

import java.util.Hashtable;
import net.sourceforge.fullsync.SystemDate;
import net.sourceforge.fullsync.rules.filefilter.FileAgeFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileFilter;
import net.sourceforge.fullsync.rules.filefilter.FileFilterManager;
import net.sourceforge.fullsync.rules.filefilter.FileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileModificationDateFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileNameFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FilePathFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileSizeFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileTypeFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.SubfilterFileFilerRule;
import net.sourceforge.fullsync.rules.filefilter.values.AgeValue;
import net.sourceforge.fullsync.rules.filefilter.values.DateValue;
import net.sourceforge.fullsync.rules.filefilter.values.FilterValue;
import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;
import net.sourceforge.fullsync.rules.filefilter.values.SizeValue;
import net.sourceforge.fullsync.rules.filefilter.values.TextValue;
import net.sourceforge.fullsync.rules.filefilter.values.TypeValue;
import net.sourceforge.fullsync.ui.FileFilterPage;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.filterrule.AgeValueRuleComposite;
import net.sourceforge.fullsync.ui.filterrule.DateValueRuleComposite;
import net.sourceforge.fullsync.ui.filterrule.RuleComposite;
import net.sourceforge.fullsync.ui.filterrule.SizeValueRuleComposite;
import net.sourceforge.fullsync.ui.filterrule.SubfilterRuleComposite;
import net.sourceforge.fullsync.ui.filterrule.TextValueRuleComposite;
import net.sourceforge.fullsync.ui.filterrule.TypeValueRuleComposite;
import net.sourceforge.fullsync.ui.filterrule.ValueChangedEvent;
import net.sourceforge.fullsync.ui.filterrule.ValueChangedListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FilterRuleListItem
implements ValueChangedListener {
    private static Hashtable<String, Class<? extends FileFilterRule>> rulesTable;
    private static Hashtable<String, String> ruleNamesConversionTable;
    private static Hashtable<String, String> reverseRuleNamesConversionTable;
    private static String[] ruleTypeNames;
    private static boolean initDone;
    private String ruleType;
    private int op;
    private OperandValue value;
    private RuleComposite ruleComposite;
    private final FileFilterPage root;
    private final FileFilterManager fileFilterManager;

    public FilterRuleListItem(FileFilterPage root, Composite composite, FileFilterManager fileFilterManager, String ruleType, int op, OperandValue value) {
        this.fileFilterManager = fileFilterManager;
        this.ruleType = ruleType;
        this.op = op;
        this.root = root;
        this.value = value;
        if (!initDone) {
            FilterRuleListItem.initConversionTables();
        }
        this.init(composite);
    }

    private static void initConversionTables() {
        ruleTypeNames = new String[7];
        FilterRuleListItem.ruleTypeNames[0] = Messages.getString("FilterRuleListItem.FileNameFilter");
        FilterRuleListItem.ruleTypeNames[1] = Messages.getString("FilterRuleListItem.FilePathFilter");
        FilterRuleListItem.ruleTypeNames[2] = Messages.getString("FilterRuleListItem.FileTypeFilter");
        FilterRuleListItem.ruleTypeNames[3] = Messages.getString("FilterRuleListItem.FilSizeFilter");
        FilterRuleListItem.ruleTypeNames[4] = Messages.getString("FilterRuleListItem.FileModificationDateFilter");
        FilterRuleListItem.ruleTypeNames[5] = Messages.getString("FilterRuleListItem.FileAgeFilter");
        FilterRuleListItem.ruleTypeNames[6] = Messages.getString("FilterRuleListItem.NestedFilter");
        rulesTable = new Hashtable(15, 0.75f);
        rulesTable.put(Messages.getString("FilterRuleListItem.FileNameFilter"), FileNameFileFilterRule.class);
        rulesTable.put(Messages.getString("FilterRuleListItem.FilePathFilter"), FilePathFileFilterRule.class);
        rulesTable.put(Messages.getString("FilterRuleListItem.FileTypeFilter"), FileTypeFileFilterRule.class);
        rulesTable.put(Messages.getString("FilterRuleListItem.FilSizeFilter"), FileSizeFileFilterRule.class);
        rulesTable.put(Messages.getString("FilterRuleListItem.FileModificationDateFilter"), FileModificationDateFileFilterRule.class);
        rulesTable.put(Messages.getString("FilterRuleListItem.FileAgeFilter"), FileAgeFileFilterRule.class);
        rulesTable.put(Messages.getString("FilterRuleListItem.NestedFilter"), SubfilterFileFilerRule.class);
        ruleNamesConversionTable = new Hashtable(15, 0.75f);
        ruleNamesConversionTable.put(FileNameFileFilterRule.typeName, Messages.getString("FilterRuleListItem.FileNameFilter"));
        ruleNamesConversionTable.put(FilePathFileFilterRule.typeName, Messages.getString("FilterRuleListItem.FilePathFilter"));
        ruleNamesConversionTable.put(FileTypeFileFilterRule.typeName, Messages.getString("FilterRuleListItem.FileTypeFilter"));
        ruleNamesConversionTable.put(FileSizeFileFilterRule.typeName, Messages.getString("FilterRuleListItem.FilSizeFilter"));
        ruleNamesConversionTable.put(FileModificationDateFileFilterRule.typeName, Messages.getString("FilterRuleListItem.FileModificationDateFilter"));
        ruleNamesConversionTable.put(FileAgeFileFilterRule.typeName, Messages.getString("FilterRuleListItem.FileAgeFilter"));
        ruleNamesConversionTable.put(SubfilterFileFilerRule.typeName, Messages.getString("FilterRuleListItem.NestedFilter"));
        reverseRuleNamesConversionTable = new Hashtable(15, 0.75f);
        reverseRuleNamesConversionTable.put(Messages.getString("FilterRuleListItem.FileNameFilter"), FileNameFileFilterRule.typeName);
        reverseRuleNamesConversionTable.put(Messages.getString("FilterRuleListItem.FilePathFilter"), FilePathFileFilterRule.typeName);
        reverseRuleNamesConversionTable.put(Messages.getString("FilterRuleListItem.FileTypeFilter"), FileTypeFileFilterRule.typeName);
        reverseRuleNamesConversionTable.put(Messages.getString("FilterRuleListItem.FilSizeFilter"), FileSizeFileFilterRule.typeName);
        reverseRuleNamesConversionTable.put(Messages.getString("FilterRuleListItem.FileModificationDateFilter"), FileModificationDateFileFilterRule.typeName);
        reverseRuleNamesConversionTable.put(Messages.getString("FilterRuleListItem.FileAgeFilter"), FileAgeFileFilterRule.typeName);
        reverseRuleNamesConversionTable.put(Messages.getString("FilterRuleListItem.NestedFilter"), SubfilterFileFilerRule.typeName);
        initDone = true;
    }

    private static Class<? extends FileFilterRule> getRuleClass(String typeName) {
        return rulesTable.get(ruleNamesConversionTable.get(typeName));
    }

    private static String getRuleTypeName(String guiName) {
        return reverseRuleNamesConversionTable.get(guiName);
    }

    private static String getRuleGUIName(String typeName) {
        return ruleNamesConversionTable.get(typeName);
    }

    public String getRuleType() {
        return this.ruleType;
    }

    public int getOperator() {
        return this.op;
    }

    public OperandValue getValue() {
        return this.value;
    }

    @Override
    public void onValueChanged(ValueChangedEvent evt) {
        this.value = evt.getValue();
    }

    public void init(Composite composite) {
        final FilterRuleListItem ruleItem = this;
        final Combo comboRuleTypes = new Combo(composite, 12);
        comboRuleTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FilterRuleListItem.this.ruleType = FilterRuleListItem.getRuleTypeName(comboRuleTypes.getText());
                FilterRuleListItem.this.root.recreateRuleList();
            }
        });
        comboRuleTypes.removeAll();
        for (String string : ruleTypeNames) {
            comboRuleTypes.add(string);
        }
        if (this.ruleType == null || "".equals(this.ruleType)) {
            comboRuleTypes.select(0);
            this.ruleType = FilterRuleListItem.getRuleTypeName(comboRuleTypes.getText());
        } else {
            comboRuleTypes.setText(FilterRuleListItem.getRuleGUIName(this.ruleType));
        }
        Class<? extends FileFilterRule> ruleClass = FilterRuleListItem.getRuleClass(this.ruleType);
        Combo comboOperators = null;
        if (!ruleClass.equals(SubfilterFileFilerRule.class)) {
            comboOperators = new Combo(composite, 12);
            comboOperators.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            final Combo comboOp = comboOperators;
            comboOperators.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    FilterRuleListItem.this.op = comboOp.getSelectionIndex();
                    comboOp.getParent().layout();
                }
            });
        }
        if (!ruleClass.equals(SubfilterFileFilerRule.class)) {
            String[] ops = this.fileFilterManager.getOperatorsForRuleType(this.ruleType);
            comboOperators.removeAll();
            for (String op2 : ops) {
                comboOperators.add(op2);
            }
            if (this.op < 0 || this.op >= comboOperators.getItemCount()) {
                this.op = 0;
            }
            comboOperators.select(this.op);
            if (ops.length == 0) {
                comboOperators.setVisible(false);
            }
        }
        if (ruleClass.equals(FileNameFileFilterRule.class) || ruleClass.equals(FilePathFileFilterRule.class)) {
            if (!(this.value instanceof TextValue)) {
                this.value = new TextValue();
            }
            this.ruleComposite = new TextValueRuleComposite(composite, 0, (TextValue)this.value);
            this.ruleComposite.addValueChangedListener(this);
        } else if (ruleClass.equals(FileTypeFileFilterRule.class)) {
            if (!(this.value instanceof TypeValue)) {
                this.value = new TypeValue();
            }
            this.ruleComposite = new TypeValueRuleComposite(composite, 0, (TypeValue)this.value);
            this.ruleComposite.addValueChangedListener(this);
        } else if (ruleClass.equals(FileSizeFileFilterRule.class)) {
            if (!(this.value instanceof SizeValue)) {
                this.value = new SizeValue();
            }
            this.ruleComposite = new SizeValueRuleComposite(composite, 0, (SizeValue)this.value);
            this.ruleComposite.addValueChangedListener(this);
        } else if (ruleClass.equals(FileAgeFileFilterRule.class)) {
            if (!(this.value instanceof AgeValue)) {
                this.value = new AgeValue();
            }
            this.ruleComposite = new AgeValueRuleComposite(composite, 0, (AgeValue)this.value);
            this.ruleComposite.addValueChangedListener(this);
        } else if (ruleClass.equals(FileModificationDateFileFilterRule.class)) {
            if (!(this.value instanceof DateValue)) {
                this.value = new DateValue(SystemDate.getInstance().currentTimeMillis());
            }
            this.ruleComposite = new DateValueRuleComposite(composite, 0, (DateValue)this.value);
            this.ruleComposite.addValueChangedListener(this);
        } else if (ruleClass.equals(SubfilterFileFilerRule.class)) {
            if (!(this.value instanceof FilterValue)) {
                this.value = new FilterValue(new FileFilter());
            }
            this.ruleComposite = new SubfilterRuleComposite(composite, 0, (FilterValue)this.value);
            this.ruleComposite.addValueChangedListener(this);
        } else {
            Composite valueComposite = new Composite(composite, 0);
            Text text = new Text(valueComposite, 2048);
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            text.setText("Missing Rule Composite");
            text.setEditable(false);
        }
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        ToolItem toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(GuiController.getInstance().getImage("Rule_Delete.png"));
        toolItem.setToolTipText(Messages.getString("FilterRuleListItem.Delete"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FilterRuleListItem.this.root.deleteRule(ruleItem);
            }
        });
        ToolItem toolItemAdd = new ToolItem(toolBar, 8);
        toolItemAdd.setImage(GuiController.getInstance().getImage("Rule_Add.png"));
        toolItemAdd.setToolTipText(Messages.getString("FilterRuleListItem.Add"));
        toolItemAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FilterRuleListItem.this.root.addRuleRow();
            }
        });
    }

    static {
        initDone = false;
    }
}

