/**
 * 数据库操作演示
 * 这里列举了常见数据库操作方法，方便大家学习。
 *
 * OpenAPI spec version: 1.0.0
 * Contact: monksoul@outlook.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *//* tslint:disable:no-unused-variable member-ordering */

import { Inject, Injectable, Optional }                      from '@angular/core';
import { HttpClient, HttpHeaders, HttpParams,
         HttpResponse, HttpEvent }                           from '@angular/common/http';
import { CustomHttpUrlEncodingCodec }                        from '../encoder';

import { Observable }                                        from 'rxjs';

import { PersonInputDto } from '../model/personInputDto';
import { RESTfulResult } from '../model/rESTfulResult';

import { BASE_PATH, COLLECTION_FORMATS }                     from '../variables';
import { Configuration }                                     from '../configuration';


@Injectable()
export class PersonService {

    protected basePath = '/';
    public defaultHeaders = new HttpHeaders();
    public configuration = new Configuration();

    constructor(protected httpClient: HttpClient, @Optional()@Inject(BASE_PATH) basePath: string, @Optional() configuration: Configuration) {
        if (basePath) {
            this.basePath = basePath;
        }
        if (configuration) {
            this.configuration = configuration;
            this.basePath = basePath || configuration.basePath || this.basePath;
        }
    }

    /**
     * @param consumes string[] mime-types
     * @return true: consumes contains 'multipart/form-data', false: otherwise
     */
    private canConsumeForm(consumes: string[]): boolean {
        const form = 'multipart/form-data';
        for (const consume of consumes) {
            if (form === consume) {
                return true;
            }
        }
        return false;
    }


    /**
     * 分页查询
     * 
     * @param pageindex 
     * @param pagesize 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonByPagePageindexPagesizeGet(pageindex: number, pagesize: number, observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonByPagePageindexPagesizeGet(pageindex: number, pagesize: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonByPagePageindexPagesizeGet(pageindex: number, pagesize: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonByPagePageindexPagesizeGet(pageindex: number, pagesize: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (pageindex === null || pageindex === undefined) {
            throw new Error('Required parameter pageindex was null or undefined when calling apiPersonByPagePageindexPagesizeGet.');
        }

        if (pagesize === null || pagesize === undefined) {
            throw new Error('Required parameter pagesize was null or undefined when calling apiPersonByPagePageindexPagesizeGet.');
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('get',`${this.basePath}/api/person/by-page/${encodeURIComponent(String(pageindex))}/${encodeURIComponent(String(pagesize))}`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 查询所有
     * 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonGet(observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonGet(observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonGet(observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonGet(observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('get',`${this.basePath}/api/person`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 删除一条
     * 
     * @param id 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonIdDelete(id: number, observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonIdDelete(id: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonIdDelete(id: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonIdDelete(id: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling apiPersonIdDelete.');
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('delete',`${this.basePath}/api/person/${encodeURIComponent(String(id))}`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 查询一条
     * 
     * @param id 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonIdGet(id: number, observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonIdGet(id: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonIdGet(id: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonIdGet(id: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling apiPersonIdGet.');
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('get',`${this.basePath}/api/person/${encodeURIComponent(String(id))}`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 新增一条
     * 
     * @param body 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonPost(body?: PersonInputDto, observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonPost(body?: PersonInputDto, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonPost(body?: PersonInputDto, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonPost(body?: PersonInputDto, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {


        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json-patch+json',
            'application/json',
            'text/json',
            'application/_*+json',
            'application/xml',
            'text/xml',
            'application/_*+xml'
        ];
        const httpContentTypeSelected: string | undefined = this.configuration.selectHeaderContentType(consumes);
        if (httpContentTypeSelected != undefined) {
            headers = headers.set('Content-Type', httpContentTypeSelected);
        }

        return this.httpClient.request<RESTfulResult>('post',`${this.basePath}/api/person`,
            {
                body: body,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 更新一条
     * 
     * @param body 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonPut(body?: PersonInputDto, observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonPut(body?: PersonInputDto, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonPut(body?: PersonInputDto, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonPut(body?: PersonInputDto, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {


        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json-patch+json',
            'application/json',
            'text/json',
            'application/_*+json',
            'application/xml',
            'text/xml',
            'application/_*+xml'
        ];
        const httpContentTypeSelected: string | undefined = this.configuration.selectHeaderContentType(consumes);
        if (httpContentTypeSelected != undefined) {
            headers = headers.set('Content-Type', httpContentTypeSelected);
        }

        return this.httpClient.request<RESTfulResult>('put',`${this.basePath}/api/person`,
            {
                body: body,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 搜索数据
     * 
     * @param name 
     * @param age 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonSearchPost(name?: string, age?: number, observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonSearchPost(name?: string, age?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonSearchPost(name?: string, age?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonSearchPost(name?: string, age?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {



        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }
        if (age !== undefined && age !== null) {
            queryParameters = queryParameters.set('age', <any>age);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('post',`${this.basePath}/api/person/search`,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

}
