/**
 * 数据库操作演示
 * 这里列举了常见数据库操作方法，方便大家学习。
 *
 * OpenAPI spec version: 1.0.0
 * Contact: monksoul@outlook.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *//* tslint:disable:no-unused-variable member-ordering */

import { Inject, Injectable, Optional }                      from '@angular/core';
import { HttpClient, HttpHeaders, HttpParams,
         HttpResponse, HttpEvent }                           from '@angular/common/http';
import { CustomHttpUrlEncodingCodec }                        from '../encoder';

import { Observable }                                        from 'rxjs';

import { RESTfulResult } from '../model/rESTfulResult';

import { BASE_PATH, COLLECTION_FORMATS }                     from '../variables';
import { Configuration }                                     from '../configuration';


@Injectable()
export class PersonRelationshipService {

    protected basePath = '/';
    public defaultHeaders = new HttpHeaders();
    public configuration = new Configuration();

    constructor(protected httpClient: HttpClient, @Optional()@Inject(BASE_PATH) basePath: string, @Optional() configuration: Configuration) {
        if (basePath) {
            this.basePath = basePath;
        }
        if (configuration) {
            this.configuration = configuration;
            this.basePath = basePath || configuration.basePath || this.basePath;
        }
    }

    /**
     * @param consumes string[] mime-types
     * @return true: consumes contains 'multipart/form-data', false: otherwise
     */
    private canConsumeForm(consumes: string[]): boolean {
        const form = 'multipart/form-data';
        for (const consume of consumes) {
            if (form === consume) {
                return true;
            }
        }
        return false;
    }


    /**
     * 内连接
     * 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonRelationshipInnerJoinPost(observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonRelationshipInnerJoinPost(observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonRelationshipInnerJoinPost(observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonRelationshipInnerJoinPost(observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('post',`${this.basePath}/api/person-relationship/inner-join`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 左连接
     * 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonRelationshipLeftJoinPost(observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonRelationshipLeftJoinPost(observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonRelationshipLeftJoinPost(observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonRelationshipLeftJoinPost(observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('post',`${this.basePath}/api/person-relationship/left-join`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 多对多
     * 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonRelationshipManyToManyPost(observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonRelationshipManyToManyPost(observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonRelationshipManyToManyPost(observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonRelationshipManyToManyPost(observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('post',`${this.basePath}/api/person-relationship/many-to-many`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 一对多
     * 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonRelationshipOneToManyPost(observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonRelationshipOneToManyPost(observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonRelationshipOneToManyPost(observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonRelationshipOneToManyPost(observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('post',`${this.basePath}/api/person-relationship/one-to-many`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 一对一
     * 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonRelationshipOneToOnePost(observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonRelationshipOneToOnePost(observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonRelationshipOneToOnePost(observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonRelationshipOneToOnePost(observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('post',`${this.basePath}/api/person-relationship/one-to-one`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 右连接
     * 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonRelationshipRightJoinPost(observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonRelationshipRightJoinPost(observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonRelationshipRightJoinPost(observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonRelationshipRightJoinPost(observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('post',`${this.basePath}/api/person-relationship/right-join`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 树形/递归查询
     * 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonRelationshipTreeSelectPost(observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonRelationshipTreeSelectPost(observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonRelationshipTreeSelectPost(observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonRelationshipTreeSelectPost(observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('post',`${this.basePath}/api/person-relationship/tree-select`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 读取视图
     * 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public apiPersonRelationshipVPersonGet(observe?: 'body', reportProgress?: boolean): Observable<RESTfulResult>;
    public apiPersonRelationshipVPersonGet(observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<RESTfulResult>>;
    public apiPersonRelationshipVPersonGet(observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<RESTfulResult>>;
    public apiPersonRelationshipVPersonGet(observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'text/plain',
            'application/json',
            'text/json',
            'application/xml',
            'text/xml'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.request<RESTfulResult>('get',`${this.basePath}/api/person-relationship/v-person`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

}
