import { uglify } from 'rollup-plugin-uglify';
import resolve from 'rollup-plugin-node-resolve';
import typescript from 'rollup-plugin-typescript';
import commonjs from '@rollup/plugin-commonjs';
import nodePolyfills from 'rollup-plugin-polyfill-node';
import { visualizer } from 'rollup-plugin-visualizer';

const isBundleVis = !!process.env.BUNDLE_VIS;

module.exports = [
  {
    input: 'src/index.ts',
    output: {
      file: 'dist/g2.min.js',
      name: 'G2',
      format: 'umd',
      sourcemap: false,
    },
    plugins: [
      nodePolyfills(),
      resolve(),
      commonjs(),
      typescript(),
      uglify(),
      ...(isBundleVis ? [visualizer()] : []),
    ],
  },
  {
    input: 'src/index.ts',
    output: {
      file: 'dist/g2-lite.min.js',
      name: 'G2',
      format: 'umd',
      sourcemap: false,
      globals: {
        '@antv/g': 'window.G',
        '@antv/g-canvas': 'window.G.Canvas2D',
      },
    },
    external: ['@antv/g', '@antv/g-canvas'],
    plugins: [nodePolyfills(), resolve(), commonjs(), typescript(), uglify()],
  },
];
