---
title: Chart
order: 2
---

Chart 用于提供创建 canvas、添加 Mark 标记、自适应图表大小等能力。

## 开始使用

```js
const chart = new Chart({
  container: 'container',
  width: 640,
  height: 480,
});

chart
  .interval()
  .data([
    { genre: 'Sports', sold: 275 },
    { genre: 'Strategy', sold: 115 },
    { genre: 'Action', sold: 120 },
    { genre: 'Shooter', sold: 350 },
    { genre: 'Other', sold: 150 },
  ])
  .encode('x', 'genre')
  .encode('y', 'sold')
  .encode('color', 'genre');

chart.render();
```

## 选项

| API       | 描述                                                                                                                                                                                          | 类型                    | 默认值 |
| --------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------- | ------ |
| container | 指定 chart 绘制的 DOM，可以传入 DOM id，也可以直接传入 dom 实例                                                                                                                               | `string \| HTMLElement` |        |
| width     | 图表宽度                                                                                                                                                                                      | `number`                | 640    |
| height    | 图表高度                                                                                                                                                                                      | `number`                | 480    |
| renderer  | 指定渲染引擎，默认使用 canvas。                                                                                                                                                               |                         |        |
| plugins   | 指定渲染时使用的插件 ，具体见 [plugin](/api/plugin/rough)                                                                                                                                     | `any[]`                 |        |
| autoFit   | 图表是否自适应容器宽高，默认为 `false`，用户需要手动设置 `width` 和 `height`。<br/>当 `autoFit: true` 时，会自动取图表容器的宽高，如果用户设置了 `height`，那么会以用户设置的 `height` 为准。 | `boolean`               | false  |
| padding   | 图表内边距                                                                                                                                                                                    | `number`                | 30     |

## 创建可视化

### new Chart

创建 Chart 实例。

### `chart.interval`

添加 interval 图形，具体见 [mark](/spec/mark/interval)。

### `chart.rect`

添加 rect 图形，具体见 [mark](/spec/mark/rect)。

### `chart.point`

添加 point 图形，具体见 [mark](/spec/mark/point)。

### `chart.area`

添加 area 图形，具体见 [mark](/spec/mark/area)。

### `chart.line`

添加 line 图形，具体见 [mark](/spec/mark/line)。

### `chart.vector`

添加 vector 图形，具体见 [mark](/spec/mark/vector)。

### `chart.link`

添加 link 图形，具体见 [mark](/spec/mark/link)。

### `chart.polygon`

添加 polygon 图形，具体见 [mark](/spec/mark/polygon)。

### `chart.image`

添加 image 图形，具体见 [mark](/spec/mark/image)。

### `chart.text`

添加 text 图形，具体见 [mark](/spec/mark/text)。

### `chart.lineX`

添加 lineX 图形，具体见 [mark](/spec/mark/lineX)。

### `chart.lineY`

添加 lineY 图形，具体见 [mark](/spec/mark/lineY)。

### `chart.range`

添加 range 图形，具体见 [mark](/spec/mark/range)。

### `chart.rangeX`

添加 rangeX 图形，具体见 [mark](/spec/mark/rangeX)。

### `chart.rangeY`

添加 rangeY 图形，具体见 [mark](/spec/mark/rangeY)。

### `chart.connector`

添加 connector 图形，具体见 [mark](/spec/mark/connector)。

### `chart.sankey`

添加 sankey 图形，具体见 [mark](/spec/mark/sankey)。

### `chart.treemap`

添加 treemap 图形，具体见 [mark](/spec/mark/treemap)。

### `chart.boxplot`

添加 boxplot 图形，具体见 [mark](/spec/mark/boxplot)。

### `chart.density`

添加 density 图形，具体见 [mark](/spec/mark/density)。

### `chart.heatmap`

添加 heatmap 图形，具体见 [mark](/spec/mark/heatmap)。

### `chart.shape`

添加 shape 图形，具体见 [mark](/spec/mark/shape)。

### `chart.pack`

添加 pack 图形，具体见 [mark](/spec/mark/pack)。

### `chart.forceGraph`

添加 forceGraph 图形，具体见 [mark](/spec/mark/forceGraph)。

### `chart.tree`

添加 tree 图形，具体见 [mark](/spec/mark/tree)。

### `chart.wordCloud`

添加 wordCloud 图形，具体见 [mark](/spec/mark/wordCloud)。

### `chart.gauge`

添加 gauge 图形，具体见 [mark](/spec/mark/gauge)。

### `chart.view`

添加 view 图形，具体见 [mark](/spec/mark/view)。

### `chart.spaceLayer`

添加 spaceLayer 图形，具体见 [mark](/spec/mark/spaceLayer)。

### `chart.spaceFlex`

添加 spaceFlex 图形，具体见 [mark](/spec/mark/spaceFlex)。

### `chart.facetRect`

添加 facetRect 图形，具体见 [mark](/spec/mark/facetRect)。

### `chart.facetCircle`

添加 facetCircle 图形，具体见 [mark](/spec/mark/facetCircle)。

### `chart.repeatMatrix`

添加 repeatMatrix 图形，具体见 [mark](/spec/mark/repeatMatrix)。

### `chart.geoView`

添加 geoView 图形，具体见 [mark](/spec/mark/geoView)。

### `chart.geoPath`

添加 geoPath 图形，具体见 [mark](/spec/mark/geoPath)。

### `chart.timingKeyframe`

添加 timingKeyframe 图形，具体见 [mark](/spec/mark/timingKeyframe)。

## 设置属性

### `chart.width`

设置或获取图表的 width。

### `chart.height`

设置或获取图表的 height。

### `chart.title`

设置或获取图表的 title。

### `chart.options`

获取图表的配置项。

### `chart.data`

设置图形的数据，支持多种数据来源和数据变换，具体见 [data](/api/data/overview)。

### `chart.encode`

设置图形每个通道的字段名称，具体见 [encode](/api/encode/overview)。

### `chart.scale`

设置图形每个通道的比例尺，具体见 [scale](/api/scale/overview)。

### `chart.legend`

设置图形的图例，具体见 [legend](/api/component/legend)。

### `chart.tooltip`

设置图形的 Tooltip，具体见 [tooltip](/api/component/tooltip/overview)。

### `chart.axis`

设置图形的坐标轴，具体见 [axis](/api/component/axis)。

### `chart.slider`

设置图形的坐标轴，具体见 [slider](/api/component/slider)。

### `chart.label`

设置图形的标签，具体见 [label](/api/label/overview)。

### `chart.style`

设置图形的样式，具体见 [style](/api/style/overview)。

### `chart.theme`

设置图形的主题，具体见 [style](/api/theme/overview)。

### `chart.labelTransform`

设置图形的 labelTransform，具体见 [label](/spec/label/overview)

## 渲染图表

### `chart.render`

调用图表的渲染方法。

### `chart.destroy`

销毁图表容器和 Canvas 画布。

### `chart.clear`

清空图表配置和 Canvas 画布。

### `chart.show`

显示当前节点渲染的图形。

### `chart.hide`

隐藏当前节点渲染的图形。

### `chart.changeData`

更改图形的数据来源并重新渲染整个图表。

### `chart.changeSize`

改变图表的宽高，并重新渲染。

### `chart.forceFit`

自动根据外部 DOM 容器大小调整画布并重新渲染。

## 获取实例

### `chart.getContainer`

获取图表的 HTML 容器。

### `chart.getContext`

返回 chart 的 context 信息。

### `chart.getView`

返回 chart 渲染时的 view 实例。

### `chart.getCoordinate`

返回 chart 渲染时的 coordinate 实例。

### `chart.getTheme`

返回 chart 渲染时的 theme 实例。

### `chart.getGroup`

返回 chart 渲染时的 canvas group 实例。

### `chart.getScale`

返回 chart 渲染时所有的 scale 实例。

### `chart.getScaleByChannel`

通过通道名称查找返回 chart 渲染时对应的 scale 实例。

### `chart.on`

监听 chart 上的事件。

### `chart.once`

监听 chart 上的事件，仅触发一次。

### `chart.emit`

触发 chart 上的事件。

### `chart.off`

写在 chart 上的监听事件。

### `chart.getNodesByType`

通过 type 查找所有的 node 子节点。

### `chart.getNodeByKey`

通过 key 找到当前 node 的子节点。

### `chart.append`

创建一个新的 Node 并添加在 chart 的子节点上。

## 事件

## 生命周期事件

| 事件               | 描述                             |
| ------------------ | -------------------------------- |
| `beforerender`     | 图表渲染前执行该事件             |
| `afterrender`      | 图表渲染后执行该事件             |
| `beforepaint`      | 图表布局计算后，绘制前执行该事件 |
| `afterpaint`       | 图表绘制后执行该事件             |
| `beforechangedata` | 图表更新数据前执行该事件         |
| `afterchangedata`  | 图表更新数据后执行该事件         |
| `beforechangesize` | 图表更新尺寸前执行该事件         |
| `afterchangesize`  | 图表更新尺寸后执行该事件         |
| `beforedestroy`    | 图表销毁前执行该事件             |
| `afterdestroy`     | 图表销毁后执行该事件             |

通过 `chart.on()` 来申明生命周期事件。例如：

```js
chart.on('afterrender', (e) => {
  console.log('Chart has been rendered!');
});
```

## UI 事件

## FAQ

- 如何使用 svg 进行图表渲染？

```js
import { Renderer as GRenderer } from '@antv/g-svg';
const chart = new Chart({
  container: 'container',
  width: 640,
  height: 480,
  renderer: GRenderer,
});

chart
  .interval()
  .data([
    { genre: 'Sports', sold: 275 },
    { genre: 'Strategy', sold: 115 },
    { genre: 'Action', sold: 120 },
    { genre: 'Shooter', sold: 350 },
    { genre: 'Other', sold: 150 },
  ])
  .encode('x', 'genre')
  .encode('y', 'sold')
  .encode('color', 'genre');

chart.render();
```
