/*
 JSZip v3.1.5 - A JavaScript class for generating and reading zip files
<http://stuartk.com/jszip>

(c) 2009-2016 Stuart Knightley <stuart [at] stuartk.com>
Dual licenced under the MIT license or GPLv3. See https://raw.github.com/Stuk/jszip/master/LICENSE.markdown.

JSZip uses the library pako released under the MIT license :
https://github.com/nodeca/pako/blob/master/LICENSE
*/
'use strict';(function(R){"object"===typeof exports&&"undefined"!==typeof module?module.exports=R():"function"===typeof define&&define.amd?define([],R):("undefined"!==typeof window?window:"undefined"!==typeof global?global:"undefined"!==typeof self?self:this).JSZip=R()})(function(){return function c(a,p,f){function d(l,m){if(!p[l]){if(!a[l]){var h="function"==typeof require&&require;if(!m&&h)return h(l,!0);if(b)return b(l,!0);m=Error("Cannot find module '"+l+"'");throw m.code="MODULE_NOT_FOUND",m;
}m=p[l]={exports:{}};a[l][0].call(m.exports,function(b){var k=a[l][1][b];return d(k?k:b)},m,m.exports,c,a,p,f)}return p[l].exports}for(var b="function"==typeof require&&require,l=0;l<f.length;l++)d(f[l]);return d}({1:[function(a,p,f){var c=a("./utils"),d=a("./support");f.encode=function(b){for(var a=[],d,m,h,q,k=0,x=b.length,H,f="string"!==c.getTypeOf(b);k<b.length;)H=x-k,f?(d=b[k++],m=k<x?b[k++]:0,h=k<x?b[k++]:0):(d=b.charCodeAt(k++),m=k<x?b.charCodeAt(k++):0,h=k<x?b.charCodeAt(k++):0),q=d>>2,d=
(d&3)<<4|m>>4,m=1<H?(m&15)<<2|h>>6:64,h=2<H?h&63:64,a.push("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(q)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(d)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(m)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(h));return a.join("")};f.decode=function(b){var c=0,a=0;if("data:"===b.substr(0,5))throw Error("Invalid base64 input, it looks like a data url.");
b=b.replace(/[^A-Za-z0-9\+\/=]/g,"");var m=3*b.length/4;"="===b.charAt(b.length-1)&&m--;"="===b.charAt(b.length-2)&&m--;if(0!==m%1)throw Error("Invalid base64 input, bad content length.");var h;for(h=d.uint8array?new Uint8Array(m|0):Array(m|0);c<b.length;){var q="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(b.charAt(c++));var k="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(b.charAt(c++));m="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(b.charAt(c++));
var x="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(b.charAt(c++));q=q<<2|k>>4;k=(k&15)<<4|m>>2;var H=(m&3)<<6|x;h[a++]=q;64!==m&&(h[a++]=k);64!==x&&(h[a++]=H)}return h}},{"./support":30,"./utils":32}],2:[function(a,p,f){function c(b,c,a,k,x){this.compressedSize=b;this.uncompressedSize=c;this.crc32=a;this.compression=k;this.compressedContent=x}var d=a("./external"),b=a("./stream/DataWorker"),l=a("./stream/DataLengthProbe"),n=a("./stream/Crc32Probe");l=a("./stream/DataLengthProbe");
c.prototype={getContentWorker:function(){var c=(new b(d.Promise.resolve(this.compressedContent))).pipe(this.compression.uncompressWorker()).pipe(new l("data_length")),a=this;c.on("end",function(){if(this.streamInfo.data_length!==a.uncompressedSize)throw Error("Bug : uncompressed data size mismatch");});return c},getCompressedWorker:function(){return(new b(d.Promise.resolve(this.compressedContent))).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",
this.crc32).withStreamInfo("compression",this.compression)}};c.createWorkerFrom=function(b,c,a){return b.pipe(new n).pipe(new l("uncompressedSize")).pipe(c.compressWorker(a)).pipe(new l("compressedSize")).withStreamInfo("compression",c)};p.exports=c},{"./external":6,"./stream/Crc32Probe":25,"./stream/DataLengthProbe":26,"./stream/DataWorker":27}],3:[function(a,p,f){var c=a("./stream/GenericWorker");f.STORE={magic:"\x00\x00",compressWorker:function(a){return new c("STORE compression")},uncompressWorker:function(){return new c("STORE decompression")}};
f.DEFLATE=a("./flate")},{"./flate":7,"./stream/GenericWorker":28}],4:[function(a,p,f){var c=a("./utils"),d=function(){for(var b,c=[],a=0;256>a;a++){b=a;for(var d=0;8>d;d++)b=b&1?3988292384^b>>>1:b>>>1;c[a]=b}return c}();p.exports=function(b,a){if("undefined"===typeof b||!b.length)return 0;if("string"!==c.getTypeOf(b)){var l=0+b.length;a=(a|0)^-1;for(var m=0;m<l;m++)a=a>>>8^d[(a^b[m])&255];return a^-1}l=0+b.length;a=(a|0)^-1;for(m=0;m<l;m++)a=a>>>8^d[(a^b.charCodeAt(m))&255];return a^-1}},{"./utils":32}],
5:[function(a,p,f){f.base64=!1;f.binary=!1;f.dir=!1;f.createFolders=!0;f.date=null;f.compression=null;f.compressionOptions=null;f.comment=null;f.unixPermissions=null;f.dosPermissions=null},{}],6:[function(a,p,f){a="undefined"!==typeof Promise?Promise:a("lie");p.exports={Promise:a}},{lie:58}],7:[function(a,p,f){function c(b,a){l.call(this,"FlateWorker/"+b);this._pako=null;this._pakoAction=b;this._pakoOptions=a;this.meta={}}p="undefined"!==typeof Uint8Array&&"undefined"!==typeof Uint16Array&&"undefined"!==
typeof Uint32Array;var d=a("pako"),b=a("./utils"),l=a("./stream/GenericWorker"),n=p?"uint8array":"array";f.magic="\b\x00";b.inherits(c,l);c.prototype.processChunk=function(a){this.meta=a.meta;null===this._pako&&this._createPako();this._pako.push(b.transformTo(n,a.data),!1)};c.prototype.flush=function(){l.prototype.flush.call(this);null===this._pako&&this._createPako();this._pako.push([],!0)};c.prototype.cleanUp=function(){l.prototype.cleanUp.call(this);this._pako=null};c.prototype._createPako=function(){this._pako=
new d[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var b=this;this._pako.onData=function(a){b.push({data:a,meta:b.meta})}};f.compressWorker=function(b){return new c("Deflate",b)};f.uncompressWorker=function(){return new c("Inflate",{})}},{"./stream/GenericWorker":28,"./utils":32,pako:59}],8:[function(a,p,f){function c(a,c,k,d){b.call(this,"ZipFileWorker");this.bytesWritten=0;this.zipComment=c;this.zipPlatform=k;this.encodeFileName=d;this.streamFiles=a;this.accumulate=!1;this.contentBuffer=
[];this.dirRecords=[];this.entriesCount=this.currentSourceOffset=0;this.currentFile=null;this._sources=[]}var d=a("../utils"),b=a("../stream/GenericWorker"),l=a("../utf8"),n=a("../crc32"),m=a("../signature"),h=function(b,a){var c="",k;for(k=0;k<a;k++)c+=String.fromCharCode(b&255),b>>>=8;return c},q=function(b,a,c,k,y,D){var e=b.file,x=b.compression,H=D!==l.utf8encode,C=d.transformTo("string",D(e.name)),q=d.transformTo("string",l.utf8encode(e.name)),g=e.comment;D=d.transformTo("string",D(g));var f=
d.transformTo("string",l.utf8encode(g)),G=q.length!==e.name.length,v=f.length!==g.length;g="";var M=e.dir;var B=e.date,w=0,u=0,t=0;if(!a||c)w=b.crc32,u=b.compressedSize,t=b.uncompressedSize;b=0;a&&(b|=8);H||!G&&!v||(b|=2048);a=0;M&&(a|=16);"UNIX"===y?(y=798,(H=e=e.unixPermissions)||(H=M?16893:33204),a|=(H&65535)<<16):(y=20,a|=(e.dosPermissions||0)&63);e=B.getUTCHours();e=e<<6|B.getUTCMinutes();e=e<<5|B.getUTCSeconds()/2;M=B.getUTCFullYear()-1980;M=M<<4|B.getUTCMonth()+1;M=M<<5|B.getUTCDate();G&&(q=
h(1,1)+h(n(C),4)+q,g+="up"+h(q.length,2)+q);v&&(q=h(1,1)+h(n(D),4)+f,g+="uc"+h(q.length,2)+q);q="\n\x00"+h(b,2);q+=x.magic;q+=h(e,2);q+=h(M,2);q+=h(w,4);q+=h(u,4);q+=h(t,4);q+=h(C.length,2);q+=h(g.length,2);x=m.LOCAL_FILE_HEADER+q+C+g;k=m.CENTRAL_FILE_HEADER+h(y,2)+q+h(D.length,2)+"\x00\x00\x00\x00"+h(a,4)+h(k,4)+C+g+D;return{fileRecord:x,dirRecord:k}},k=function(b){return m.DATA_DESCRIPTOR+h(b.crc32,4)+h(b.compressedSize,4)+h(b.uncompressedSize,4)};d.inherits(c,b);c.prototype.push=function(a){var c=
a.meta.percent||0,k=this.entriesCount,d=this._sources.length;this.accumulate?this.contentBuffer.push(a):(this.bytesWritten+=a.data.length,b.prototype.push.call(this,{data:a.data,meta:{currentFile:this.currentFile,percent:k?(c+100*(k-d-1))/k:100}}))};c.prototype.openedSource=function(b){this.currentSourceOffset=this.bytesWritten;this.currentFile=b.file.name;var a=this.streamFiles&&!b.file.dir;a?(b=q(b,a,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName),this.push({data:b.fileRecord,
meta:{percent:0}})):this.accumulate=!0};c.prototype.closedSource=function(b){this.accumulate=!1;var a=this.streamFiles&&!b.file.dir,c=q(b,a,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.dirRecords.push(c.dirRecord);if(a)this.push({data:k(b),meta:{percent:100}});else for(this.push({data:c.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null};c.prototype.flush=function(){for(var b=this.bytesWritten,a=0;a<this.dirRecords.length;a++)this.push({data:this.dirRecords[a],
meta:{percent:100}});a=this.dirRecords.length;var c=this.bytesWritten-b,k=d.transformTo("string",(0,this.encodeFileName)(this.zipComment));b=m.CENTRAL_DIRECTORY_END+"\x00\x00\x00\x00"+h(a,2)+h(a,2)+h(c,4)+h(b,4)+h(k.length,2)+k;this.push({data:b,meta:{percent:100}})};c.prototype.prepareNextSource=function(){this.previous=this._sources.shift();this.openedSource(this.previous.streamInfo);this.isPaused?this.previous.pause():this.previous.resume()};c.prototype.registerPrevious=function(b){this._sources.push(b);
var a=this;b.on("data",function(b){a.processChunk(b)});b.on("end",function(){a.closedSource(a.previous.streamInfo);a._sources.length?a.prepareNextSource():a.end()});b.on("error",function(b){a.error(b)});return this};c.prototype.resume=function(){if(!b.prototype.resume.call(this))return!1;if(!this.previous&&this._sources.length)return this.prepareNextSource(),!0;if(!this.previous&&!this._sources.length&&!this.generatedError)return this.end(),!0};c.prototype.error=function(a){var c=this._sources;if(!b.prototype.error.call(this,
a))return!1;for(var k=0;k<c.length;k++)try{c[k].error(a)}catch(C){}return!0};c.prototype.lock=function(){b.prototype.lock.call(this);for(var a=this._sources,c=0;c<a.length;c++)a[c].lock()};p.exports=c},{"../crc32":4,"../signature":23,"../stream/GenericWorker":28,"../utf8":31,"../utils":32}],9:[function(a,p,f){var c=a("../compressions"),d=a("./ZipFileWorker");f.generateWorker=function(b,a,n){var l=new d(a.streamFiles,n,a.platform,a.encodeFileName),h=0;try{b.forEach(function(b,k){h++;var d=k.options.compression||
a.compression,q=c[d];if(!q)throw Error(d+" is not a valid compression method !");d=k.dir;var n=k.date;k._compressWorker(q,k.options.compressionOptions||a.compressionOptions||{}).withStreamInfo("file",{name:b,dir:d,date:n,comment:k.comment||"",unixPermissions:k.unixPermissions,dosPermissions:k.dosPermissions}).pipe(l)}),l.entriesCount=h}catch(q){l.error(q)}return l}},{"../compressions":3,"./ZipFileWorker":8}],10:[function(a,p,f){function c(){if(!(this instanceof c))return new c;if(arguments.length)throw Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");
this.files={};this.comment=null;this.root="";this.clone=function(){var a=new c,b;for(b in this)"function"!==typeof this[b]&&(a[b]=this[b]);return a}}c.prototype=a("./object");c.prototype.loadAsync=a("./load");c.support=a("./support");c.defaults=a("./defaults");c.version="3.1.5";c.loadAsync=function(a,b){return(new c).loadAsync(a,b)};c.external=a("./external");p.exports=c},{"./defaults":5,"./external":6,"./load":11,"./object":15,"./support":30}],11:[function(a,p,f){function c(a){return new b.Promise(function(b,
c){var k=a.decompressed.getContentWorker().pipe(new m);k.on("error",function(b){c(b)}).on("end",function(){k.streamInfo.crc32!==a.decompressed.crc32?c(Error("Corrupted zip : CRC32 mismatch")):b()}).resume()})}var d=a("./utils"),b=a("./external"),l=a("./utf8");d=a("./utils");var n=a("./zipEntries"),m=a("./stream/Crc32Probe"),h=a("./nodejsUtils");p.exports=function(a,k){var x=this;k=d.extend(k||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:l.utf8decode});return h.isNode&&
h.isStream(a)?b.Promise.reject(Error("JSZip can't accept a stream when loading a zip file.")):d.prepareContent("the loaded zip file",a,!0,k.optimizedBinaryString,k.base64).then(function(b){var a=new n(k);a.load(b);return a}).then(function(a){var d=[b.Promise.resolve(a)];a=a.files;if(k.checkCRC32)for(var h=0;h<a.length;h++)d.push(c(a[h]));return b.Promise.all(d)}).then(function(b){b=b.shift();for(var a=b.files,c=0;c<a.length;c++){var d=a[c];x.file(d.fileNameStr,d.decompressed,{binary:!0,optimizedBinaryString:!0,
date:d.date,dir:d.dir,comment:d.fileCommentStr.length?d.fileCommentStr:null,unixPermissions:d.unixPermissions,dosPermissions:d.dosPermissions,createFolders:k.createFolders})}b.zipComment.length&&(x.comment=b.zipComment);return x})}},{"./external":6,"./nodejsUtils":14,"./stream/Crc32Probe":25,"./utf8":31,"./utils":32,"./zipEntries":33}],12:[function(a,p,f){function c(b,a){d.call(this,"Nodejs stream input adapter for "+b);this._upstreamEnded=!1;this._bindStream(a)}f=a("../utils");var d=a("../stream/GenericWorker");
f.inherits(c,d);c.prototype._bindStream=function(b){var a=this;this._stream=b;b.pause();b.on("data",function(b){a.push({data:b,meta:{percent:0}})}).on("error",function(b){a.isPaused?this.generatedError=b:a.error(b)}).on("end",function(){a.isPaused?a._upstreamEnded=!0:a.end()})};c.prototype.pause=function(){if(!d.prototype.pause.call(this))return!1;this._stream.pause();return!0};c.prototype.resume=function(){if(!d.prototype.resume.call(this))return!1;this._upstreamEnded?this.end():this._stream.resume();
return!0};p.exports=c},{"../stream/GenericWorker":28,"../utils":32}],13:[function(a,p,f){function c(b,a,c){d.call(this,a);this._helper=b;var l=this;b.on("data",function(b,a){l.push(b)||l._helper.pause();c&&c(a)}).on("error",function(b){l.emit("error",b)}).on("end",function(){l.push(null)})}var d=a("readable-stream").Readable;a("../utils").inherits(c,d);c.prototype._read=function(){this._helper.resume()};p.exports=c},{"../utils":32,"readable-stream":16}],14:[function(a,p,f){p.exports={isNode:"undefined"!==
typeof Buffer,newBufferFrom:function(a,d){return new Buffer(a,d)},allocBuffer:function(a){return Buffer.alloc?Buffer.alloc(a):new Buffer(a)},isBuffer:function(a){return Buffer.isBuffer(a)},isStream:function(a){return a&&"function"===typeof a.on&&"function"===typeof a.pause&&"function"===typeof a.resume}}},{}],15:[function(a,p,f){var c=a("./utf8"),d=a("./utils"),b=a("./stream/GenericWorker"),l=a("./stream/StreamHelper"),n=a("./defaults"),m=a("./compressedObject"),h=a("./zipObject"),q=a("./generate"),
k=a("./nodejsUtils"),x=a("./nodejs/NodejsStreamInputAdapter"),H=function(a,c,e){var l=d.getTypeOf(c),y=d.extend(e||{},n);y.date=y.date||new Date;null!==y.compression&&(y.compression=y.compression.toUpperCase());"string"===typeof y.unixPermissions&&(y.unixPermissions=parseInt(y.unixPermissions,8));y.unixPermissions&&y.unixPermissions&16384&&(y.dir=!0);y.dosPermissions&&y.dosPermissions&16&&(y.dir=!0);y.dir&&(a=G(a));var q;if(q=y.createFolders){var D=a;"/"===D.slice(-1)&&(D=D.substring(0,D.length-1));
q=D.lastIndexOf("/");q=D=0<q?D.substring(0,q):""}q&&C.call(this,D,!0);l="string"===l&&!1===y.binary&&!1===y.base64;e&&"undefined"!==typeof e.binary||(y.binary=!l);if(c instanceof m&&0===c.uncompressedSize||y.dir||!c||0===c.length)y.base64=!1,y.binary=!0,c="",y.compression="STORE";c=c instanceof m||c instanceof b?c:k.isNode&&k.isStream(c)?new x(a,c):d.prepareContent(a,c,y.binary,y.optimizedBinaryString,y.base64);y=new h(a,c,y);this.files[a]=y},G=function(b){"/"!==b.slice(-1)&&(b+="/");return b},C=
function(b,a){a="undefined"!==typeof a?a:n.createFolders;b=G(b);this.files[b]||H.call(this,b,null,{dir:!0,createFolders:a});return this.files[b]};p.exports={load:function(){throw Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");},forEach:function(b){var a,c;for(a in this.files)if(this.files.hasOwnProperty(a)){var k=this.files[a];(c=a.slice(this.root.length,a.length))&&a.slice(0,this.root.length)===this.root&&b(c,k)}},filter:function(b){var a=[];this.forEach(function(c,
k){b(c,k)&&a.push(k)});return a},file:function(b,a,c){if(1===arguments.length){if("[object RegExp]"===Object.prototype.toString.call(b)){var k=b;return this.filter(function(b,a){return!a.dir&&k.test(b)})}var e=this.files[this.root+b];return e&&!e.dir?e:null}b=this.root+b;H.call(this,b,a,c);return this},folder:function(b){if(!b)return this;if("[object RegExp]"===Object.prototype.toString.call(b))return this.filter(function(a,c){return c.dir&&b.test(a)});var a=C.call(this,this.root+b),c=this.clone();
c.root=a.name;return c},remove:function(b){b=this.root+b;var a=this.files[b];a||("/"!==b.slice(-1)&&(b+="/"),a=this.files[b]);if(a&&!a.dir)delete this.files[b];else{a=this.filter(function(a,c){return c.name.slice(0,b.length)===b});for(var c=0;c<a.length;c++)delete this.files[a[c].name]}return this},generate:function(b){throw Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");},generateInternalStream:function(a){var k={};try{k=d.extend(a||{},{streamFiles:!1,compression:"STORE",
compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:c.utf8encode});k.type=k.type.toLowerCase();k.compression=k.compression.toUpperCase();"binarystring"===k.type&&(k.type="string");if(!k.type)throw Error("No output type specified.");d.checkSupport(k.type);if("darwin"===k.platform||"freebsd"===k.platform||"linux"===k.platform||"sunos"===k.platform)k.platform="UNIX";"win32"===k.platform&&(k.platform="DOS");var e=q.generateWorker(this,k,k.comment||this.comment||
"")}catch(K){e=new b("error"),e.error(K)}return new l(e,k.type||"string",k.mimeType)},generateAsync:function(b,a){return this.generateInternalStream(b).accumulate(a)},generateNodeStream:function(b,a){b=b||{};b.type||(b.type="nodebuffer");return this.generateInternalStream(b).toNodejsStream(a)}}},{"./compressedObject":2,"./defaults":5,"./generate":9,"./nodejs/NodejsStreamInputAdapter":12,"./nodejsUtils":14,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31,"./utils":32,"./zipObject":35}],
16:[function(a,p,f){p.exports=a("stream")},{stream:void 0}],17:[function(a,p,f){function c(b){d.call(this,b);for(var a=0;a<this.data.length;a++)b[a]&=255}var d=a("./DataReader");a("../utils").inherits(c,d);c.prototype.byteAt=function(b){return this.data[this.zero+b]};c.prototype.lastIndexOfSignature=function(b){var a=b.charCodeAt(0),c=b.charCodeAt(1),d=b.charCodeAt(2);b=b.charCodeAt(3);for(var h=this.length-4;0<=h;--h)if(this.data[h]===a&&this.data[h+1]===c&&this.data[h+2]===d&&this.data[h+3]===b)return h-
this.zero;return-1};c.prototype.readAndCheckSignature=function(b){var a=b.charCodeAt(0),c=b.charCodeAt(1),d=b.charCodeAt(2);b=b.charCodeAt(3);var h=this.readData(4);return a===h[0]&&c===h[1]&&d===h[2]&&b===h[3]};c.prototype.readData=function(b){this.checkOffset(b);if(0===b)return[];var a=this.data.slice(this.zero+this.index,this.zero+this.index+b);this.index+=b;return a};p.exports=c},{"../utils":32,"./DataReader":18}],18:[function(a,p,f){function c(b){this.data=b;this.length=b.length;this.zero=this.index=
0}var d=a("../utils");c.prototype={checkOffset:function(b){this.checkIndex(this.index+b)},checkIndex:function(b){if(this.length<this.zero+b||0>b)throw Error("End of data reached (data length = "+this.length+", asked index = "+b+"). Corrupted zip ?");},setIndex:function(b){this.checkIndex(b);this.index=b},skip:function(b){this.setIndex(this.index+b)},byteAt:function(b){},readInt:function(b){var a=0,c;this.checkOffset(b);for(c=this.index+b-1;c>=this.index;c--)a=(a<<8)+this.byteAt(c);this.index+=b;return a},
readString:function(b){return d.transformTo("string",this.readData(b))},readData:function(b){},lastIndexOfSignature:function(b){},readAndCheckSignature:function(b){},readDate:function(){var b=this.readInt(4);return new Date(Date.UTC((b>>25&127)+1980,(b>>21&15)-1,b>>16&31,b>>11&31,b>>5&63,(b&31)<<1))}};p.exports=c},{"../utils":32}],19:[function(a,p,f){function c(b){d.call(this,b)}var d=a("./Uint8ArrayReader");a("../utils").inherits(c,d);c.prototype.readData=function(b){this.checkOffset(b);var a=this.data.slice(this.zero+
this.index,this.zero+this.index+b);this.index+=b;return a};p.exports=c},{"../utils":32,"./Uint8ArrayReader":21}],20:[function(a,p,f){function c(b){d.call(this,b)}var d=a("./DataReader");a("../utils").inherits(c,d);c.prototype.byteAt=function(b){return this.data.charCodeAt(this.zero+b)};c.prototype.lastIndexOfSignature=function(b){return this.data.lastIndexOf(b)-this.zero};c.prototype.readAndCheckSignature=function(b){var a=this.readData(4);return b===a};c.prototype.readData=function(b){this.checkOffset(b);
var a=this.data.slice(this.zero+this.index,this.zero+this.index+b);this.index+=b;return a};p.exports=c},{"../utils":32,"./DataReader":18}],21:[function(a,p,f){function c(b){d.call(this,b)}var d=a("./ArrayReader");a("../utils").inherits(c,d);c.prototype.readData=function(b){this.checkOffset(b);if(0===b)return new Uint8Array(0);var a=this.data.subarray(this.zero+this.index,this.zero+this.index+b);this.index+=b;return a};p.exports=c},{"../utils":32,"./ArrayReader":17}],22:[function(a,p,f){var c=a("../utils"),
d=a("../support"),b=a("./ArrayReader"),l=a("./StringReader"),n=a("./NodeBufferReader"),m=a("./Uint8ArrayReader");p.exports=function(a){var h=c.getTypeOf(a);c.checkSupport(h);return"string"!==h||d.uint8array?"nodebuffer"===h?new n(a):d.uint8array?new m(c.transformTo("uint8array",a)):new b(c.transformTo("array",a)):new l(a)}},{"../support":30,"../utils":32,"./ArrayReader":17,"./NodeBufferReader":19,"./StringReader":20,"./Uint8ArrayReader":21}],23:[function(a,p,f){f.LOCAL_FILE_HEADER="PK\u0003\u0004";
f.CENTRAL_FILE_HEADER="PK\u0001\u0002";f.CENTRAL_DIRECTORY_END="PK\u0005\u0006";f.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK\u0006\u0007";f.ZIP64_CENTRAL_DIRECTORY_END="PK\u0006\u0006";f.DATA_DESCRIPTOR="PK\u0007\b"},{}],24:[function(a,p,f){function c(a){d.call(this,"ConvertWorker to "+a);this.destType=a}var d=a("./GenericWorker"),b=a("../utils");b.inherits(c,d);c.prototype.processChunk=function(a){this.push({data:b.transformTo(this.destType,a.data),meta:a.meta})};p.exports=c},{"../utils":32,"./GenericWorker":28}],
25:[function(a,p,f){function c(){d.call(this,"Crc32Probe");this.withStreamInfo("crc32",0)}var d=a("./GenericWorker"),b=a("../crc32");a("../utils").inherits(c,d);c.prototype.processChunk=function(a){this.streamInfo.crc32=b(a.data,this.streamInfo.crc32||0);this.push(a)};p.exports=c},{"../crc32":4,"../utils":32,"./GenericWorker":28}],26:[function(a,p,f){function c(a){d.call(this,"DataLengthProbe for "+a);this.propName=a;this.withStreamInfo(a,0)}f=a("../utils");var d=a("./GenericWorker");f.inherits(c,
d);c.prototype.processChunk=function(a){a&&(this.streamInfo[this.propName]=(this.streamInfo[this.propName]||0)+a.data.length);d.prototype.processChunk.call(this,a)};p.exports=c},{"../utils":32,"./GenericWorker":28}],27:[function(a,p,f){function c(a){b.call(this,"DataWorker");var c=this;this.dataIsReady=!1;this.max=this.index=0;this.data=null;this.type="";this._tickScheduled=!1;a.then(function(a){c.dataIsReady=!0;c.data=a;c.max=a&&a.length||0;c.type=d.getTypeOf(a);c.isPaused||c._tickAndRepeat()},function(a){c.error(a)})}
var d=a("../utils"),b=a("./GenericWorker");d.inherits(c,b);c.prototype.cleanUp=function(){b.prototype.cleanUp.call(this);this.data=null};c.prototype.resume=function(){if(!b.prototype.resume.call(this))return!1;!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,d.delay(this._tickAndRepeat,[],this));return!0};c.prototype._tickAndRepeat=function(){this._tickScheduled=!1;this.isPaused||this.isFinished||(this._tick(),this.isFinished||(d.delay(this._tickAndRepeat,[],this),this._tickScheduled=
!0))};c.prototype._tick=function(){if(this.isPaused||this.isFinished)return!1;var a=null,b=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case "string":a=this.data.substring(this.index,b);break;case "uint8array":a=this.data.subarray(this.index,b);break;case "array":case "nodebuffer":a=this.data.slice(this.index,b)}this.index=b;return this.push({data:a,meta:{percent:this.max?this.index/this.max*100:0}})};p.exports=c},{"../utils":32,"./GenericWorker":28}],
28:[function(a,p,f){function c(a){this.name=a||"default";this.streamInfo={};this.generatedError=null;this.extraStreamInfo={};this.isPaused=!0;this.isLocked=this.isFinished=!1;this._listeners={data:[],end:[],error:[]};this.previous=null}c.prototype={push:function(a){this.emit("data",a)},end:function(){if(this.isFinished)return!1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0}catch(d){this.emit("error",d)}return!0},error:function(a){if(this.isFinished)return!1;this.isPaused?this.generatedError=
a:(this.isFinished=!0,this.emit("error",a),this.previous&&this.previous.error(a),this.cleanUp());return!0},on:function(a,b){this._listeners[a].push(b);return this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null;this._listeners=[]},emit:function(a,b){if(this._listeners[a])for(var c=0;c<this._listeners[a].length;c++)this._listeners[a][c].call(this,b)},pipe:function(a){return a.registerPrevious(this)},registerPrevious:function(a){if(this.isLocked)throw Error("The stream '"+
this+"' has already been used.");this.streamInfo=a.streamInfo;this.mergeStreamInfo();this.previous=a;var b=this;a.on("data",function(a){b.processChunk(a)});a.on("end",function(){b.end()});a.on("error",function(a){b.error(a)});return this},pause:function(){if(this.isPaused||this.isFinished)return!1;this.isPaused=!0;this.previous&&this.previous.pause();return!0},resume:function(){if(!this.isPaused||this.isFinished)return!1;var a=this.isPaused=!1;this.generatedError&&(this.error(this.generatedError),
a=!0);this.previous&&this.previous.resume();return!a},flush:function(){},processChunk:function(a){this.push(a)},withStreamInfo:function(a,b){this.extraStreamInfo[a]=b;this.mergeStreamInfo();return this},mergeStreamInfo:function(){for(var a in this.extraStreamInfo)this.extraStreamInfo.hasOwnProperty(a)&&(this.streamInfo[a]=this.extraStreamInfo[a])},lock:function(){if(this.isLocked)throw Error("The stream '"+this+"' has already been used.");this.isLocked=!0;this.previous&&this.previous.lock()},toString:function(){var a=
"Worker "+this.name;return this.previous?this.previous+" -> "+a:a}};p.exports=c},{}],29:[function(a,p,f){function c(a,b){var c,k=0,h=0;for(c=0;c<b.length;c++)h+=b[c].length;switch(a){case "string":return b.join("");case "array":return Array.prototype.concat.apply([],b);case "uint8array":a=new Uint8Array(h);for(c=0;c<b.length;c++)a.set(b[c],k),k+=b[c].length;return a;case "nodebuffer":return Buffer.concat(b);default:throw Error("concat : unsupported type '"+a+"'");}}function d(a,b){return new q.Promise(function(k,
d){var x=[],q=a._internalType,e=a._outputType,f=a._mimeType;a.on("data",function(a,c){x.push(a);b&&b(c)}).on("error",function(a){x=[];d(a)}).on("end",function(){try{a:{var a=c(q,x);switch(e){case "blob":var b=l.newBlob(l.transformTo("arraybuffer",a),f);break a;case "base64":b=h.encode(a);break a;default:b=l.transformTo(e,a)}}k(b)}catch(P){d(P)}x=[]}).resume()})}function b(a,b,c){var k=b;switch(b){case "blob":case "arraybuffer":k="uint8array";break;case "base64":k="string"}try{this._internalType=k,
this._outputType=b,this._mimeType=c,l.checkSupport(k),this._worker=a.pipe(new n(k)),a.lock()}catch(y){this._worker=new m("error"),this._worker.error(y)}}var l=a("../utils"),n=a("./ConvertWorker"),m=a("./GenericWorker"),h=a("../base64");f=a("../support");var q=a("../external"),k=null;if(f.nodestream)try{k=a("../nodejs/NodejsStreamOutputAdapter")}catch(x){}b.prototype={accumulate:function(a){return d(this,a)},on:function(a,b){var c=this;if("data"===a)this._worker.on(a,function(a){b.call(c,a.data,a.meta)});
else this._worker.on(a,function(){l.delay(b,arguments,c)});return this},resume:function(){l.delay(this._worker.resume,[],this._worker);return this},pause:function(){this._worker.pause();return this},toNodejsStream:function(a){l.checkSupport("nodestream");if("nodebuffer"!==this._outputType)throw Error(this._outputType+" is not supported by this method");return new k(this,{objectMode:"nodebuffer"!==this._outputType},a)}};p.exports=b},{"../base64":1,"../external":6,"../nodejs/NodejsStreamOutputAdapter":13,
"../support":30,"../utils":32,"./ConvertWorker":24,"./GenericWorker":28}],30:[function(a,p,f){f.base64=!0;f.array=!0;f.string=!0;f.arraybuffer="undefined"!==typeof ArrayBuffer&&"undefined"!==typeof Uint8Array;f.nodebuffer="undefined"!==typeof Buffer;f.uint8array="undefined"!==typeof Uint8Array;if("undefined"===typeof ArrayBuffer)f.blob=!1;else{p=new ArrayBuffer(0);try{f.blob=0===(new Blob([p],{type:"application/zip"})).size}catch(d){try{var c=new (self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||
self.MSBlobBuilder);c.append(p);f.blob=0===c.getBlob("application/zip").size}catch(b){f.blob=!1}}}try{f.nodestream=!!a("readable-stream").Readable}catch(d){f.nodestream=!1}},{"readable-stream":16}],31:[function(a,p,f){function c(){m.call(this,"utf-8 decode");this.leftOver=null}function d(){m.call(this,"utf-8 encode")}var b=a("./utils"),l=a("./support"),n=a("./nodejsUtils"),m=a("./stream/GenericWorker"),h=Array(256);for(a=0;256>a;a++)h[a]=252<=a?6:248<=a?5:240<=a?4:224<=a?3:192<=a?2:1;h[254]=h[254]=
1;f.utf8encode=function(a){if(l.nodebuffer)return n.newBufferFrom(a,"utf-8");var b,c,h=a.length,d=0;for(b=0;b<h;b++){var q=a.charCodeAt(b);if(55296===(q&64512)&&b+1<h){var y=a.charCodeAt(b+1);56320===(y&64512)&&(q=65536+(q-55296<<10)+(y-56320),b++)}d+=128>q?1:2048>q?2:65536>q?3:4}var f=l.uint8array?new Uint8Array(d):Array(d);for(b=c=0;c<d;b++)q=a.charCodeAt(b),55296===(q&64512)&&b+1<h&&(y=a.charCodeAt(b+1),56320===(y&64512)&&(q=65536+(q-55296<<10)+(y-56320),b++)),128>q?f[c++]=q:(2048>q?f[c++]=192|
q>>>6:(65536>q?f[c++]=224|q>>>12:(f[c++]=240|q>>>18,f[c++]=128|q>>>12&63),f[c++]=128|q>>>6&63),f[c++]=128|q&63);return f};f.utf8decode=function(a){if(l.nodebuffer)return b.transformTo("nodebuffer",a).toString("utf-8");a=b.transformTo(l.uint8array?"uint8array":"array",a);var c,d,q=a.length,f=Array(2*q);for(c=d=0;c<q;){var n=a[c++];if(128>n)f[d++]=n;else{var y=h[n];if(4<y)f[d++]=65533,c+=y-1;else{for(n&=2===y?31:3===y?15:7;1<y&&c<q;)n=n<<6|a[c++]&63,y--;1<y?f[d++]=65533:65536>n?f[d++]=n:(n-=65536,f[d++]=
55296|n>>10&1023,f[d++]=56320|n&1023)}}}f.length!==d&&(f.subarray?f=f.subarray(0,d):f.length=d);return b.applyFromCharCode(f)};b.inherits(c,m);c.prototype.processChunk=function(a){var c=b.transformTo(l.uint8array?"uint8array":"array",a.data);if(this.leftOver&&this.leftOver.length){if(l.uint8array){var d=c;c=new Uint8Array(d.length+this.leftOver.length);c.set(this.leftOver,0);c.set(d,this.leftOver.length)}else c=this.leftOver.concat(c);this.leftOver=null}var q;d=c.length;d>c.length&&(d=c.length);for(q=
d-1;0<=q&&128===(c[q]&192);)q--;d=0>q?d:0===q?d:q+h[c[q]]>d?q:d;q=c;d!==c.length&&(l.uint8array?(q=c.subarray(0,d),this.leftOver=c.subarray(d,c.length)):(q=c.slice(0,d),this.leftOver=c.slice(d,c.length)));this.push({data:f.utf8decode(q),meta:a.meta})};c.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:f.utf8decode(this.leftOver),meta:{}}),this.leftOver=null)};f.Utf8DecodeWorker=c;b.inherits(d,m);d.prototype.processChunk=function(a){this.push({data:f.utf8encode(a.data),
meta:a.meta})};f.Utf8EncodeWorker=d},{"./nodejsUtils":14,"./stream/GenericWorker":28,"./support":30,"./utils":32}],32:[function(a,p,f){function c(a){return a}function d(a,b){for(var c=0;c<a.length;++c)b[c]=a.charCodeAt(c)&255;return b}function b(a){var b=65536,c=f.getTypeOf(a),k=!0;"uint8array"===c?k=G.applyCanBeUsed.uint8array:"nodebuffer"===c&&(k=G.applyCanBeUsed.nodebuffer);if(k)for(;1<b;)try{return G.stringifyByChunk(a,c,b)}catch(E){b=Math.floor(b/2)}return G.stringifyByChar(a)}function l(a,b){for(var c=
0;c<a.length;c++)b[c]=a[c];return b}var n=a("./support"),m=a("./base64"),h=a("./nodejsUtils"),q=a("core-js/library/fn/set-immediate"),k=a("./external");f.newBlob=function(a,b){f.checkSupport("blob");try{return new Blob([a],{type:b})}catch(K){try{var c=new (self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);c.append(a);return c.getBlob(b)}catch(E){throw Error("Bug : can't construct the Blob.");}}};try{var x=n.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(y){x=
!1}a=x;try{var H=n.nodebuffer&&1===String.fromCharCode.apply(null,h.allocBuffer(1)).length}catch(y){H=!1}var G={stringifyByChunk:function(a,b,c){var k=[],d=0,h=a.length;if(h<=c)return String.fromCharCode.apply(null,a);for(;d<h;)"array"===b||"nodebuffer"===b?k.push(String.fromCharCode.apply(null,a.slice(d,Math.min(d+c,h)))):k.push(String.fromCharCode.apply(null,a.subarray(d,Math.min(d+c,h)))),d+=c;return k.join("")},stringifyByChar:function(a){for(var b="",c=0;c<a.length;c++)b+=String.fromCharCode(a[c]);
return b},applyCanBeUsed:{uint8array:a,nodebuffer:H}};f.applyFromCharCode=b;var C={};C.string={string:c,array:function(a){return d(a,Array(a.length))},arraybuffer:function(a){return C.string.uint8array(a).buffer},uint8array:function(a){return d(a,new Uint8Array(a.length))},nodebuffer:function(a){return d(a,h.allocBuffer(a.length))}};C.array={string:b,array:c,arraybuffer:function(a){return(new Uint8Array(a)).buffer},uint8array:function(a){return new Uint8Array(a)},nodebuffer:function(a){return h.newBufferFrom(a)}};
C.arraybuffer={string:function(a){return b(new Uint8Array(a))},array:function(a){return l(new Uint8Array(a),Array(a.byteLength))},arraybuffer:c,uint8array:function(a){return new Uint8Array(a)},nodebuffer:function(a){return h.newBufferFrom(new Uint8Array(a))}};C.uint8array={string:b,array:function(a){return l(a,Array(a.length))},arraybuffer:function(a){return a.buffer},uint8array:c,nodebuffer:function(a){return h.newBufferFrom(a)}};C.nodebuffer={string:b,array:function(a){return l(a,Array(a.length))},
arraybuffer:function(a){return C.nodebuffer.uint8array(a).buffer},uint8array:function(a){return l(a,new Uint8Array(a.length))},nodebuffer:c};f.transformTo=function(a,b){b||(b="");if(!a)return b;f.checkSupport(a);var c=f.getTypeOf(b);return C[c][a](b)};f.getTypeOf=function(a){if("string"===typeof a)return"string";if("[object Array]"===Object.prototype.toString.call(a))return"array";if(n.nodebuffer&&h.isBuffer(a))return"nodebuffer";if(n.uint8array&&a instanceof Uint8Array)return"uint8array";if(n.arraybuffer&&
a instanceof ArrayBuffer)return"arraybuffer"};f.checkSupport=function(a){if(!n[a.toLowerCase()])throw Error(a+" is not supported by this platform");};f.MAX_VALUE_16BITS=65535;f.MAX_VALUE_32BITS=-1;f.pretty=function(a){var b="",c;for(c=0;c<(a||"").length;c++){var k=a.charCodeAt(c);b+="\\x"+(16>k?"0":"")+k.toString(16).toUpperCase()}return b};f.delay=function(a,b,c){q(function(){a.apply(c||null,b||[])})};f.inherits=function(a,b){var c=function(){};c.prototype=b.prototype;a.prototype=new c};f.extend=
function(){var a={},b,c;for(b=0;b<arguments.length;b++)for(c in arguments[b])arguments[b].hasOwnProperty(c)&&"undefined"===typeof a[c]&&(a[c]=arguments[b][c]);return a};f.prepareContent=function(a,b,c,h,q){return k.Promise.resolve(b).then(function(a){return n.blob&&(a instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(a)))&&"undefined"!==typeof FileReader?new k.Promise(function(b,c){var g=new FileReader;g.onload=function(a){b(a.target.result)};g.onerror=
function(a){c(a.target.error)};g.readAsArrayBuffer(a)}):a}).then(function(b){var e=f.getTypeOf(b);if(!e)return k.Promise.reject(Error("Can't read the data of '"+a+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"));"arraybuffer"===e?b=f.transformTo("uint8array",b):"string"===e&&(q?b=m.decode(b):c&&!0!==h&&(e=n.uint8array?new Uint8Array(b.length):Array(b.length),b=d(b,e)));return b})}},{"./base64":1,"./external":6,"./nodejsUtils":14,"./support":30,"core-js/library/fn/set-immediate":36}],
33:[function(a,p,f){function c(a){this.files=[];this.loadOptions=a}var d=a("./reader/readerFor"),b=a("./utils"),l=a("./signature"),n=a("./zipEntry");a("./utf8");var m=a("./support");c.prototype={checkSignature:function(a){if(!this.reader.readAndCheckSignature(a)){this.reader.index-=4;var c=this.reader.readString(4);throw Error("Corrupted zip or bug: unexpected signature ("+b.pretty(c)+", expected "+b.pretty(a)+")");}},isSignature:function(a,b){var c=this.reader.index;this.reader.setIndex(a);a=this.reader.readString(4)===
b;this.reader.setIndex(c);return a},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2);this.diskWithCentralDirStart=this.reader.readInt(2);this.centralDirRecordsOnThisDisk=this.reader.readInt(2);this.centralDirRecords=this.reader.readInt(2);this.centralDirSize=this.reader.readInt(4);this.centralDirOffset=this.reader.readInt(4);this.zipCommentLength=this.reader.readInt(2);var a=this.reader.readData(this.zipCommentLength);a=b.transformTo(m.uint8array?"uint8array":"array",a);this.zipComment=
this.loadOptions.decodeFileName(a)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8);this.reader.skip(4);this.diskNumber=this.reader.readInt(4);this.diskWithCentralDirStart=this.reader.readInt(4);this.centralDirRecordsOnThisDisk=this.reader.readInt(8);this.centralDirRecords=this.reader.readInt(8);this.centralDirSize=this.reader.readInt(8);this.centralDirOffset=this.reader.readInt(8);this.zip64ExtensibleData={};for(var a=this.zip64EndOfCentralSize-44,b,c,d;0<
a;)b=this.reader.readInt(2),c=this.reader.readInt(4),d=this.reader.readData(c),this.zip64ExtensibleData[b]={id:b,length:c,value:d}},readBlockZip64EndOfCentralLocator:function(){this.diskWithZip64CentralDirStart=this.reader.readInt(4);this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8);this.disksCount=this.reader.readInt(4);if(1<this.disksCount)throw Error("Multi-volumes zip are not supported");},readLocalFiles:function(){var a;for(a=0;a<this.files.length;a++){var b=this.files[a];this.reader.setIndex(b.localHeaderOffset);
this.checkSignature(l.LOCAL_FILE_HEADER);b.readLocalPart(this.reader);b.handleUTF8();b.processAttributes()}},readCentralDir:function(){for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(l.CENTRAL_FILE_HEADER);){var a=new n({zip64:this.zip64},this.loadOptions);a.readCentralPart(this.reader);this.files.push(a)}if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw Error("Corrupted zip or bug: expected "+this.centralDirRecords+
" records in central dir, got "+this.files.length);},readEndOfCentral:function(){var a=this.reader.lastIndexOfSignature(l.CENTRAL_DIRECTORY_END);if(0>a){if(this.isSignature(0,l.LOCAL_FILE_HEADER))throw Error("Corrupted zip: can't find end of central directory");throw Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");}this.reader.setIndex(a);var c=a;this.checkSignature(l.CENTRAL_DIRECTORY_END);this.readBlockEndOfCentral();
if(this.diskNumber===b.MAX_VALUE_16BITS||this.diskWithCentralDirStart===b.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===b.MAX_VALUE_16BITS||this.centralDirRecords===b.MAX_VALUE_16BITS||this.centralDirSize===b.MAX_VALUE_32BITS||this.centralDirOffset===b.MAX_VALUE_32BITS){this.zip64=!0;a=this.reader.lastIndexOfSignature(l.ZIP64_CENTRAL_DIRECTORY_LOCATOR);if(0>a)throw Error("Corrupted zip: can't find the ZIP64 end of central directory locator");this.reader.setIndex(a);this.checkSignature(l.ZIP64_CENTRAL_DIRECTORY_LOCATOR);
this.readBlockZip64EndOfCentralLocator();if(!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,l.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(l.ZIP64_CENTRAL_DIRECTORY_END),0>this.relativeOffsetEndOfZip64CentralDir))throw Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir);this.checkSignature(l.ZIP64_CENTRAL_DIRECTORY_END);this.readBlockZip64EndOfCentral()}a=
this.centralDirOffset+this.centralDirSize;this.zip64&&(a=a+20+(12+this.zip64EndOfCentralSize));a=c-a;if(0<a)this.isSignature(c,l.CENTRAL_FILE_HEADER)||(this.reader.zero=a);else if(0>a)throw Error("Corrupted zip: missing "+Math.abs(a)+" bytes.");},prepareReader:function(a){this.reader=d(a)},load:function(a){this.prepareReader(a);this.readEndOfCentral();this.readCentralDir();this.readLocalFiles()}};p.exports=c},{"./reader/readerFor":22,"./signature":23,"./support":30,"./utf8":31,"./utils":32,"./zipEntry":34}],
34:[function(a,p,f){function c(a,b){this.options=a;this.loadOptions=b}var d=a("./reader/readerFor"),b=a("./utils"),l=a("./compressedObject"),n=a("./crc32"),m=a("./utf8"),h=a("./compressions"),q=a("./support");c.prototype={isEncrypted:function(){return 1===(this.bitFlag&1)},useUTF8:function(){return 2048===(this.bitFlag&2048)},readLocalPart:function(a){a.skip(22);this.fileNameLength=a.readInt(2);var c=a.readInt(2);this.fileName=a.readData(this.fileNameLength);a.skip(c);if(-1===this.compressedSize||
-1===this.uncompressedSize)throw Error("Bug or corrupted zip : didn't get enough informations from the central directory (compressedSize === -1 || uncompressedSize === -1)");a:{c=this.compressionMethod;for(k in h)if(h.hasOwnProperty(k)&&h[k].magic===c){var k=h[k];break a}k=null}if(null===k)throw Error("Corrupted zip : compression "+b.pretty(this.compressionMethod)+" unknown (inner file : "+b.transformTo("string",this.fileName)+")");this.decompressed=new l(this.compressedSize,this.uncompressedSize,
this.crc32,k,a.readData(this.compressedSize))},readCentralPart:function(a){this.versionMadeBy=a.readInt(2);a.skip(2);this.bitFlag=a.readInt(2);this.compressionMethod=a.readString(2);this.date=a.readDate();this.crc32=a.readInt(4);this.compressedSize=a.readInt(4);this.uncompressedSize=a.readInt(4);var b=a.readInt(2);this.extraFieldsLength=a.readInt(2);this.fileCommentLength=a.readInt(2);this.diskNumberStart=a.readInt(2);this.internalFileAttributes=a.readInt(2);this.externalFileAttributes=a.readInt(4);
this.localHeaderOffset=a.readInt(4);if(this.isEncrypted())throw Error("Encrypted zip are not supported");a.skip(b);this.readExtraFields(a);this.parseZIP64ExtraField(a);this.fileComment=a.readData(this.fileCommentLength)},processAttributes:function(){this.dosPermissions=this.unixPermissions=null;var a=this.versionMadeBy>>8;this.dir=this.externalFileAttributes&16?!0:!1;0===a&&(this.dosPermissions=this.externalFileAttributes&63);3===a&&(this.unixPermissions=this.externalFileAttributes>>16&65535);this.dir||
"/"!==this.fileNameStr.slice(-1)||(this.dir=!0)},parseZIP64ExtraField:function(a){this.extraFields[1]&&(a=d(this.extraFields[1].value),this.uncompressedSize===b.MAX_VALUE_32BITS&&(this.uncompressedSize=a.readInt(8)),this.compressedSize===b.MAX_VALUE_32BITS&&(this.compressedSize=a.readInt(8)),this.localHeaderOffset===b.MAX_VALUE_32BITS&&(this.localHeaderOffset=a.readInt(8)),this.diskNumberStart===b.MAX_VALUE_32BITS&&(this.diskNumberStart=a.readInt(4)))},readExtraFields:function(a){var b=a.index+this.extraFieldsLength;
this.extraFields||(this.extraFields={});for(;a.index<b;){var c=a.readInt(2);var d=a.readInt(2);var k=a.readData(d);this.extraFields[c]={id:c,length:d,value:k}}},handleUTF8:function(){var a=q.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=m.utf8decode(this.fileName),this.fileCommentStr=m.utf8decode(this.fileComment);else{var c=this.findExtraFieldUnicodePath();null!==c?this.fileNameStr=c:(c=b.transformTo(a,this.fileName),this.fileNameStr=this.loadOptions.decodeFileName(c));c=this.findExtraFieldUnicodeComment();
null!==c?this.fileCommentStr=c:(a=b.transformTo(a,this.fileComment),this.fileCommentStr=this.loadOptions.decodeFileName(a))}},findExtraFieldUnicodePath:function(){var a=this.extraFields[28789];if(a){var b=d(a.value);return 1!==b.readInt(1)||n(this.fileName)!==b.readInt(4)?null:m.utf8decode(b.readData(a.length-5))}return null},findExtraFieldUnicodeComment:function(){var a=this.extraFields[25461];if(a){var b=d(a.value);return 1!==b.readInt(1)||n(this.fileComment)!==b.readInt(4)?null:m.utf8decode(b.readData(a.length-
5))}return null}};p.exports=c},{"./compressedObject":2,"./compressions":3,"./crc32":4,"./reader/readerFor":22,"./support":30,"./utf8":31,"./utils":32}],35:[function(a,p,f){var c=a("./stream/StreamHelper"),d=a("./stream/DataWorker"),b=a("./utf8"),l=a("./compressedObject"),n=a("./stream/GenericWorker");a=function(a,b,c){this.name=a;this.dir=c.dir;this.date=c.date;this.comment=c.comment;this.unixPermissions=c.unixPermissions;this.dosPermissions=c.dosPermissions;this._data=b;this._dataBinary=c.binary;
this.options={compression:c.compression,compressionOptions:c.compressionOptions}};a.prototype={internalStream:function(a){var d=null,f="string";try{if(!a)throw Error("No output type specified.");f=a.toLowerCase();a="string"===f||"text"===f;if("binarystring"===f||"text"===f)f="string";d=this._decompressWorker();var h=!this._dataBinary;h&&!a&&(d=d.pipe(new b.Utf8EncodeWorker));!h&&a&&(d=d.pipe(new b.Utf8DecodeWorker))}catch(G){d=new n("error"),d.error(G)}return new c(d,f,"")},async:function(a,b){return this.internalStream(a).accumulate(b)},
nodeStream:function(a,b){return this.internalStream(a||"nodebuffer").toNodejsStream(b)},_compressWorker:function(a,c){if(this._data instanceof l&&this._data.compression.magic===a.magic)return this._data.getCompressedWorker();var d=this._decompressWorker();this._dataBinary||(d=d.pipe(new b.Utf8EncodeWorker));return l.createWorkerFrom(d,a,c)},_decompressWorker:function(){return this._data instanceof l?this._data.getContentWorker():this._data instanceof n?this._data:new d(this._data)}};f=["asText","asBinary",
"asNodeBuffer","asUint8Array","asArrayBuffer"];for(var m=function(){throw Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");},h=0;h<f.length;h++)a.prototype[f[h]]=m;p.exports=a},{"./compressedObject":2,"./stream/DataWorker":27,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31}],36:[function(a,p,f){a("../modules/web.immediate");p.exports=a("../modules/_core").setImmediate},{"../modules/_core":40,"../modules/web.immediate":56}],37:[function(a,p,f){p.exports=
function(a){if("function"!=typeof a)throw TypeError(a+" is not a function!");return a}},{}],38:[function(a,p,f){var c=a("./_is-object");p.exports=function(a){if(!c(a))throw TypeError(a+" is not an object!");return a}},{"./_is-object":51}],39:[function(a,p,f){var c={}.toString;p.exports=function(a){return c.call(a).slice(8,-1)}},{}],40:[function(a,p,f){a=p.exports={version:"2.3.0"};"number"==typeof __e&&(__e=a)},{}],41:[function(a,p,f){var c=a("./_a-function");p.exports=function(a,b,f){c(a);if(void 0===
b)return a;switch(f){case 1:return function(c){return a.call(b,c)};case 2:return function(c,d){return a.call(b,c,d)};case 3:return function(c,d,f){return a.call(b,c,d,f)}}return function(){return a.apply(b,arguments)}}},{"./_a-function":37}],42:[function(a,p,f){p.exports=!a("./_fails")(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a})},{"./_fails":45}],43:[function(a,p,f){f=a("./_is-object");var c=a("./_global").document,d=f(c)&&f(c.createElement);p.exports=function(a){return d?
c.createElement(a):{}}},{"./_global":46,"./_is-object":51}],44:[function(a,p,f){var c=a("./_global"),d=a("./_core"),b=a("./_ctx"),l=a("./_hide"),n=function(a,f,q){var k=a&n.F,h=a&n.G,m=a&n.S,p=a&n.P,C=a&n.B,y=a&n.W,D=h?d:d[f]||(d[f]={}),e=D.prototype;m=h?c:m?c[f]:(c[f]||{}).prototype;var K;h&&(q=f);for(K in q)if(f=!k&&m&&void 0!==m[K],!(f&&K in D)){var E=f?m[K]:q[K];D[K]=h&&"function"!=typeof m[K]?q[K]:C&&f?b(E,c):y&&m[K]==E?function(a){var b=function(b,c,d){if(this instanceof a){switch(arguments.length){case 0:return new a;
case 1:return new a(b);case 2:return new a(b,c)}return new a(b,c,d)}return a.apply(this,arguments)};b.prototype=a.prototype;return b}(E):p&&"function"==typeof E?b(Function.call,E):E;p&&((D.virtual||(D.virtual={}))[K]=E,a&n.R&&e&&!e[K]&&l(e,K,E))}};n.F=1;n.G=2;n.S=4;n.P=8;n.B=16;n.W=32;n.U=64;n.R=128;p.exports=n},{"./_core":40,"./_ctx":41,"./_global":46,"./_hide":47}],45:[function(a,p,f){p.exports=function(a){try{return!!a()}catch(d){return!0}}},{}],46:[function(a,p,f){a=p.exports="undefined"!=typeof window&&
Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=a)},{}],47:[function(a,p,f){var c=a("./_object-dp"),d=a("./_property-desc");p.exports=a("./_descriptors")?function(a,f,n){return c.f(a,f,d(1,n))}:function(a,c,d){a[c]=d;return a}},{"./_descriptors":42,"./_object-dp":52,"./_property-desc":53}],48:[function(a,p,f){p.exports=a("./_global").document&&document.documentElement},{"./_global":46}],49:[function(a,p,f){p.exports=!a("./_descriptors")&&
!a("./_fails")(function(){return 7!=Object.defineProperty(a("./_dom-create")("div"),"a",{get:function(){return 7}}).a})},{"./_descriptors":42,"./_dom-create":43,"./_fails":45}],50:[function(a,p,f){p.exports=function(a,d,b){var c=void 0===b;switch(d.length){case 0:return c?a():a.call(b);case 1:return c?a(d[0]):a.call(b,d[0]);case 2:return c?a(d[0],d[1]):a.call(b,d[0],d[1]);case 3:return c?a(d[0],d[1],d[2]):a.call(b,d[0],d[1],d[2]);case 4:return c?a(d[0],d[1],d[2],d[3]):a.call(b,d[0],d[1],d[2],d[3])}return a.apply(b,
d)}},{}],51:[function(a,p,f){p.exports=function(a){return"object"===typeof a?null!==a:"function"===typeof a}},{}],52:[function(a,p,f){var c=a("./_an-object"),d=a("./_ie8-dom-define"),b=a("./_to-primitive"),l=Object.defineProperty;f.f=a("./_descriptors")?Object.defineProperty:function(a,f,h){c(a);f=b(f,!0);c(h);if(d)try{return l(a,f,h)}catch(q){}if("get"in h||"set"in h)throw TypeError("Accessors not supported!");"value"in h&&(a[f]=h.value);return a}},{"./_an-object":38,"./_descriptors":42,"./_ie8-dom-define":49,
"./_to-primitive":55}],53:[function(a,p,f){p.exports=function(a,d){return{enumerable:!(a&1),configurable:!(a&2),writable:!(a&4),value:d}}},{}],54:[function(a,p,f){var c=a("./_ctx"),d=a("./_invoke"),b=a("./_html"),l=a("./_dom-create"),n=a("./_global"),m=n.process;f=n.setImmediate;var h=n.clearImmediate,q=n.MessageChannel,k=0,x={},H=function(){var a=+this;if(x.hasOwnProperty(a)){var b=x[a];delete x[a];b()}},G=function(a){H.call(a.data)};if(!f||!h)if(f=function(a){for(var b=[],c=1;arguments.length>c;)b.push(arguments[c++]);
x[++k]=function(){d("function"==typeof a?a:Function(a),b)};C(k);return k},h=function(a){delete x[a]},"process"==a("./_cof")(m))var C=function(a){m.nextTick(c(H,a,1))};else q?(a=new q,q=a.port2,a.port1.onmessage=G,C=c(q.postMessage,q,1)):n.addEventListener&&"function"==typeof postMessage&&!n.importScripts?(C=function(a){n.postMessage(a+"","*")},n.addEventListener("message",G,!1)):C="onreadystatechange"in l("script")?function(a){b.appendChild(l("script")).onreadystatechange=function(){b.removeChild(this);
H.call(a)}}:function(a){setTimeout(c(H,a,1),0)};p.exports={set:f,clear:h}},{"./_cof":39,"./_ctx":41,"./_dom-create":43,"./_global":46,"./_html":48,"./_invoke":50}],55:[function(a,p,f){var c=a("./_is-object");p.exports=function(a,b){if(!c(a))return a;var d,f;if(b&&"function"==typeof(d=a.toString)&&!c(f=d.call(a))||"function"==typeof(d=a.valueOf)&&!c(f=d.call(a))||!b&&"function"==typeof(d=a.toString)&&!c(f=d.call(a)))return f;throw TypeError("Can't convert object to primitive value");}},{"./_is-object":51}],
56:[function(a,p,f){p=a("./_export");a=a("./_task");p(p.G+p.B,{setImmediate:a.set,clearImmediate:a.clear})},{"./_export":44,"./_task":54}],57:[function(a,p,f){(function(a){function c(){q=!0;for(var a,b,c=k.length;c;){b=k;k=[];for(a=-1;++a<c;)b[a]();c=k.length}q=!1}var b=a.MutationObserver||a.WebKitMutationObserver;if(b){var f=0;b=new b(c);var n=a.document.createTextNode("");b.observe(n,{characterData:!0});var m=function(){n.data=f=++f%2}}else if(a.setImmediate||"undefined"===typeof a.MessageChannel)m=
"document"in a&&"onreadystatechange"in a.document.createElement("script")?function(){var b=a.document.createElement("script");b.onreadystatechange=function(){c();b.onreadystatechange=null;b.parentNode.removeChild(b);b=null};a.document.documentElement.appendChild(b)}:function(){setTimeout(c,0)};else{var h=new a.MessageChannel;h.port1.onmessage=c;m=function(){h.port2.postMessage(0)}}var q,k=[];p.exports=function(a){1!==k.push(a)||q||m()}}).call(this,"undefined"!==typeof global?global:"undefined"!==
typeof self?self:"undefined"!==typeof window?window:{})},{}],58:[function(a,p,f){function c(){}function d(a){if("function"!==typeof a)throw new TypeError("resolver must be a function");this.state=G;this.queue=[];this.outcome=void 0;a!==c&&m(this,a)}function b(a,b,c){this.promise=a;"function"===typeof b&&(this.onFulfilled=b,this.callFulfilled=this.otherCallFulfilled);"function"===typeof c&&(this.onRejected=c,this.callRejected=this.otherCallRejected)}function l(a,b,c){q(function(){try{var d=b(c)}catch(K){return k.reject(a,
K)}d===a?k.reject(a,new TypeError("Cannot resolve promise with itself")):k.resolve(a,d)})}function n(a){var b=a&&a.then;if(a&&("object"===typeof a||"function"===typeof a)&&"function"===typeof b)return function(){b.apply(a,arguments)}}function m(a,b){function c(b){f||(f=!0,k.reject(a,b))}function d(b){f||(f=!0,k.resolve(a,b))}var f=!1,q=h(function(){b(d,c)});"error"===q.status&&c(q.value)}function h(a,b){var c={};try{c.value=a(b),c.status="success"}catch(e){c.status="error",c.value=e}return c}var q=
a("immediate"),k={},x=["REJECTED"],H=["FULFILLED"],G=["PENDING"];p.exports=d;d.prototype["catch"]=function(a){return this.then(null,a)};d.prototype.then=function(a,d){if("function"!==typeof a&&this.state===H||"function"!==typeof d&&this.state===x)return this;var f=new this.constructor(c);this.state!==G?l(f,this.state===H?a:d,this.outcome):this.queue.push(new b(f,a,d));return f};b.prototype.callFulfilled=function(a){k.resolve(this.promise,a)};b.prototype.otherCallFulfilled=function(a){l(this.promise,
this.onFulfilled,a)};b.prototype.callRejected=function(a){k.reject(this.promise,a)};b.prototype.otherCallRejected=function(a){l(this.promise,this.onRejected,a)};k.resolve=function(a,b){var c=h(n,b);if("error"===c.status)return k.reject(a,c.value);if(c=c.value)m(a,c);else{a.state=H;a.outcome=b;c=-1;for(var d=a.queue.length;++c<d;)a.queue[c].callFulfilled(b)}return a};k.reject=function(a,b){a.state=x;a.outcome=b;for(var c=-1,d=a.queue.length;++c<d;)a.queue[c].callRejected(b);return a};d.resolve=function(a){return a instanceof
this?a:k.resolve(new this(c),a)};d.reject=function(a){var b=new this(c);return k.reject(b,a)};d.all=function(a){function b(a,b){d.resolve(a).then(function(a){q[b]=a;++n!==f||h||(h=!0,k.resolve(g,q))},function(a){h||(h=!0,k.reject(g,a))})}var d=this;if("[object Array]"!==Object.prototype.toString.call(a))return this.reject(new TypeError("must be an array"));var f=a.length,h=!1;if(!f)return this.resolve([]);for(var q=Array(f),n=0,m=-1,g=new this(c);++m<f;)b(a[m],m);return g};d.race=function(a){function b(a){d.resolve(a).then(function(a){h||
(h=!0,k.resolve(n,a))},function(a){h||(h=!0,k.reject(n,a))})}var d=this;if("[object Array]"!==Object.prototype.toString.call(a))return this.reject(new TypeError("must be an array"));var f=a.length,h=!1;if(!f)return this.resolve([]);for(var q=-1,n=new this(c);++q<f;)b(a[q]);return n}},{immediate:57}],59:[function(a,p,f){f=a("./lib/utils/common").assign;var c=a("./lib/deflate"),d=a("./lib/inflate");a=a("./lib/zlib/constants");var b={};f(b,c,d,a);p.exports=b},{"./lib/deflate":60,"./lib/inflate":61,"./lib/utils/common":62,
"./lib/zlib/constants":65}],60:[function(a,p,f){function c(a){if(!(this instanceof c))return new c(a);a=this.options=l.assign({level:-1,method:8,chunkSize:16384,windowBits:15,memLevel:8,strategy:0,to:""},a||{});a.raw&&0<a.windowBits?a.windowBits=-a.windowBits:a.gzip&&0<a.windowBits&&16>a.windowBits&&(a.windowBits+=16);this.err=0;this.msg="";this.ended=!1;this.chunks=[];this.strm=new h;this.strm.avail_out=0;var d=b.deflateInit2(this.strm,a.level,a.method,a.windowBits,a.memLevel,a.strategy);if(0!==
d)throw Error(m[d]);a.header&&b.deflateSetHeader(this.strm,a.header);if(a.dictionary){a="string"===typeof a.dictionary?n.string2buf(a.dictionary):"[object ArrayBuffer]"===q.call(a.dictionary)?new Uint8Array(a.dictionary):a.dictionary;d=b.deflateSetDictionary(this.strm,a);if(0!==d)throw Error(m[d]);this._dict_set=!0}}function d(a,b){b=new c(b);b.push(a,!0);if(b.err)throw b.msg||m[b.err];return b.result}var b=a("./zlib/deflate"),l=a("./utils/common"),n=a("./utils/strings"),m=a("./zlib/messages"),h=
a("./zlib/zstream"),q=Object.prototype.toString;c.prototype.push=function(a,c){var d=this.strm,f=this.options.chunkSize;if(this.ended)return!1;c=c===~~c?c:!0===c?4:0;"string"===typeof a?d.input=n.string2buf(a):"[object ArrayBuffer]"===q.call(a)?d.input=new Uint8Array(a):d.input=a;d.next_in=0;d.avail_in=d.input.length;do{0===d.avail_out&&(d.output=new l.Buf8(f),d.next_out=0,d.avail_out=f);a=b.deflate(d,c);if(1!==a&&0!==a)return this.onEnd(a),this.ended=!0,!1;if(0===d.avail_out||0===d.avail_in&&(4===
c||2===c))if("string"===this.options.to)this.onData(n.buf2binstring(l.shrinkBuf(d.output,d.next_out)));else this.onData(l.shrinkBuf(d.output,d.next_out))}while((0<d.avail_in||0===d.avail_out)&&1!==a);if(4===c)return a=b.deflateEnd(this.strm),this.onEnd(a),this.ended=!0,0===a;2===c&&(this.onEnd(0),d.avail_out=0);return!0};c.prototype.onData=function(a){this.chunks.push(a)};c.prototype.onEnd=function(a){0===a&&(this.result="string"===this.options.to?this.chunks.join(""):l.flattenChunks(this.chunks));
this.chunks=[];this.err=a;this.msg=this.strm.msg};f.Deflate=c;f.deflate=d;f.deflateRaw=function(a,b){b=b||{};b.raw=!0;return d(a,b)};f.gzip=function(a,b){b=b||{};b.gzip=!0;return d(a,b)}},{"./utils/common":62,"./utils/strings":63,"./zlib/deflate":67,"./zlib/messages":72,"./zlib/zstream":74}],61:[function(a,p,f){function c(a){if(!(this instanceof c))return new c(a);var d=this.options=l.assign({chunkSize:16384,windowBits:0,to:""},a||{});d.raw&&0<=d.windowBits&&16>d.windowBits&&(d.windowBits=-d.windowBits,
0===d.windowBits&&(d.windowBits=-15));!(0<=d.windowBits&&16>d.windowBits)||a&&a.windowBits||(d.windowBits+=32);15<d.windowBits&&48>d.windowBits&&0===(d.windowBits&15)&&(d.windowBits|=15);this.err=0;this.msg="";this.ended=!1;this.chunks=[];this.strm=new q;this.strm.avail_out=0;a=b.inflateInit2(this.strm,d.windowBits);if(a!==m.Z_OK)throw Error(h[a]);this.header=new k;b.inflateGetHeader(this.strm,this.header)}function d(a,b){b=new c(b);b.push(a,!0);if(b.err)throw b.msg||h[b.err];return b.result}var b=
a("./zlib/inflate"),l=a("./utils/common"),n=a("./utils/strings"),m=a("./zlib/constants"),h=a("./zlib/messages"),q=a("./zlib/zstream"),k=a("./zlib/gzheader"),x=Object.prototype.toString;c.prototype.push=function(a,c){var d=this.strm,f=this.options.chunkSize,h=this.options.dictionary,e=!1;if(this.ended)return!1;c=c===~~c?c:!0===c?m.Z_FINISH:m.Z_NO_FLUSH;"string"===typeof a?d.input=n.binstring2buf(a):"[object ArrayBuffer]"===x.call(a)?d.input=new Uint8Array(a):d.input=a;d.next_in=0;d.avail_in=d.input.length;
do{0===d.avail_out&&(d.output=new l.Buf8(f),d.next_out=0,d.avail_out=f);a=b.inflate(d,m.Z_NO_FLUSH);a===m.Z_NEED_DICT&&h&&(a="string"===typeof h?n.string2buf(h):"[object ArrayBuffer]"===x.call(h)?new Uint8Array(h):h,a=b.inflateSetDictionary(this.strm,a));a===m.Z_BUF_ERROR&&!0===e&&(a=m.Z_OK,e=!1);if(a!==m.Z_STREAM_END&&a!==m.Z_OK)return this.onEnd(a),this.ended=!0,!1;if(d.next_out&&(0===d.avail_out||a===m.Z_STREAM_END||0===d.avail_in&&(c===m.Z_FINISH||c===m.Z_SYNC_FLUSH)))if("string"===this.options.to){var q=
n.utf8border(d.output,d.next_out);var k=d.next_out-q;var p=n.buf2string(d.output,q);d.next_out=k;d.avail_out=f-k;k&&l.arraySet(d.output,d.output,q,k,0);this.onData(p)}else this.onData(l.shrinkBuf(d.output,d.next_out));0===d.avail_in&&0===d.avail_out&&(e=!0)}while((0<d.avail_in||0===d.avail_out)&&a!==m.Z_STREAM_END);a===m.Z_STREAM_END&&(c=m.Z_FINISH);if(c===m.Z_FINISH)return a=b.inflateEnd(this.strm),this.onEnd(a),this.ended=!0,a===m.Z_OK;c===m.Z_SYNC_FLUSH&&(this.onEnd(m.Z_OK),d.avail_out=0);return!0};
c.prototype.onData=function(a){this.chunks.push(a)};c.prototype.onEnd=function(a){a===m.Z_OK&&(this.result="string"===this.options.to?this.chunks.join(""):l.flattenChunks(this.chunks));this.chunks=[];this.err=a;this.msg=this.strm.msg};f.Inflate=c;f.inflate=d;f.inflateRaw=function(a,b){b=b||{};b.raw=!0;return d(a,b)};f.ungzip=d},{"./utils/common":62,"./utils/strings":63,"./zlib/constants":65,"./zlib/gzheader":68,"./zlib/inflate":70,"./zlib/messages":72,"./zlib/zstream":74}],62:[function(a,p,f){a="undefined"!==
typeof Uint8Array&&"undefined"!==typeof Uint16Array&&"undefined"!==typeof Int32Array;f.assign=function(a){for(var b=Array.prototype.slice.call(arguments,1);b.length;){var c=b.shift();if(c){if("object"!==typeof c)throw new TypeError(c+"must be non-object");for(var d in c)c.hasOwnProperty(d)&&(a[d]=c[d])}}return a};f.shrinkBuf=function(a,c){if(a.length===c)return a;if(a.subarray)return a.subarray(0,c);a.length=c;return a};var c={arraySet:function(a,c,d,f,h){if(c.subarray&&a.subarray)a.set(c.subarray(d,
d+f),h);else for(var b=0;b<f;b++)a[h+b]=c[d+b]},flattenChunks:function(a){var b,c;var d=c=0;for(b=a.length;d<b;d++)c+=a[d].length;var f=new Uint8Array(c);d=c=0;for(b=a.length;d<b;d++){var q=a[d];f.set(q,c);c+=q.length}return f}},d={arraySet:function(a,c,d,f,h){for(var b=0;b<f;b++)a[h+b]=c[d+b]},flattenChunks:function(a){return[].concat.apply([],a)}};f.setTyped=function(a){a?(f.Buf8=Uint8Array,f.Buf16=Uint16Array,f.Buf32=Int32Array,f.assign(f,c)):(f.Buf8=Array,f.Buf16=Array,f.Buf32=Array,f.assign(f,
d))};f.setTyped(a)},{}],63:[function(a,p,f){function c(a,c){if(65537>c&&(a.subarray&&l||!a.subarray&&b))return String.fromCharCode.apply(null,d.shrinkBuf(a,c));for(var f="",h=0;h<c;h++)f+=String.fromCharCode(a[h]);return f}var d=a("./common"),b=!0,l=!0;try{String.fromCharCode.apply(null,[0])}catch(m){b=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(m){l=!1}var n=new d.Buf8(256);for(a=0;256>a;a++)n[a]=252<=a?6:248<=a?5:240<=a?4:224<=a?3:192<=a?2:1;n[254]=n[254]=1;f.string2buf=function(a){var b,
c,f=a.length,n=0;for(b=0;b<f;b++){var l=a.charCodeAt(b);if(55296===(l&64512)&&b+1<f){var m=a.charCodeAt(b+1);56320===(m&64512)&&(l=65536+(l-55296<<10)+(m-56320),b++)}n+=128>l?1:2048>l?2:65536>l?3:4}var p=new d.Buf8(n);for(b=c=0;c<n;b++)l=a.charCodeAt(b),55296===(l&64512)&&b+1<f&&(m=a.charCodeAt(b+1),56320===(m&64512)&&(l=65536+(l-55296<<10)+(m-56320),b++)),128>l?p[c++]=l:(2048>l?p[c++]=192|l>>>6:(65536>l?p[c++]=224|l>>>12:(p[c++]=240|l>>>18,p[c++]=128|l>>>12&63),p[c++]=128|l>>>6&63),p[c++]=128|l&
63);return p};f.buf2binstring=function(a){return c(a,a.length)};f.binstring2buf=function(a){for(var b=new d.Buf8(a.length),c=0,f=b.length;c<f;c++)b[c]=a.charCodeAt(c);return b};f.buf2string=function(a,b){var d,f=b||a.length,h=Array(2*f);for(b=d=0;b<f;){var l=a[b++];if(128>l)h[d++]=l;else{var m=n[l];if(4<m)h[d++]=65533,b+=m-1;else{for(l&=2===m?31:3===m?15:7;1<m&&b<f;)l=l<<6|a[b++]&63,m--;1<m?h[d++]=65533:65536>l?h[d++]=l:(l-=65536,h[d++]=55296|l>>10&1023,h[d++]=56320|l&1023)}}}return c(h,d)};f.utf8border=
function(a,b){var c;b=b||a.length;b>a.length&&(b=a.length);for(c=b-1;0<=c&&128===(a[c]&192);)c--;return 0>c||0===c?b:c+n[a[c]]>b?c:b}},{"./common":62}],64:[function(a,p,f){p.exports=function(a,d,b,f){var c=a&65535|0;a=a>>>16&65535|0;for(var l;0!==b;){l=2E3<b?2E3:b;b-=l;do c=c+d[f++]|0,a=a+c|0;while(--l);c%=65521;a%=65521}return c|a<<16|0}},{}],65:[function(a,p,f){p.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,
Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],66:[function(a,p,f){var c=function(){for(var a,b=[],c=0;256>c;c++){a=c;for(var f=0;8>f;f++)a=a&1?3988292384^a>>>1:a>>>1;b[c]=a}return b}();p.exports=function(a,b,f,n){f=n+f;for(a^=-1;n<f;n++)a=a>>>8^c[(a^b[n])&255];return a^-1}},{}],67:[function(a,
p,f){function c(a,b){a.msg=A[b];return b}function d(a){for(var b=a.length;0<=--b;)a[b]=0}function b(a){var b=a.state,c=b.pending;c>a.avail_out&&(c=a.avail_out);0!==c&&(E.arraySet(a.output,b.pending_buf,b.pending_out,c,a.next_out),a.next_out+=c,b.pending_out+=c,a.total_out+=c,a.avail_out-=c,b.pending-=c,0===b.pending&&(b.pending_out=0))}function l(a,c){L._tr_flush_block(a,0<=a.block_start?a.block_start:-1,a.strstart-a.block_start,c);a.block_start=a.strstart;b(a.strm)}function n(a,b){a.pending_buf[a.pending++]=
b}function m(a,b){a.pending_buf[a.pending++]=b>>>8&255;a.pending_buf[a.pending++]=b&255}function h(a,b){var c=a.max_chain_length,v=a.strstart,d=a.prev_length,g=a.nice_match,f=a.strstart>a.w_size-262?a.strstart-(a.w_size-262):0,e=a.window,h=a.w_mask,k=a.prev,r=a.strstart+258,l=e[v+d-1],q=e[v+d];a.prev_length>=a.good_match&&(c>>=2);g>a.lookahead&&(g=a.lookahead);do{var n=b;if(e[n+d]===q&&e[n+d-1]===l&&e[n]===e[v]&&e[++n]===e[v+1]){v+=2;for(n++;e[++v]===e[++n]&&e[++v]===e[++n]&&e[++v]===e[++n]&&e[++v]===
e[++n]&&e[++v]===e[++n]&&e[++v]===e[++n]&&e[++v]===e[++n]&&e[++v]===e[++n]&&v<r;);n=258-(r-v);v=r-258;if(n>d){a.match_start=b;d=n;if(n>=g)break;l=e[v+d-1];q=e[v+d]}}}while((b=k[b&h])>f&&0!==--c);return d<=a.lookahead?d:a.lookahead}function q(a){var b=a.w_size,c;do{var v=a.window_size-a.lookahead-a.strstart;if(a.strstart>=b+(b-262)){E.arraySet(a.window,a.window,b,b,0);a.match_start-=b;a.strstart-=b;a.block_start-=b;var d=c=a.hash_size;do{var f=a.head[--d];a.head[d]=f>=b?f-b:0}while(--c);d=c=b;do f=
a.prev[--d],a.prev[d]=f>=b?f-b:0;while(--c);v+=b}if(0===a.strm.avail_in)break;d=a.strm;c=a.window;f=a.strstart+a.lookahead;var e=d.avail_in;e>v&&(e=v);0===e?c=0:(d.avail_in-=e,E.arraySet(c,d.input,d.next_in,e,f),1===d.state.wrap?d.adler=P(d.adler,c,e,f):2===d.state.wrap&&(d.adler=g(d.adler,c,e,f)),d.next_in+=e,d.total_in+=e,c=e);a.lookahead+=c;if(3<=a.lookahead+a.insert)for(v=a.strstart-a.insert,a.ins_h=a.window[v],a.ins_h=(a.ins_h<<a.hash_shift^a.window[v+1])&a.hash_mask;a.insert&&!(a.ins_h=(a.ins_h<<
a.hash_shift^a.window[v+3-1])&a.hash_mask,a.prev[v&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=v,v++,a.insert--,3>a.lookahead+a.insert););}while(262>a.lookahead&&0!==a.strm.avail_in)}function k(a,b){for(var c;;){if(262>a.lookahead){q(a);if(262>a.lookahead&&0===b)return 1;if(0===a.lookahead)break}c=0;3<=a.lookahead&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,c=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart);0!==c&&a.strstart-c<=a.w_size-262&&(a.match_length=
h(a,c));if(3<=a.match_length)if(c=L._tr_tally(a,a.strstart-a.match_start,a.match_length-3),a.lookahead-=a.match_length,a.match_length<=a.max_lazy_match&&3<=a.lookahead){a.match_length--;do a.strstart++,a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart;while(0!==--a.match_length);a.strstart++}else a.strstart+=a.match_length,a.match_length=0,a.ins_h=a.window[a.strstart],a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+
1])&a.hash_mask;else c=L._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++;if(c&&(l(a,!1),0===a.strm.avail_out))return 1}a.insert=2>a.strstart?a.strstart:2;return 4===b?(l(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(l(a,!1),0===a.strm.avail_out)?1:2}function x(a,b){for(var c,d;;){if(262>a.lookahead){q(a);if(262>a.lookahead&&0===b)return 1;if(0===a.lookahead)break}c=0;3<=a.lookahead&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,c=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],
a.head[a.ins_h]=a.strstart);a.prev_length=a.match_length;a.prev_match=a.match_start;a.match_length=2;0!==c&&a.prev_length<a.max_lazy_match&&a.strstart-c<=a.w_size-262&&(a.match_length=h(a,c),5>=a.match_length&&(1===a.strategy||3===a.match_length&&4096<a.strstart-a.match_start)&&(a.match_length=2));if(3<=a.prev_length&&a.match_length<=a.prev_length){d=a.strstart+a.lookahead-3;c=L._tr_tally(a,a.strstart-1-a.prev_match,a.prev_length-3);a.lookahead-=a.prev_length-1;a.prev_length-=2;do++a.strstart<=d&&
(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart);while(0!==--a.prev_length);a.match_available=0;a.match_length=2;a.strstart++;if(c&&(l(a,!1),0===a.strm.avail_out))return 1}else if(a.match_available){if((c=L._tr_tally(a,0,a.window[a.strstart-1]))&&l(a,!1),a.strstart++,a.lookahead--,0===a.strm.avail_out)return 1}else a.match_available=1,a.strstart++,a.lookahead--}a.match_available&&(L._tr_tally(a,0,a.window[a.strstart-
1]),a.match_available=0);a.insert=2>a.strstart?a.strstart:2;return 4===b?(l(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(l(a,!1),0===a.strm.avail_out)?1:2}function H(a,b){for(var c,d,g,f=a.window;;){if(258>=a.lookahead){q(a);if(258>=a.lookahead&&0===b)return 1;if(0===a.lookahead)break}a.match_length=0;if(3<=a.lookahead&&0<a.strstart&&(d=a.strstart-1,c=f[d],c===f[++d]&&c===f[++d]&&c===f[++d])){for(g=a.strstart+258;c===f[++d]&&c===f[++d]&&c===f[++d]&&c===f[++d]&&c===f[++d]&&c===f[++d]&&c===f[++d]&&
c===f[++d]&&d<g;);a.match_length=258-(g-d);a.match_length>a.lookahead&&(a.match_length=a.lookahead)}3<=a.match_length?(c=L._tr_tally(a,1,a.match_length-3),a.lookahead-=a.match_length,a.strstart+=a.match_length,a.match_length=0):(c=L._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++);if(c&&(l(a,!1),0===a.strm.avail_out))return 1}a.insert=0;return 4===b?(l(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(l(a,!1),0===a.strm.avail_out)?1:2}function G(a,b){for(var c;;){if(0===a.lookahead&&(q(a),
0===a.lookahead)){if(0===b)return 1;break}a.match_length=0;c=L._tr_tally(a,0,a.window[a.strstart]);a.lookahead--;a.strstart++;if(c&&(l(a,!1),0===a.strm.avail_out))return 1}a.insert=0;return 4===b?(l(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(l(a,!1),0===a.strm.avail_out)?1:2}function C(a,b,c,d,g){this.good_length=a;this.max_lazy=b;this.nice_length=c;this.max_chain=d;this.func=g}function y(){this.strm=null;this.status=0;this.pending_buf=null;this.wrap=this.pending=this.pending_out=this.pending_buf_size=
0;this.gzhead=null;this.gzindex=0;this.method=8;this.last_flush=-1;this.w_mask=this.w_bits=this.w_size=0;this.window=null;this.window_size=0;this.head=this.prev=null;this.nice_match=this.good_match=this.strategy=this.level=this.max_lazy_match=this.max_chain_length=this.prev_length=this.lookahead=this.match_start=this.strstart=this.match_available=this.prev_match=this.match_length=this.block_start=this.hash_shift=this.hash_mask=this.hash_bits=this.hash_size=this.ins_h=0;this.dyn_ltree=new E.Buf16(1146);
this.dyn_dtree=new E.Buf16(122);this.bl_tree=new E.Buf16(78);d(this.dyn_ltree);d(this.dyn_dtree);d(this.bl_tree);this.bl_desc=this.d_desc=this.l_desc=null;this.bl_count=new E.Buf16(16);this.heap=new E.Buf16(573);d(this.heap);this.heap_max=this.heap_len=0;this.depth=new E.Buf16(573);d(this.depth);this.bi_valid=this.bi_buf=this.insert=this.matches=this.static_len=this.opt_len=this.d_buf=this.last_lit=this.lit_bufsize=this.l_buf=0}function D(a){if(!a||!a.state)return c(a,-2);a.total_in=a.total_out=0;
a.data_type=2;var b=a.state;b.pending=0;b.pending_out=0;0>b.wrap&&(b.wrap=-b.wrap);b.status=b.wrap?42:113;a.adler=2===b.wrap?0:1;b.last_flush=0;L._tr_init(b);return 0}function e(a){var b=D(a);0===b&&(a=a.state,a.window_size=2*a.w_size,d(a.head),a.max_lazy_match=F[a.level].max_lazy,a.good_match=F[a.level].good_length,a.nice_match=F[a.level].nice_length,a.max_chain_length=F[a.level].max_chain,a.strstart=0,a.block_start=0,a.lookahead=0,a.insert=0,a.match_length=a.prev_length=2,a.match_available=0,a.ins_h=
0);return b}function K(a,b,d,g,f,h){if(!a)return-2;var B=1;-1===b&&(b=6);0>g?(B=0,g=-g):15<g&&(B=2,g-=16);if(1>f||9<f||8!==d||8>g||15<g||0>b||9<b||0>h||4<h)return c(a,-2);8===g&&(g=9);var v=new y;a.state=v;v.strm=a;v.wrap=B;v.gzhead=null;v.w_bits=g;v.w_size=1<<v.w_bits;v.w_mask=v.w_size-1;v.hash_bits=f+7;v.hash_size=1<<v.hash_bits;v.hash_mask=v.hash_size-1;v.hash_shift=~~((v.hash_bits+3-1)/3);v.window=new E.Buf8(2*v.w_size);v.head=new E.Buf16(v.hash_size);v.prev=new E.Buf16(v.w_size);v.lit_bufsize=
1<<f+6;v.pending_buf_size=4*v.lit_bufsize;v.pending_buf=new E.Buf8(v.pending_buf_size);v.d_buf=1*v.lit_bufsize;v.l_buf=3*v.lit_bufsize;v.level=b;v.strategy=h;v.method=d;return e(a)}var E=a("../utils/common"),L=a("./trees"),P=a("./adler32"),g=a("./crc32"),A=a("./messages");var F=[new C(0,0,0,0,function(a,b){var c=65535;for(c>a.pending_buf_size-5&&(c=a.pending_buf_size-5);;){if(1>=a.lookahead){q(a);if(0===a.lookahead&&0===b)return 1;if(0===a.lookahead)break}a.strstart+=a.lookahead;a.lookahead=0;var d=
a.block_start+c;if(0===a.strstart||a.strstart>=d)if(a.lookahead=a.strstart-d,a.strstart=d,l(a,!1),0===a.strm.avail_out)return 1;if(a.strstart-a.block_start>=a.w_size-262&&(l(a,!1),0===a.strm.avail_out))return 1}a.insert=0;if(4===b)return l(a,!0),0===a.strm.avail_out?3:4;a.strstart>a.block_start&&l(a,!1);return 1}),new C(4,4,8,4,k),new C(4,5,16,8,k),new C(4,6,32,32,k),new C(4,4,16,16,x),new C(8,16,32,32,x),new C(8,16,128,128,x),new C(8,32,128,256,x),new C(32,128,258,1024,x),new C(32,258,258,4096,x)];
f.deflateInit=function(a,b){return K(a,b,8,15,8,0)};f.deflateInit2=K;f.deflateReset=e;f.deflateResetKeep=D;f.deflateSetHeader=function(a,b){if(!a||!a.state||2!==a.state.wrap)return-2;a.state.gzhead=b;return 0};f.deflate=function(a,f){if(!a||!a.state||5<f||0>f)return a?c(a,-2):-2;var e=a.state;if(!a.output||!a.input&&0!==a.avail_in||666===e.status&&4!==f)return c(a,0===a.avail_out?-5:-2);e.strm=a;var h=e.last_flush;e.last_flush=f;if(42===e.status)if(2===e.wrap)a.adler=0,n(e,31),n(e,139),n(e,8),e.gzhead?
(n(e,(e.gzhead.text?1:0)+(e.gzhead.hcrc?2:0)+(e.gzhead.extra?4:0)+(e.gzhead.name?8:0)+(e.gzhead.comment?16:0)),n(e,e.gzhead.time&255),n(e,e.gzhead.time>>8&255),n(e,e.gzhead.time>>16&255),n(e,e.gzhead.time>>24&255),n(e,9===e.level?2:2<=e.strategy||2>e.level?4:0),n(e,e.gzhead.os&255),e.gzhead.extra&&e.gzhead.extra.length&&(n(e,e.gzhead.extra.length&255),n(e,e.gzhead.extra.length>>8&255)),e.gzhead.hcrc&&(a.adler=g(a.adler,e.pending_buf,e.pending,0)),e.gzindex=0,e.status=69):(n(e,0),n(e,0),n(e,0),n(e,
0),n(e,0),n(e,9===e.level?2:2<=e.strategy||2>e.level?4:0),n(e,3),e.status=113);else{var k=8+(e.w_bits-8<<4)<<8;k|=(2<=e.strategy||2>e.level?0:6>e.level?1:6===e.level?2:3)<<6;0!==e.strstart&&(k|=32);e.status=113;m(e,k+(31-k%31));0!==e.strstart&&(m(e,a.adler>>>16),m(e,a.adler&65535));a.adler=1}if(69===e.status)if(e.gzhead.extra){for(k=e.pending;e.gzindex<(e.gzhead.extra.length&65535)&&(e.pending!==e.pending_buf_size||(e.gzhead.hcrc&&e.pending>k&&(a.adler=g(a.adler,e.pending_buf,e.pending-k,k)),b(a),
k=e.pending,e.pending!==e.pending_buf_size));)n(e,e.gzhead.extra[e.gzindex]&255),e.gzindex++;e.gzhead.hcrc&&e.pending>k&&(a.adler=g(a.adler,e.pending_buf,e.pending-k,k));e.gzindex===e.gzhead.extra.length&&(e.gzindex=0,e.status=73)}else e.status=73;if(73===e.status)if(e.gzhead.name){k=e.pending;do{if(e.pending===e.pending_buf_size&&(e.gzhead.hcrc&&e.pending>k&&(a.adler=g(a.adler,e.pending_buf,e.pending-k,k)),b(a),k=e.pending,e.pending===e.pending_buf_size)){var l=1;break}l=e.gzindex<e.gzhead.name.length?
e.gzhead.name.charCodeAt(e.gzindex++)&255:0;n(e,l)}while(0!==l);e.gzhead.hcrc&&e.pending>k&&(a.adler=g(a.adler,e.pending_buf,e.pending-k,k));0===l&&(e.gzindex=0,e.status=91)}else e.status=91;if(91===e.status)if(e.gzhead.comment){k=e.pending;do{if(e.pending===e.pending_buf_size&&(e.gzhead.hcrc&&e.pending>k&&(a.adler=g(a.adler,e.pending_buf,e.pending-k,k)),b(a),k=e.pending,e.pending===e.pending_buf_size)){l=1;break}l=e.gzindex<e.gzhead.comment.length?e.gzhead.comment.charCodeAt(e.gzindex++)&255:0;n(e,
l)}while(0!==l);e.gzhead.hcrc&&e.pending>k&&(a.adler=g(a.adler,e.pending_buf,e.pending-k,k));0===l&&(e.status=103)}else e.status=103;103===e.status&&(e.gzhead.hcrc?(e.pending+2>e.pending_buf_size&&b(a),e.pending+2<=e.pending_buf_size&&(n(e,a.adler&255),n(e,a.adler>>8&255),a.adler=0,e.status=113)):e.status=113);if(0!==e.pending){if(b(a),0===a.avail_out)return e.last_flush=-1,0}else if(0===a.avail_in&&(f<<1)-(4<f?9:0)<=(h<<1)-(4<h?9:0)&&4!==f)return c(a,-5);if(666===e.status&&0!==a.avail_in)return c(a,
-5);if(0!==a.avail_in||0!==e.lookahead||0!==f&&666!==e.status){h=2===e.strategy?G(e,f):3===e.strategy?H(e,f):F[e.level].func(e,f);if(3===h||4===h)e.status=666;if(1===h||3===h)return 0===a.avail_out&&(e.last_flush=-1),0;if(2===h&&(1===f?L._tr_align(e):5!==f&&(L._tr_stored_block(e,0,0,!1),3===f&&(d(e.head),0===e.lookahead&&(e.strstart=0,e.block_start=0,e.insert=0))),b(a),0===a.avail_out))return e.last_flush=-1,0}if(4!==f)return 0;if(0>=e.wrap)return 1;2===e.wrap?(n(e,a.adler&255),n(e,a.adler>>8&255),
n(e,a.adler>>16&255),n(e,a.adler>>24&255),n(e,a.total_in&255),n(e,a.total_in>>8&255),n(e,a.total_in>>16&255),n(e,a.total_in>>24&255)):(m(e,a.adler>>>16),m(e,a.adler&65535));b(a);0<e.wrap&&(e.wrap=-e.wrap);return 0!==e.pending?0:1};f.deflateEnd=function(a){if(!a||!a.state)return-2;var b=a.state.status;if(42!==b&&69!==b&&73!==b&&91!==b&&103!==b&&113!==b&&666!==b)return c(a,-2);a.state=null;return 113===b?c(a,-3):0};f.deflateSetDictionary=function(a,b){var c=b.length;if(!a||!a.state)return-2;var e=a.state;
var g=e.wrap;if(2===g||1===g&&42!==e.status||e.lookahead)return-2;1===g&&(a.adler=P(a.adler,b,c,0));e.wrap=0;if(c>=e.w_size){0===g&&(d(e.head),e.strstart=0,e.block_start=0,e.insert=0);var f=new E.Buf8(e.w_size);E.arraySet(f,b,c-e.w_size,e.w_size,0);b=f;c=e.w_size}f=a.avail_in;var h=a.next_in;var k=a.input;a.avail_in=c;a.next_in=0;a.input=b;for(q(e);3<=e.lookahead;){b=e.strstart;c=e.lookahead-2;do e.ins_h=(e.ins_h<<e.hash_shift^e.window[b+3-1])&e.hash_mask,e.prev[b&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=
b,b++;while(--c);e.strstart=b;e.lookahead=2;q(e)}e.strstart+=e.lookahead;e.block_start=e.strstart;e.insert=e.lookahead;e.lookahead=0;e.match_length=e.prev_length=2;e.match_available=0;a.next_in=h;a.input=k;a.avail_in=f;e.wrap=g;return 0};f.deflateInfo="pako deflate (from Nodeca project)"},{"../utils/common":62,"./adler32":64,"./crc32":66,"./messages":72,"./trees":73}],68:[function(a,p,f){p.exports=function(){this.os=this.xflags=this.time=this.text=0;this.extra=null;this.extra_len=0;this.comment=this.name=
"";this.hcrc=0;this.done=!1}},{}],69:[function(a,p,f){p.exports=function(a,d){var b=a.state;var c=a.next_in;var f=a.input;var m=c+(a.avail_in-5);var h=a.next_out;var q=a.output;d=h-(d-a.avail_out);var k=h+(a.avail_out-257);var p=b.dmax;var H=b.wsize;var G=b.whave;var C=b.wnext;var y=b.window;var D=b.hold;var e=b.bits;var K=b.lencode;var E=b.distcode;var L=(1<<b.lenbits)-1;var P=(1<<b.distbits)-1;a:do{15>e&&(D+=f[c++]<<e,e+=8,D+=f[c++]<<e,e+=8);var g=K[D&L];b:for(;;){var A=g>>>24;D>>>=A;e-=A;A=g>>>
16&255;if(0===A)q[h++]=g&65535;else if(A&16){var F=g&65535;if(A&=15)e<A&&(D+=f[c++]<<e,e+=8),F+=D&(1<<A)-1,D>>>=A,e-=A;15>e&&(D+=f[c++]<<e,e+=8,D+=f[c++]<<e,e+=8);g=E[D&P];c:for(;;){A=g>>>24;D>>>=A;e-=A;A=g>>>16&255;if(A&16){g&=65535;A&=15;e<A&&(D+=f[c++]<<e,e+=8,e<A&&(D+=f[c++]<<e,e+=8));g+=D&(1<<A)-1;if(g>p){a.msg="invalid distance too far back";b.mode=30;break a}D>>>=A;e-=A;A=h-d;if(g>A){A=g-A;if(A>G&&b.sane){a.msg="invalid distance too far back";b.mode=30;break a}var v=0;var M=y;if(0===C){if(v+=
H-A,A<F){F-=A;do q[h++]=y[v++];while(--A);v=h-g;M=q}}else if(C<A){if(v+=H+C-A,A-=C,A<F){F-=A;do q[h++]=y[v++];while(--A);v=0;if(C<F){A=C;F-=A;do q[h++]=y[v++];while(--A);v=h-g;M=q}}}else if(v+=C-A,A<F){F-=A;do q[h++]=y[v++];while(--A);v=h-g;M=q}for(;2<F;)q[h++]=M[v++],q[h++]=M[v++],q[h++]=M[v++],F-=3;F&&(q[h++]=M[v++],1<F&&(q[h++]=M[v++]))}else{v=h-g;do q[h++]=q[v++],q[h++]=q[v++],q[h++]=q[v++],F-=3;while(2<F);F&&(q[h++]=q[v++],1<F&&(q[h++]=q[v++]))}}else if(0===(A&64)){g=E[(g&65535)+(D&(1<<A)-1)];
continue c}else{a.msg="invalid distance code";b.mode=30;break a}break}}else if(0===(A&64)){g=K[(g&65535)+(D&(1<<A)-1)];continue b}else{A&32?b.mode=12:(a.msg="invalid literal/length code",b.mode=30);break a}break}}while(c<m&&h<k);F=e>>3;c-=F;e-=F<<3;a.next_in=c;a.next_out=h;a.avail_in=c<m?5+(m-c):5-(c-m);a.avail_out=h<k?257+(k-h):257-(h-k);b.hold=D&(1<<e)-1;b.bits=e}},{}],70:[function(a,p,f){function c(a){return(a>>>24&255)+(a>>>8&65280)+((a&65280)<<8)+((a&255)<<24)}function d(){this.mode=0;this.last=
!1;this.wrap=0;this.havedict=!1;this.total=this.check=this.dmax=this.flags=0;this.head=null;this.wnext=this.whave=this.wsize=this.wbits=0;this.window=null;this.extra=this.offset=this.length=this.bits=this.hold=0;this.distcode=this.lencode=null;this.have=this.ndist=this.nlen=this.ncode=this.distbits=this.lenbits=0;this.next=null;this.lens=new q.Buf16(320);this.work=new q.Buf16(288);this.distdyn=this.lendyn=null;this.was=this.back=this.sane=0}function b(a){if(!a||!a.state)return-2;var b=a.state;a.total_in=
a.total_out=b.total=0;a.msg="";b.wrap&&(a.adler=b.wrap&1);b.mode=1;b.last=0;b.havedict=0;b.dmax=32768;b.head=null;b.hold=0;b.bits=0;b.lencode=b.lendyn=new q.Buf32(852);b.distcode=b.distdyn=new q.Buf32(592);b.sane=1;b.back=-1;return 0}function l(a){if(!a||!a.state)return-2;var c=a.state;c.wsize=0;c.whave=0;c.wnext=0;return b(a)}function n(a,b){if(!a||!a.state)return-2;var c=a.state;if(0>b){var d=0;b=-b}else d=(b>>4)+1,48>b&&(b&=15);if(b&&(8>b||15<b))return-2;null!==c.window&&c.wbits!==b&&(c.window=
null);c.wrap=d;c.wbits=b;return l(a)}function m(a,b){if(!a)return-2;var c=new d;a.state=c;c.window=null;b=n(a,b);0!==b&&(a.state=null);return b}function h(a,b,c,d){var e=a.state;null===e.window&&(e.wsize=1<<e.wbits,e.wnext=0,e.whave=0,e.window=new q.Buf8(e.wsize));d>=e.wsize?(q.arraySet(e.window,b,c-e.wsize,e.wsize,0),e.wnext=0,e.whave=e.wsize):(a=e.wsize-e.wnext,a>d&&(a=d),q.arraySet(e.window,b,c-d,a,e.wnext),(d-=a)?(q.arraySet(e.window,b,c-d,d,0),e.wnext=d,e.whave=e.wsize):(e.wnext+=a,e.wnext===
e.wsize&&(e.wnext=0),e.whave<e.wsize&&(e.whave+=a)));return 0}var q=a("../utils/common"),k=a("./adler32"),x=a("./crc32"),H=a("./inffast"),G=a("./inftrees"),C=!0,y,D;f.inflateReset=l;f.inflateReset2=n;f.inflateResetKeep=b;f.inflateInit=function(a){return m(a,15)};f.inflateInit2=m;f.inflate=function(a,b){var d,e=new q.Buf8(4),f=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!a||!a.state||!a.output||!a.input&&0!==a.avail_in)return-2;var g=a.state;12===g.mode&&(g.mode=13);var l=a.next_out;var n=
a.output;var p=a.avail_out;var m=a.next_in;var B=a.input;var w=a.avail_in;var u=g.hold;var t=g.bits;var K=w;var I=p;var N=0;a:for(;;)switch(g.mode){case 1:if(0===g.wrap){g.mode=13;break}for(;16>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}if(g.wrap&2&&35615===u){g.check=0;e[0]=u&255;e[1]=u>>>8&255;g.check=x(g.check,e,2,0);t=u=0;g.mode=2;break}g.flags=0;g.head&&(g.head.done=!1);if(!(g.wrap&1)||(((u&255)<<8)+(u>>8))%31){a.msg="incorrect header check";g.mode=30;break}if(8!==(u&15)){a.msg="unknown compression method";
g.mode=30;break}u>>>=4;t-=4;var z=(u&15)+8;if(0===g.wbits)g.wbits=z;else if(z>g.wbits){a.msg="invalid window size";g.mode=30;break}g.dmax=1<<z;a.adler=g.check=1;g.mode=u&512?10:12;t=u=0;break;case 2:for(;16>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}g.flags=u;if(8!==(g.flags&255)){a.msg="unknown compression method";g.mode=30;break}if(g.flags&57344){a.msg="unknown header flags set";g.mode=30;break}g.head&&(g.head.text=u>>8&1);g.flags&512&&(e[0]=u&255,e[1]=u>>>8&255,g.check=x(g.check,e,2,0));t=u=0;
g.mode=3;case 3:for(;32>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}g.head&&(g.head.time=u);g.flags&512&&(e[0]=u&255,e[1]=u>>>8&255,e[2]=u>>>16&255,e[3]=u>>>24&255,g.check=x(g.check,e,4,0));t=u=0;g.mode=4;case 4:for(;16>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}g.head&&(g.head.xflags=u&255,g.head.os=u>>8);g.flags&512&&(e[0]=u&255,e[1]=u>>>8&255,g.check=x(g.check,e,2,0));t=u=0;g.mode=5;case 5:if(g.flags&1024){for(;16>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}g.length=u;g.head&&(g.head.extra_len=u);
g.flags&512&&(e[0]=u&255,e[1]=u>>>8&255,g.check=x(g.check,e,2,0));t=u=0}else g.head&&(g.head.extra=null);g.mode=6;case 6:if(g.flags&1024){var r=g.length;r>w&&(r=w);r&&(g.head&&(z=g.head.extra_len-g.length,g.head.extra||(g.head.extra=Array(g.head.extra_len)),q.arraySet(g.head.extra,B,m,r,z)),g.flags&512&&(g.check=x(g.check,B,r,m)),w-=r,m+=r,g.length-=r);if(g.length)break a}g.length=0;g.mode=7;case 7:if(g.flags&2048){if(0===w)break a;r=0;do z=B[m+r++],g.head&&z&&65536>g.length&&(g.head.name+=String.fromCharCode(z));
while(z&&r<w);g.flags&512&&(g.check=x(g.check,B,r,m));w-=r;m+=r;if(z)break a}else g.head&&(g.head.name=null);g.length=0;g.mode=8;case 8:if(g.flags&4096){if(0===w)break a;r=0;do z=B[m+r++],g.head&&z&&65536>g.length&&(g.head.comment+=String.fromCharCode(z));while(z&&r<w);g.flags&512&&(g.check=x(g.check,B,r,m));w-=r;m+=r;if(z)break a}else g.head&&(g.head.comment=null);g.mode=9;case 9:if(g.flags&512){for(;16>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}if(u!==(g.check&65535)){a.msg="header crc mismatch";
g.mode=30;break}t=u=0}g.head&&(g.head.hcrc=g.flags>>9&1,g.head.done=!0);a.adler=g.check=0;g.mode=12;break;case 10:for(;32>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}a.adler=g.check=c(u);t=u=0;g.mode=11;case 11:if(0===g.havedict)return a.next_out=l,a.avail_out=p,a.next_in=m,a.avail_in=w,g.hold=u,g.bits=t,2;a.adler=g.check=1;g.mode=12;case 12:if(5===b||6===b)break a;case 13:if(g.last){u>>>=t&7;t-=t&7;g.mode=27;break}for(;3>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}g.last=u&1;u>>>=1;--t;switch(u&3){case 0:g.mode=
14;break;case 1:z=g;if(C){y=new q.Buf32(512);D=new q.Buf32(32);for(r=0;144>r;)z.lens[r++]=8;for(;256>r;)z.lens[r++]=9;for(;280>r;)z.lens[r++]=7;for(;288>r;)z.lens[r++]=8;G(1,z.lens,0,288,y,0,z.work,{bits:9});for(r=0;32>r;)z.lens[r++]=5;G(2,z.lens,0,32,D,0,z.work,{bits:5});C=!1}z.lencode=y;z.lenbits=9;z.distcode=D;z.distbits=5;g.mode=20;if(6===b){u>>>=2;t-=2;break a}break;case 2:g.mode=17;break;case 3:a.msg="invalid block type",g.mode=30}u>>>=2;t-=2;break;case 14:u>>>=t&7;for(t-=t&7;32>t;){if(0===
w)break a;w--;u+=B[m++]<<t;t+=8}if((u&65535)!==(u>>>16^65535)){a.msg="invalid stored block lengths";g.mode=30;break}g.length=u&65535;t=u=0;g.mode=15;if(6===b)break a;case 15:g.mode=16;case 16:if(r=g.length){r>w&&(r=w);r>p&&(r=p);if(0===r)break a;q.arraySet(n,B,m,r,l);w-=r;m+=r;p-=r;l+=r;g.length-=r;break}g.mode=12;break;case 17:for(;14>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}g.nlen=(u&31)+257;u>>>=5;t-=5;g.ndist=(u&31)+1;u>>>=5;t-=5;g.ncode=(u&15)+4;u>>>=4;t-=4;if(286<g.nlen||30<g.ndist){a.msg=
"too many length or distance symbols";g.mode=30;break}g.have=0;g.mode=18;case 18:for(;g.have<g.ncode;){for(;3>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}g.lens[f[g.have++]]=u&7;u>>>=3;t-=3}for(;19>g.have;)g.lens[f[g.have++]]=0;g.lencode=g.lendyn;g.lenbits=7;r={bits:g.lenbits};N=G(0,g.lens,0,19,g.lencode,0,g.work,r);g.lenbits=r.bits;if(N){a.msg="invalid code lengths set";g.mode=30;break}g.have=0;g.mode=19;case 19:for(;g.have<g.nlen+g.ndist;){for(;;){var J=g.lencode[u&(1<<g.lenbits)-1];r=J>>>24;J&=
65535;if(r<=t)break;if(0===w)break a;w--;u+=B[m++]<<t;t+=8}if(16>J)u>>>=r,t-=r,g.lens[g.have++]=J;else{if(16===J){for(z=r+2;t<z;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}u>>>=r;t-=r;if(0===g.have){a.msg="invalid bit length repeat";g.mode=30;break}z=g.lens[g.have-1];r=3+(u&3);u>>>=2;t-=2}else if(17===J){for(z=r+3;t<z;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}u>>>=r;t-=r;z=0;r=3+(u&7);u>>>=3;t-=3}else{for(z=r+7;t<z;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}u>>>=r;t-=r;z=0;r=11+(u&127);u>>>=7;t-=7}if(g.have+
r>g.nlen+g.ndist){a.msg="invalid bit length repeat";g.mode=30;break}for(;r--;)g.lens[g.have++]=z}}if(30===g.mode)break;if(0===g.lens[256]){a.msg="invalid code -- missing end-of-block";g.mode=30;break}g.lenbits=9;r={bits:g.lenbits};N=G(1,g.lens,0,g.nlen,g.lencode,0,g.work,r);g.lenbits=r.bits;if(N){a.msg="invalid literal/lengths set";g.mode=30;break}g.distbits=6;g.distcode=g.distdyn;r={bits:g.distbits};N=G(2,g.lens,g.nlen,g.ndist,g.distcode,0,g.work,r);g.distbits=r.bits;if(N){a.msg="invalid distances set";
g.mode=30;break}g.mode=20;if(6===b)break a;case 20:g.mode=21;case 21:if(6<=w&&258<=p){a.next_out=l;a.avail_out=p;a.next_in=m;a.avail_in=w;g.hold=u;g.bits=t;H(a,I);l=a.next_out;n=a.output;p=a.avail_out;m=a.next_in;B=a.input;w=a.avail_in;u=g.hold;t=g.bits;12===g.mode&&(g.back=-1);break}for(g.back=0;;){J=g.lencode[u&(1<<g.lenbits)-1];r=J>>>24;z=J>>>16&255;J&=65535;if(r<=t)break;if(0===w)break a;w--;u+=B[m++]<<t;t+=8}if(z&&0===(z&240)){var O=r;var S=z;for(d=J;;){J=g.lencode[d+((u&(1<<O+S)-1)>>O)];r=J>>>
24;z=J>>>16&255;J&=65535;if(O+r<=t)break;if(0===w)break a;w--;u+=B[m++]<<t;t+=8}u>>>=O;t-=O;g.back+=O}u>>>=r;t-=r;g.back+=r;g.length=J;if(0===z){g.mode=26;break}if(z&32){g.back=-1;g.mode=12;break}if(z&64){a.msg="invalid literal/length code";g.mode=30;break}g.extra=z&15;g.mode=22;case 22:if(g.extra){for(z=g.extra;t<z;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}g.length+=u&(1<<g.extra)-1;u>>>=g.extra;t-=g.extra;g.back+=g.extra}g.was=g.length;g.mode=23;case 23:for(;;){J=g.distcode[u&(1<<g.distbits)-1];
r=J>>>24;z=J>>>16&255;J&=65535;if(r<=t)break;if(0===w)break a;w--;u+=B[m++]<<t;t+=8}if(0===(z&240)){O=r;S=z;for(d=J;;){J=g.distcode[d+((u&(1<<O+S)-1)>>O)];r=J>>>24;z=J>>>16&255;J&=65535;if(O+r<=t)break;if(0===w)break a;w--;u+=B[m++]<<t;t+=8}u>>>=O;t-=O;g.back+=O}u>>>=r;t-=r;g.back+=r;if(z&64){a.msg="invalid distance code";g.mode=30;break}g.offset=J;g.extra=z&15;g.mode=24;case 24:if(g.extra){for(z=g.extra;t<z;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}g.offset+=u&(1<<g.extra)-1;u>>>=g.extra;t-=g.extra;
g.back+=g.extra}if(g.offset>g.dmax){a.msg="invalid distance too far back";g.mode=30;break}g.mode=25;case 25:if(0===p)break a;r=I-p;if(g.offset>r){r=g.offset-r;if(r>g.whave&&g.sane){a.msg="invalid distance too far back";g.mode=30;break}r>g.wnext?(r-=g.wnext,z=g.wsize-r):z=g.wnext-r;r>g.length&&(r=g.length);O=g.window}else O=n,z=l-g.offset,r=g.length;r>p&&(r=p);p-=r;g.length-=r;do n[l++]=O[z++];while(--r);0===g.length&&(g.mode=21);break;case 26:if(0===p)break a;n[l++]=g.length;p--;g.mode=21;break;case 27:if(g.wrap){for(;32>
t;){if(0===w)break a;w--;u|=B[m++]<<t;t+=8}I-=p;a.total_out+=I;g.total+=I;I&&(a.adler=g.check=g.flags?x(g.check,n,I,l-I):k(g.check,n,I,l-I));I=p;if((g.flags?u:c(u))!==g.check){a.msg="incorrect data check";g.mode=30;break}t=u=0}g.mode=28;case 28:if(g.wrap&&g.flags){for(;32>t;){if(0===w)break a;w--;u+=B[m++]<<t;t+=8}if(u!==(g.total&4294967295)){a.msg="incorrect length check";g.mode=30;break}t=u=0}g.mode=29;case 29:N=1;break a;case 30:N=-3;break a;case 31:return-4;default:return-2}a.next_out=l;a.avail_out=
p;a.next_in=m;a.avail_in=w;g.hold=u;g.bits=t;if((g.wsize||I!==a.avail_out&&30>g.mode&&(27>g.mode||4!==b))&&h(a,a.output,a.next_out,I-a.avail_out))return g.mode=31,-4;K-=a.avail_in;I-=a.avail_out;a.total_in+=K;a.total_out+=I;g.total+=I;g.wrap&&I&&(a.adler=g.check=g.flags?x(g.check,n,I,a.next_out-I):k(g.check,n,I,a.next_out-I));a.data_type=g.bits+(g.last?64:0)+(12===g.mode?128:0)+(20===g.mode||15===g.mode?256:0);(0===K&&0===I||4===b)&&0===N&&(N=-5);return N};f.inflateEnd=function(a){if(!a||!a.state)return-2;
var b=a.state;b.window&&(b.window=null);a.state=null;return 0};f.inflateGetHeader=function(a,b){if(!a||!a.state)return-2;a=a.state;if(0===(a.wrap&2))return-2;a.head=b;b.done=!1;return 0};f.inflateSetDictionary=function(a,b){var c=b.length;if(!a||!a.state)return-2;var d=a.state;if(0!==d.wrap&&11!==d.mode)return-2;if(11===d.mode){var e=k(1,b,c,0);if(e!==d.check)return-3}if(h(a,b,c,c))return d.mode=31,-4;d.havedict=1;return 0};f.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":62,
"./adler32":64,"./crc32":66,"./inffast":69,"./inftrees":71}],71:[function(a,p,f){var c=a("../utils/common"),d=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],b=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],l=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],n=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,
28,29,29,64,64];p.exports=function(a,f,q,k,p,H,G,C){var h=C.bits,m,e,x,E,L,P,g=0,A=new c.Buf16(16);var F=new c.Buf16(16);var v,M=0;for(m=0;15>=m;m++)A[m]=0;for(e=0;e<k;e++)A[f[q+e]]++;var B=h;for(x=15;1<=x&&0===A[x];x--);B>x&&(B=x);if(0===x)return p[H++]=20971520,p[H++]=20971520,C.bits=1,0;for(h=1;h<x&&0===A[h];h++);B<h&&(B=h);for(m=E=1;15>=m;m++)if(E<<=1,E-=A[m],0>E)return-1;if(0<E&&(0===a||1!==x))return-1;F[1]=0;for(m=1;15>m;m++)F[m+1]=F[m]+A[m];for(e=0;e<k;e++)0!==f[q+e]&&(G[F[f[q+e]]++]=e);if(0===
a){var w=v=G;var u=19}else 1===a?(w=d,g-=257,v=b,M-=257,u=256):(w=l,v=n,u=-1);e=L=0;m=h;var t=H;k=B;F=0;var Q=-1;var I=1<<B;var N=I-1;if(1===a&&852<I||2===a&&592<I)return 1;for(;;){var z=m-F;if(G[e]<u){var r=0;var J=G[e]}else G[e]>u?(r=v[M+G[e]],J=w[g+G[e]]):(r=96,J=0);E=1<<m-F;h=P=1<<k;do P-=E,p[t+(L>>F)+P]=z<<24|r<<16|J|0;while(0!==P);for(E=1<<m-1;L&E;)E>>=1;0!==E?(L&=E-1,L+=E):L=0;e++;if(0===--A[m]){if(m===x)break;m=f[q+G[e]]}if(m>B&&(L&N)!==Q){0===F&&(F=B);t+=h;k=m-F;for(E=1<<k;k+F<x;){E-=A[k+
F];if(0>=E)break;k++;E<<=1}I+=1<<k;if(1===a&&852<I||2===a&&592<I)return 1;Q=L&N;p[Q]=B<<24|k<<16|t-H|0}}0!==L&&(p[t+L]=m-F<<24|4194304);C.bits=B;return 0}},{"../utils/common":62}],72:[function(a,p,f){p.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],73:[function(a,p,f){function c(a){for(var b=a.length;0<=--b;)a[b]=0}function d(a,b,c,d,e){this.static_tree=a;this.extra_bits=
b;this.extra_base=c;this.elems=d;this.max_length=e;this.has_stree=a&&a.length}function b(a,b){this.dyn_tree=a;this.max_code=0;this.stat_desc=b}function l(a,b){a.pending_buf[a.pending++]=b&255;a.pending_buf[a.pending++]=b>>>8&255}function n(a,b,c){a.bi_valid>16-c?(a.bi_buf|=b<<a.bi_valid&65535,l(a,a.bi_buf),a.bi_buf=b>>16-a.bi_valid,a.bi_valid+=c-16):(a.bi_buf|=b<<a.bi_valid&65535,a.bi_valid+=c)}function m(a,b,c){n(a,c[2*b],c[2*b+1])}function h(a,b){var c=0;do c|=a&1,a>>>=1,c<<=1;while(0<--b);return c>>>
1}function q(a,b,c){var d=Array(16),e=0,f;for(f=1;15>=f;f++)d[f]=e=e+c[f-1]<<1;for(c=0;c<=b;c++)e=a[2*c+1],0!==e&&(a[2*c]=h(d[e]++,e))}function k(a){var b;for(b=0;286>b;b++)a.dyn_ltree[2*b]=0;for(b=0;30>b;b++)a.dyn_dtree[2*b]=0;for(b=0;19>b;b++)a.bl_tree[2*b]=0;a.dyn_ltree[512]=1;a.opt_len=a.static_len=0;a.last_lit=a.matches=0}function x(a){8<a.bi_valid?l(a,a.bi_buf):0<a.bi_valid&&(a.pending_buf[a.pending++]=a.bi_buf);a.bi_buf=0;a.bi_valid=0}function H(a,b,c,d){var e=2*b,f=2*c;return a[e]<a[f]||a[e]===
a[f]&&d[b]<=d[c]}function G(a,b,c){for(var d=a.heap[c],e=c<<1;e<=a.heap_len;){e<a.heap_len&&H(b,a.heap[e+1],a.heap[e],a.depth)&&e++;if(H(b,d,a.heap[e],a.depth))break;a.heap[c]=a.heap[e];c=e;e<<=1}a.heap[c]=d}function C(a,b,c){var d=0;if(0!==a.last_lit){do{var e=a.pending_buf[a.d_buf+2*d]<<8|a.pending_buf[a.d_buf+2*d+1];var f=a.pending_buf[a.l_buf+d];d++;if(0===e)m(a,f,b);else{var r=w[f];m(a,r+256+1,b);var h=P[r];0!==h&&(f-=u[r],n(a,f,h));e--;r=256>e?B[e]:B[256+(e>>>7)];m(a,r,c);h=g[r];0!==h&&(e-=
t[r],n(a,e,h))}}while(d<a.last_lit)}m(a,256,b)}function y(a,b){var c=b.dyn_tree,d=b.stat_desc.static_tree,e=b.stat_desc.has_stree,f=b.stat_desc.elems,g,h=-1;a.heap_len=0;a.heap_max=573;for(g=0;g<f;g++)0!==c[2*g]?(a.heap[++a.heap_len]=h=g,a.depth[g]=0):c[2*g+1]=0;for(;2>a.heap_len;){var r=a.heap[++a.heap_len]=2>h?++h:0;c[2*r]=1;a.depth[r]=0;a.opt_len--;e&&(a.static_len-=d[2*r+1])}b.max_code=h;for(g=a.heap_len>>1;1<=g;g--)G(a,c,g);r=f;do g=a.heap[1],a.heap[1]=a.heap[a.heap_len--],G(a,c,1),d=a.heap[1],
a.heap[--a.heap_max]=g,a.heap[--a.heap_max]=d,c[2*r]=c[2*g]+c[2*d],a.depth[r]=(a.depth[g]>=a.depth[d]?a.depth[g]:a.depth[d])+1,c[2*g+1]=c[2*d+1]=r,a.heap[1]=r++,G(a,c,1);while(2<=a.heap_len);a.heap[--a.heap_max]=a.heap[1];g=b.dyn_tree;r=b.max_code;d=b.stat_desc.static_tree;e=b.stat_desc.has_stree;f=b.stat_desc.extra_bits;var k=b.stat_desc.extra_base,m=b.stat_desc.max_length,l,n=0;for(l=0;15>=l;l++)a.bl_count[l]=0;g[2*a.heap[a.heap_max]+1]=0;for(b=a.heap_max+1;573>b;b++){var p=a.heap[b];l=g[2*g[2*
p+1]+1]+1;l>m&&(l=m,n++);g[2*p+1]=l;if(!(p>r)){a.bl_count[l]++;var t=0;p>=k&&(t=f[p-k]);var u=g[2*p];a.opt_len+=u*(l+t);e&&(a.static_len+=u*(d[2*p+1]+t))}}if(0!==n){do{for(l=m-1;0===a.bl_count[l];)l--;a.bl_count[l]--;a.bl_count[l+1]+=2;a.bl_count[m]--;n-=2}while(0<n);for(l=m;0!==l;l--)for(p=a.bl_count[l];0!==p;)d=a.heap[--b],d>r||(g[2*d+1]!==l&&(a.opt_len+=(l-g[2*d+1])*g[2*d],g[2*d+1]=l),p--)}q(c,h,a.bl_count)}function D(a,b,c){var d,e=-1,g=b[1],f=0,h=7,r=4;0===g&&(h=138,r=3);b[2*(c+1)+1]=65535;for(d=
0;d<=c;d++){var k=g;g=b[2*(d+1)+1];++f<h&&k===g||(f<r?a.bl_tree[2*k]+=f:0!==k?(k!==e&&a.bl_tree[2*k]++,a.bl_tree[32]++):10>=f?a.bl_tree[34]++:a.bl_tree[36]++,f=0,e=k,0===g?(h=138,r=3):k===g?(h=6,r=3):(h=7,r=4))}}function e(a,b,c){var d,e=-1,g=b[1],f=0,h=7,k=4;0===g&&(h=138,k=3);for(d=0;d<=c;d++){var r=g;g=b[2*(d+1)+1];if(!(++f<h&&r===g)){if(f<k){do m(a,r,a.bl_tree);while(0!==--f)}else 0!==r?(r!==e&&(m(a,r,a.bl_tree),f--),m(a,16,a.bl_tree),n(a,f-3,2)):10>=f?(m(a,17,a.bl_tree),n(a,f-3,3)):(m(a,18,a.bl_tree),
n(a,f-11,7));f=0;e=r;0===g?(h=138,k=3):r===g?(h=6,k=3):(h=7,k=4)}}}function K(a){var b=4093624447,c;for(c=0;31>=c;c++,b>>>=1)if(b&1&&0!==a.dyn_ltree[2*c])return 0;if(0!==a.dyn_ltree[18]||0!==a.dyn_ltree[20]||0!==a.dyn_ltree[26])return 1;for(c=32;256>c;c++)if(0!==a.dyn_ltree[2*c])return 1;return 0}function E(a,b,c,d){n(a,d?1:0,3);x(a);l(a,c);l(a,~c);L.arraySet(a.pending_buf,a.window,b,c,a.pending);a.pending+=c}var L=a("../utils/common"),P=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],
g=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],A=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],F=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],v=Array(576);c(v);var M=Array(60);c(M);var B=Array(512);c(B);var w=Array(256);c(w);var u=Array(29);c(u);var t=Array(30);c(t);var Q,I,N,z=!1;f._tr_init=function(a){if(!z){var c,e,f,l=Array(16);for(f=e=0;28>f;f++)for(u[f]=e,c=0;c<1<<P[f];c++)w[e++]=f;w[e-1]=f;for(f=e=0;16>f;f++)for(t[f]=e,c=0;c<1<<g[f];c++)B[e++]=f;for(e>>=7;30>f;f++)for(t[f]=
e<<7,c=0;c<1<<g[f]-7;c++)B[256+e++]=f;for(c=0;15>=c;c++)l[c]=0;for(c=0;143>=c;)v[2*c+1]=8,c++,l[8]++;for(;255>=c;)v[2*c+1]=9,c++,l[9]++;for(;279>=c;)v[2*c+1]=7,c++,l[7]++;for(;287>=c;)v[2*c+1]=8,c++,l[8]++;q(v,287,l);for(c=0;30>c;c++)M[2*c+1]=5,M[2*c]=h(c,5);Q=new d(v,P,257,286,15);I=new d(M,g,0,30,15);N=new d([],A,0,19,7);z=!0}a.l_desc=new b(a.dyn_ltree,Q);a.d_desc=new b(a.dyn_dtree,I);a.bl_desc=new b(a.bl_tree,N);a.bi_buf=0;a.bi_valid=0;k(a)};f._tr_stored_block=E;f._tr_flush_block=function(a,b,
c,d){var f=0;if(0<a.level){2===a.strm.data_type&&(a.strm.data_type=K(a));y(a,a.l_desc);y(a,a.d_desc);D(a,a.dyn_ltree,a.l_desc.max_code);D(a,a.dyn_dtree,a.d_desc.max_code);y(a,a.bl_desc);for(f=18;3<=f&&0===a.bl_tree[2*F[f]+1];f--);a.opt_len+=3*(f+1)+14;var g=a.opt_len+3+7>>>3;var h=a.static_len+3+7>>>3;h<=g&&(g=h)}else g=h=c+5;if(c+4<=g&&-1!==b)E(a,b,c,d);else if(4===a.strategy||h===g)n(a,2+(d?1:0),3),C(a,v,M);else{n(a,4+(d?1:0),3);b=a.l_desc.max_code+1;c=a.d_desc.max_code+1;f+=1;n(a,b-257,5);n(a,
c-1,5);n(a,f-4,4);for(g=0;g<f;g++)n(a,a.bl_tree[2*F[g]+1],3);e(a,a.dyn_ltree,b-1);e(a,a.dyn_dtree,c-1);C(a,a.dyn_ltree,a.dyn_dtree)}k(a);d&&x(a)};f._tr_tally=function(a,b,c){a.pending_buf[a.d_buf+2*a.last_lit]=b>>>8&255;a.pending_buf[a.d_buf+2*a.last_lit+1]=b&255;a.pending_buf[a.l_buf+a.last_lit]=c&255;a.last_lit++;0===b?a.dyn_ltree[2*c]++:(a.matches++,b--,a.dyn_ltree[2*(w[c]+256+1)]++,a.dyn_dtree[2*(256>b?B[b]:B[256+(b>>>7)])]++);return a.last_lit===a.lit_bufsize-1};f._tr_align=function(a){n(a,2,
3);m(a,256,v);16===a.bi_valid?(l(a,a.bi_buf),a.bi_buf=0,a.bi_valid=0):8<=a.bi_valid&&(a.pending_buf[a.pending++]=a.bi_buf&255,a.bi_buf>>=8,a.bi_valid-=8)}},{"../utils/common":62}],74:[function(a,p,f){p.exports=function(){this.input=null;this.total_in=this.avail_in=this.next_in=0;this.output=null;this.total_out=this.avail_out=this.next_out=0;this.msg="";this.state=null;this.data_type=2;this.adler=0}},{}]},{},[10])(10)});
