/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.encoding.BufferManagerReadStream;
import com.sun.corba.se.impl.encoding.CDRInputObject;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyOrReplyMessage;
import com.sun.corba.se.pept.encoding.InputObject;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.CorbaResponseWaitingRoom;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public class CorbaResponseWaitingRoomImpl
implements CorbaResponseWaitingRoom {
    private ORB orb;
    private ORBUtilSystemException wrapper;
    private CorbaConnection connection;
    private Hashtable out_calls = null;

    public CorbaResponseWaitingRoomImpl(ORB oRB, CorbaConnection corbaConnection) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.transport");
        this.connection = corbaConnection;
        this.out_calls = new Hashtable();
    }

    @Override
    public void registerWaiter(MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerWaiter: " + this.opAndId(corbaMessageMediator));
        }
        Integer n = corbaMessageMediator.getRequestIdInteger();
        OutCallDesc outCallDesc = new OutCallDesc();
        outCallDesc.thread = Thread.currentThread();
        outCallDesc.messageMediator = corbaMessageMediator;
        this.out_calls.put(n, outCallDesc);
    }

    @Override
    public void unregisterWaiter(MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        if (this.orb.transportDebugFlag) {
            this.dprint(".unregisterWaiter: " + this.opAndId(corbaMessageMediator));
        }
        Integer n = corbaMessageMediator.getRequestIdInteger();
        this.out_calls.remove(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputObject waitForResponse(MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        try {
            InputObject inputObject = null;
            if (this.orb.transportDebugFlag) {
                this.dprint(".waitForResponse->: " + this.opAndId(corbaMessageMediator));
            }
            Integer n = corbaMessageMediator.getRequestIdInteger();
            if (corbaMessageMediator.isOneWay()) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".waitForResponse: one way - not waiting: " + this.opAndId(corbaMessageMediator));
                }
                InputObject inputObject2 = null;
                return inputObject2;
            }
            OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n);
            if (outCallDesc == null) {
                throw this.wrapper.nullOutCall(CompletionStatus.COMPLETED_MAYBE);
            }
            Object object = outCallDesc.done;
            synchronized (object) {
                while (outCallDesc.inputObject == null && outCallDesc.exception == null) {
                    try {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".waitForResponse: waiting: " + this.opAndId(corbaMessageMediator));
                        }
                        outCallDesc.done.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (outCallDesc.exception != null) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".waitForResponse: exception: " + this.opAndId(corbaMessageMediator));
                    }
                    throw outCallDesc.exception;
                }
                inputObject = outCallDesc.inputObject;
            }
            if (inputObject != null) {
                ((CDRInputObject)inputObject).unmarshalHeader();
            }
            object = inputObject;
            return object;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".waitForResponse<-: " + this.opAndId(corbaMessageMediator));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceived(InputObject inputObject) {
        CDRInputObject cDRInputObject = (CDRInputObject)inputObject;
        LocateReplyOrReplyMessage locateReplyOrReplyMessage = (LocateReplyOrReplyMessage)cDRInputObject.getMessageHeader();
        Integer n = new Integer(locateReplyOrReplyMessage.getRequestId());
        OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n);
        if (this.orb.transportDebugFlag) {
            this.dprint(".responseReceived: id/" + n + ": " + locateReplyOrReplyMessage);
        }
        if (outCallDesc == null) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".responseReceived: id/" + n + ": no waiter: " + locateReplyOrReplyMessage);
            }
            return;
        }
        Object object = outCallDesc.done;
        synchronized (object) {
            CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)outCallDesc.messageMediator;
            if (this.orb.transportDebugFlag) {
                this.dprint(".responseReceived: " + this.opAndId(corbaMessageMediator) + ": notifying waiters");
            }
            corbaMessageMediator.setReplyHeader(locateReplyOrReplyMessage);
            corbaMessageMediator.setInputObject(inputObject);
            cDRInputObject.setMessageMediator(corbaMessageMediator);
            outCallDesc.inputObject = inputObject;
            outCallDesc.done.notify();
        }
    }

    @Override
    public int numberRegistered() {
        return this.out_calls.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalExceptionToAllWaiters(SystemException systemException) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".signalExceptionToAllWaiters: " + systemException);
        }
        Enumeration enumeration = this.out_calls.elements();
        while (enumeration.hasMoreElements()) {
            OutCallDesc outCallDesc = (OutCallDesc)enumeration.nextElement();
            Object object = outCallDesc.done;
            synchronized (object) {
                CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)outCallDesc.messageMediator;
                CDRInputObject cDRInputObject = (CDRInputObject)corbaMessageMediator.getInputObject();
                if (cDRInputObject != null) {
                    BufferManagerReadStream bufferManagerReadStream = (BufferManagerReadStream)cDRInputObject.getBufferManager();
                    int n = corbaMessageMediator.getRequestId();
                    bufferManagerReadStream.cancelProcessing(n);
                }
                outCallDesc.inputObject = null;
                outCallDesc.exception = systemException;
                outCallDesc.done.notify();
            }
        }
    }

    @Override
    public MessageMediator getMessageMediator(int n) {
        Integer n2 = new Integer(n);
        OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n2);
        if (outCallDesc == null) {
            return null;
        }
        return outCallDesc.messageMediator;
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CorbaResponseWaitingRoomImpl", string);
    }

    protected String opAndId(CorbaMessageMediator corbaMessageMediator) {
        return ORBUtility.operationNameAndRequestId(corbaMessageMediator);
    }

    static final class OutCallDesc {
        Object done = new Object();
        Thread thread;
        MessageMediator messageMediator;
        SystemException exception;
        InputObject inputObject;

        OutCallDesc() {
        }
    }
}

