#version 450


// Uniform buffer
layout (std140, binding = 2) uniform uniforms_t
{ 
  mat4 ViewProjectionMatrix;
  mat4 ModelMatrix;
} ub;


layout (location = 0) in vec4 vposition;
layout (location = 1) in vec4 vtexcoord;
//layout (location = 2) in vec4 vnormal;
layout (location = 3) in vec4 vcolor;

layout (location = 0) out vec4 v_color;
layout (location = 1) out vec4 v_texcoord;

out gl_PerVertex 
{
  vec4 gl_Position;
};

void main()
{
  vec4 P = ub.ModelMatrix * vposition;
  gl_Position = ub.ViewProjectionMatrix * P;
  
  v_color = vcolor;
  v_texcoord = vtexcoord;
}
