#version 450

//#extension GL_ARB_separate_shader_objects : enable
//#extension GL_ARB_shading_language_420pack : enable


layout (std140, binding = 0) uniform uniforms_t
{ 
  mat4 camera1_projection; // Offset = 0
  mat4 camera1_view; // Offset = 64
  mat4 camera2_view_projection; // Offset = 2*64
  mat4 camera_ortho1_view_projection; // Offset = 3*64
  mat4 camera_ortho2_view_projection; // Offset = 4*64
  mat4 fullscreen_quad_transform; // Offset = 5*64
  mat4 mesh_transform; // Offset = 6*64
  mat4 mesh2_transform; // Offset = 7*64
  vec4 bkg_uv_tiling; // Offset = 8*64
  vec4 mesh_uv_tiling; // Offset = 8*64 + 16
} ub;



layout (location = 0) in vec4 vposition;
layout (location = 1) in vec4 vtexcoord;
layout (location = 2) in vec4 vnormal;
layout (location = 3) in vec4 vcolor;

layout (location = 0) out vec4 v_color;
layout (location = 1) out vec4 v_texcoord;

out gl_PerVertex 
{
  vec4 gl_Position;
};

void main()
{
  vec4 P = ub.mesh2_transform * vposition;
  gl_Position = ub.camera2_view_projection * P;
   
  // GL->VK conventions
  //gl_Position.y = -gl_Position.y;
  gl_Position.z = (gl_Position.z + gl_Position.w) / 2.0;
  
  v_color = vcolor;
  v_texcoord = vtexcoord;
}
