#version 450

layout (std140, binding = 0) uniform uniforms_t
{ 
  mat4 ProjectionMatrix;
  mat4 ViewMatrix;
  mat4 ModelMatrix;
  vec4 uv_tiling;
} ub;


layout (location = 0) in vec4 vposition;
layout (location = 1) in vec4 vtexcoord;
layout (location = 2) in vec4 vnormal;
layout (location = 3) in vec4 vcolor;

layout (location = 0) out vec4 v_color;
layout (location = 1) out vec4 v_texcoord;
layout (location = 2) out vec4 v_normal;
layout (location = 3) out vec4 v_eye_dir;
layout (location = 4) out vec4 v_light_dir;

out gl_PerVertex 
{
  vec4 gl_Position;
};


void main()
{
  mat4 ModelViewMatrix = ub.ViewMatrix * ub.ModelMatrix;
  vec4 P = ModelViewMatrix * vposition;




  // GL->VK conventions
  // From the Mali SDK:
  /*
  /// @brief Converts an OpenGL style projection matrix to Vulkan style projection
  /// matrix.
  ///
  /// Vulkan has a topLeft clipSpace with [0, 1] depth range instead of [-1, 1].
  ///
  /// GLM outputs projection matrices in GL style clipSpace,
  /// perform a simple fix-up step to change the projection to VulkanStyle.
  ///
  /// @param proj Projection matrix
  ///
  /// @returns A Vulkan compatible projection matrix.
  inline glm::mat4 vulkanStyleProjection(const glm::mat4 &proj)
  {
    using namespace glm;

    // Flip Y in clipspace. X = -1, Y = -1 is topLeft in Vulkan.
    auto mat = scale(mat4(1.0f), vec3(1.0f, -1.0f, 1.0f));

    // Z depth is [0, 1] range instead of [-1, 1].
    mat = scale(mat, vec3(1.0f, 1.0f, 0.5f));
    return translate(mat, vec3(0.0f, 0.0f, 1.0f)) * proj;
  }
  */

  // This is more or less the same code directly in GLSL.
  /*
  mat4 vkProj = mat4(1.0);
  vkProj[0][0] = 1.0;
	vkProj[1][1] = -1.0;
	vkProj[2][2] = 0.5;
  vkProj[3] = vkProj[2] + vkProj[3];
  vkProj *= ub.ProjectionMatrix;

  gl_Position = vkProj * P;
  */



  gl_Position = ub.ProjectionMatrix * P;
  
  // GL->VK conventions
  gl_Position.y = -gl_Position.y;
  gl_Position.z = (gl_Position.z + gl_Position.w) / 2.0;
  
 
 v_normal = ModelViewMatrix * vnormal;
  
  vec4 v = P;
  v_eye_dir = -v;
  vec4 lp = ub.ViewMatrix * vec4(0.0, 50.0, 50.0, 1.0);
  v_light_dir = lp - v;  
  
  v_color = vcolor;
  v_texcoord = vtexcoord * ub.uv_tiling;
}
