﻿-- ArmoredPacksCbmMod by 2S v2.2.0

-- NOTE:
-- Please do not distribute this code without permission.
-- You can edit this file only for personal use. 
-- If this code is re-released in your mod, please add credits.
-- Thanks..

-------------------------------------------------------------------------------------------------------------------
local ArmoredPacksCbmMod = {}
function ArmoredPacksCbmMod.unload()	
	UI.REMOVE_BLIP(blip)
end

local Notification = {}

function Notification.unload() end
function Notification.init() end
function Notification.tick() end

function notify(msg) 
	UI._SET_NOTIFICATION_TEXT_ENTRY("STRING")
	UI._ADD_TEXT_COMPONENT_STRING(msg)
	UI._DRAW_NOTIFICATION(FALSE, FALSE)
end

--DISPLAY BLIP
local blip = UI.ADD_BLIP_FOR_COORD(-481.640,-2697.659,8.760)
		UI.SET_BLIP_COLOUR(blip, 1)
		UI.SET_BLIP_SPRITE(blip, 426)
		UI.SET_BLIP_NAME_FROM_TEXT_FILE(blip, "Chinese Black Market")
		UI.SET_BLIP_SCALE(blip, 1)
		UI.SET_BLIP_AS_SHORT_RANGE(blip, true)

-------------MENU KEYS----------------
--NUMPAD
local openMenukey = Keys.E
local upKey = Keys.NumPad8
local downKey = Keys.NumPad2
local selectKey = Keys.NumPad5
local cancelKey = Keys.NumPad0

--ARROW KEYS
local arrowupKey = Keys.Up
local arrowdownKey = Keys.Down
local arrowselectKey = Keys.Return
local arrowcancelKey = Keys.Back

-------------------------------------------------------------------------------------------------------------------
--DO NOT EDIT BEYOND THIS POINT------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------

function mainCbmInit()
	APCbmGUI = APCbmGUIinit()

	--MENU
	APCbmGUI.mainMenu("main", "", "CHINESE BM - SPORTS CAR", 0.17, 0.1, 0.234, 0.0522, 0.003, 0.35, 2)
	APCbmGUI.addButton("main", "Kuruma $95000", spawnChineseVehicle,"kuruma", false, 0.35, 0)
	APCbmGUI.addButton("main", "Sentinel XS $60000", spawnChineseVehicle,"sentinel", false, 0.35, 0)
	APCbmGUI.addButton("main", "Sentinel Conver. $95000", spawnChineseVehicle,"sentinel2", false, 0.35, 0)
	APCbmGUI.addButton("main", "Oracle $80000", spawnChineseVehicle,"oracle", false, 0.35, 0)
	APCbmGUI.addButton("main", "Oracle XS $82000", spawnChineseVehicle,"oracle2", false, 0.35, 0)
	APCbmGUI.addButton("main", "Fusilade $36000", spawnChineseVehicle,"fusilade", false, 0.35, 0)
	APCbmGUI.addButton("main", "9F Cabrio $130000", spawnChineseVehicle,"ninef2", false, 0.35, 0)
	APCbmGUI.addButton("main", "9F $120000", spawnChineseVehicle,"ninef", false, 0.35, 0)
	APCbmGUI.addButton("main", "NEXT >", APCbmGUI.setActiveMenu, "menu2", false, 0.35, 1)

	APCbmGUI.mainMenu("menu2", "main", "CHINESE BM - SPORTS CAR", 0.17, 0.1, 0.234, 0.0522, 0.003, 0.35, 2)	
	APCbmGUI.addButton("menu2", "Penumbra $24000", spawnChineseVehicle,"penumbra", false, 0.35, 0)
	APCbmGUI.addButton("menu2", "Coquette $138000", spawnChineseVehicle,"coquette", false, 0.35, 0)
	APCbmGUI.addButton("menu2", "Carbonizzare $195000", spawnChineseVehicle,"carbonizzare", false, 0.35, 0)
	APCbmGUI.addButton("menu2", "Jester $240000", spawnChineseVehicle,"jester", false, 0.35, 0)
	APCbmGUI.addButton("menu2", "Rapid GT $132000", spawnChineseVehicle,"rapidgt", false, 0.35, 0)
	APCbmGUI.addButton("menu2", "Rapid GT Conver. $164000", spawnChineseVehicle,"rapidgt2", false, 0.35, 0)
	APCbmGUI.addButton("menu2", "Buffalo $96000", spawnChineseVehicle,"buffalo", false, 0.35, 0)
	APCbmGUI.addButton("menu2", "PREV <", APCbmGUI.setActiveMenu, "main", false, 0.35, 1)	
	APCbmGUI.addButton("menu2", "NEXT >", APCbmGUI.setActiveMenu, "menu3", false, 0.35, 1)

	APCbmGUI.mainMenu("menu3", "main", "CHINESE BM - SPORTS CAR", 0.17, 0.1, 0.234, 0.0522, 0.003, 0.35, 2)
	APCbmGUI.addButton("menu3", "Comet $100000", spawnChineseVehicle,"comet2", false, 0.35, 0)
	APCbmGUI.addButton("menu3", "Banshee $105000", spawnChineseVehicle,"banshee", false, 0.35, 0)
	APCbmGUI.addButton("menu3", "Surano $110000", spawnChineseVehicle,"surano", false, 0.35, 0)
	APCbmGUI.addButton("menu3", "Schwartzer $80000", spawnChineseVehicle,"schwarzer", false, 0.35, 0)
	APCbmGUI.addButton("menu3", "Elegy RH8 $260000", spawnChineseVehicle,"elegy2", false, 0.35, 0)
	APCbmGUI.addButton("menu3", "Khamelion $290000", spawnChineseVehicle,"khamelion", false, 0.35, 0)
	APCbmGUI.addButton("menu3", "PREV <", APCbmGUI.setActiveMenu, "menu2", false, 0.35, 1)	
end

local ArmoredPacksCbmMod = {}

function ArmoredPacksCbmMod.unload()
end
function ArmoredPacksCbmMod.init()
mainCbmInit()

	--NUMPAD
	local E = openMenukey
	local numpad8 = upKey
	local numpad2 = downKey
	local numpad5 = selectKey
	local numpad0 = cancelKey
	
	--ARROW KEYS
	local keyup = arrowupKey
	local keydown = arrowdownKey
	local keyenter = arrowselectKey
	local keybackspace = arrowcancelKey

	APCbmGUI.updateSelection = {["menuOpen"] = {["keys"] = {E},["menu"] = "main"},["menuUp"] = {["keys"] = {numpad8,keyup}}, 
		["menuDown"] = {["keys"] = {numpad2,keydown}},["menuCancel"] = {["keys"] = {numpad0,keybackspace}},["select"] = {["keys"] = {numpad5,keyenter}}}
end
function ArmoredPacksCbmMod.tick()
	

	
		APCbmGUI.tick()
		
end

-------------------------------------------------------------------------------------------------------------------

function APCbmGUIinit()
	APCbmGUI = {}
	APCbmGUI.menu = {}
	APCbmGUI.buttons = {}
	APCbmGUI.updateSelection = {["menuOpen"] = {["keys"] = {},["menu"] = ""},["menuUp"] = {["keys"] = {}},
		["menuDown"] = {["keys"] = {}},["menuCancel"] = {["keys"] = {}},["select"] = {["keys"] = {}}}
	APCbmGUI.activeButton = 1
	APCbmGUI.activeMenu = ""
	APCbmGUI.IndexStatus = {["text"] = "", ["time"] = 0}

	function APCbmGUI.mainMenu(menuName, prevMenu, title, xmin, ymin, xmax, ymax, Space, textScale, font)
		if(APCbmGUI.menu[menuName] == nil) then
			APCbmGUI.menu[menuName] = {}
			lastOffset = ymin + ymax + Space
		end

		APCbmGUI.menu[menuName] = {["prevMenu"] = prevMenu,["title"] = title,["xmin"] = xmin,["ymin"] = ymin,
			["xmax"] = xmax,["ymax"] = ymax,["spacing"] = Space,["textScale"] = textScale,
			["font"] = font,["lastOffset"] = lastOffset,["numButtons"] = 0}
	end
	
	function APCbmGUI.addButton(mainMenu, text, funct, args, selectable, textScale, font)
		if(APCbmGUI.buttons[mainMenu] == nil or APCbmGUI.buttons[mainMenu]["settings"] == nil) then
			APCbmGUI.buttons[mainMenu] = {["settings"] = {}}
		end

		local currButtonNum = #APCbmGUI.buttons[mainMenu].settings + 1
		APCbmGUI.menu[mainMenu].numButtons = currButtonNum

		if(selectable) then
			selectableOn = false
		else
		    selectableOn = nil
		end

		APCbmGUI.buttons[mainMenu].settings[currButtonNum] = {["mainMenu"] = mainMenu,["text"] = text,["funct"] = funct,
			["args"] = args,["font"] = font,["xmin"] = APCbmGUI.menu[mainMenu].xmin,
			["ymin"] = APCbmGUI.menu[mainMenu].lastOffset,["xmax"] = APCbmGUI.menu[mainMenu].xmax,
			["ymax"] = APCbmGUI.menu[mainMenu].ymax,["textScale"] = textScale,
			["selectable"] = selectable,["selectableOn"] = selectableOn}

		APCbmGUI.menu[mainMenu]["lastOffset"] = (APCbmGUI.menu[mainMenu].lastOffset + APCbmGUI.menu[mainMenu].ymax + APCbmGUI.menu[mainMenu].spacing)
	end

	function APCbmGUI.setActiveMenu(menuName)
		APCbmGUI.activeButton = 1
		APCbmGUI.activeMenu = menuName
	end

	function APCbmGUI.drawIndex()
		if(nextDrawTime == nil or prevText ~= APCbmGUI.IndexStatus.text) then
			nextDrawTime = GAMEPLAY.GET_GAME_TIMER() + APCbmGUI.IndexStatus.time
		end

		if(nextDrawTime > GAMEPLAY.GET_GAME_TIMER()) then
			prevText = APCbmGUI.IndexStatus.text
			UI.SET_TEXT_FONT(0)
			UI.SET_TEXT_SCALE(0.0, 0.35)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_WRAP(0, 1)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(10, 10, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(APCbmGUI.IndexStatus.text)
			UI._DRAW_TEXT(xmin , 0.5)
		else
			APCbmGUI.IndexStatus = {["text"] = "", ["time"] = 0}
			nextDrawTime = nil
		end
	end

	function addButtonText(text, xmin, ymin, textScale, font)
		if(text ~= nil and xmin ~= nil and ymin ~= nil and textScale ~= nil and font ~= nil) then
			UI.SET_TEXT_FONT(font)
			UI.SET_TEXT_SCALE(0.0, 0.30)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(text)
			UI._DRAW_TEXT(xmin , ymin - 0.0125)
		else
			print("text: ", text, ", xmin: ", xmin, ", ymin: ", ymin, ", textScale: ", textScale, ", font: ", font)
		    APCbmGUI.setActiveMenu("")
		end
	end

	function APCbmGUI.drawAPCbmGUI()
		if(APCbmGUI.activeMenu ~= "" and APCbmGUI.activeMenu ~= nil) then
			local name = APCbmGUI.activeMenu

			if(APCbmGUI.menu[name] ~= nil) then
				local xmin = APCbmGUI.menu[name].xmin
				local ymin = APCbmGUI.menu[name].ymin
				local xmax = APCbmGUI.menu[name].xmax
				local ymax = APCbmGUI.menu[name].ymax
				
				local text = APCbmGUI.menu[name].title
				local textScale = APCbmGUI.menu[name].textScale
				local font = APCbmGUI.menu[name].font
				local colors = {["r"] = 0, ["g"] = 0, ["b"] = 0, ["o"] = 255}

				addButtonText(text, xmin, ymin, textScale, font)
				GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);

				if(APCbmGUI.buttons[name] ~= nil) then
					for i, v in pairs(APCbmGUI.buttons[name].settings) do
						local buttonSettings = APCbmGUI.buttons[name].settings[i]
						local xmin = buttonSettings.xmin
						local ymin = buttonSettings.ymin
						local xmax = buttonSettings.xmax
						local ymax = buttonSettings.ymax
						
						local font = buttonSettings.font
						local text = buttonSettings.text
						local textScale = buttonSettings.textScale
						local colors = {["r"] = 180, ["g"] = 180, ["b"] = 180, ["o"] = 180}

						if(buttonSettings.selectableOn == true) then
							text = buttonSettings.text .. " [ON]"
						elseif(buttonSettings.selectableOn == false) then
							text = buttonSettings.text .. " [OFF]"
						end
						
						if(i == APCbmGUI.activeButton) then
							colors = {["r"] = 220, ["g"] = 220, ["b"] = 250, ["o"] = 200}
						end

						addButtonText(text, xmin, ymin, textScale, font)
						GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);
					end
				else
					APCbmGUI.setActiveMenu("")
				end
			else
				APCbmGUI.setActiveMenu("")
			end
		end
	end

	function APCbmGUI.updateIndexStatus(text, time)
		APCbmGUI.IndexStatus = {["text"] = text, ["time"] = time}
	end

	function APCbmGUI.isButtonselectableOn()
		local activeButton = APCbmGUI.buttons[APCbmGUI.activeMenu].settings[APCbmGUI.activeButton]
		if(activeButton.selectable) then
			return activeButton.selectableOn
		elseif(activeButton.selectable == flse) then
			print("Button \"", APCbmGUI.buttons[APCbmGUI.activeMenu].settings[APCbmGUI.activeButton].text, "\"")
		    return nil
		end
	end

	function APCbmGUI.toggleButtonState()
		local activeButton = APCbmGUI.buttons[APCbmGUI.activeMenu].settings[APCbmGUI.activeButton]
		
		if(APCbmGUI.isButtonselectableOn() and activeButton.selectable) then
			activeButton.selectableOn = false
		elseif(APCbmGUI.isButtonselectableOn() == false and activeButton.selectable) then
			activeButton.selectableOn = true
			print("toggled on")
		end
	end

	function APCbmGUI.tick()
		APCbmGUI.drawIndex()
		APCbmGUI.drawAPCbmGUI()

		for i, key in pairs(APCbmGUI.updateSelection.menuOpen.keys) do
			if(get_key_pressed(key)) then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					if(APCbmGUI.activeMenu == APCbmGUI.updateSelection.menuOpen.menu) then
						APCbmGUI.setActiveMenu(APCbmGUI.menu[APCbmGUI.activeMenu].prevMenu)
					else
					    APCbmGUI.setActiveMenu(APCbmGUI.updateSelection.menuOpen.menu)
					    APCbmGUI.currentSelection = 1
					end
				end
			
			end
		end

		for k, key in pairs(APCbmGUI.updateSelection.menuUp.keys) do
			if(get_key_pressed(key) and APCbmGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APCbmGUI.activeButton = APCbmGUI.activeButton - 1

					if(APCbmGUI.activeButton <= 0) then
						APCbmGUI.activeButton = APCbmGUI.menu[APCbmGUI.activeMenu].numButtons
					end
				end
			
			end
		end

		for k, key in pairs(APCbmGUI.updateSelection.menuDown.keys) do
			if(get_key_pressed(key) and APCbmGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APCbmGUI.activeButton = APCbmGUI.activeButton + 1
					if(APCbmGUI.activeButton > APCbmGUI.menu[APCbmGUI.activeMenu].numButtons) then
						APCbmGUI.activeButton = 1
					end
				end
			
			end
		end

		for k, key in pairs(APCbmGUI.updateSelection.select.keys) do
			if(get_key_pressed(key) and APCbmGUI.activeMenu ~= "") then
			   if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
				local currButton = APCbmGUI.buttons[APCbmGUI.activeMenu].settings[APCbmGUI.activeButton]
				
				if(type(currButton.funct) == "function" and type(currButton.args) == "table") then
					APCbmGUI.toggleButtonState()
					currButton.funct(currButton.args[1], currButton.args[2], currButton.args[3], currButton.args[4], currButton.args[5], currButton.args[6], currButton.args[7], currButton.args[8], currButton.args[9], currButton.args[10], currButton.args[11], currButton.args[12], currButton.args[13], currButton.args[14], currButton.args[15], currButton.args[16], currButton.args[17], currButton.args[18], currButton.args[19], currButton.args[20])

				elseif(type(currButton.funct) == "function" and type(currButton.args) == "string" or type(currButton.args) == "number"or type(currButton.args) == "boolean") then
					APCbmGUI.toggleButtonState()
					currButton.funct(currButton.args)
					
				elseif(currButton.args == nil) then
					APCbmGUI.toggleButtonState()
					currButton.funct()

				else
					print("function: ", currButton.funct, ", args: ", currButton.args)
				end
			   end
			
			end
		end

		for k, key in pairs(APCbmGUI.updateSelection.menuCancel.keys) do
			if(get_key_pressed(key) and APCbmGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APCbmGUI.setActiveMenu(APCbmGUI.menu[APCbmGUI.activeMenu].prevMenu)
				end
			
			end
		end
	end

	return APCbmGUI
end

-------------------------------------------------------------------------------------------------------------------

--PRICES
	--SPORTS
local sptskurumaCost = 95000
local sptssentinelxsCost = 60000
local sptssentinelconverCost = 95000
local sptsoracleCost = 80000
local sptsoraclexsCost = 82000
local sptsfusiladeCost = 36000
local sptscometCost = 100000
local spts9fcabrioCost = 130000
local spts9fCost = 120000
local sptspenumbraCost = 24000
local sptsfuroregtCost = 448000
local sptscoquetteCost = 138000
local sptscarbonizzareCost = 195000
local sptsjesterCost = 240000
local sptsrapidgtCost = 132000
local sptsrapidgtconverCost = 164000
local sptsbuffaloCost = 96000
local sptsbansheeCost = 105000
local sptssuranoCost = 110000
local sptsschwartzerCost = 80000
local sptsfeltzerCost = 145000
local sptselegyrh8Cost = 260000
local sptskhamelionCost = 290000

--CARNAME
	--SPORTS
local sptskurumaCarName = "Kuruma"
local sptssentinelxsCarName = "Sentinel XS"
local sptssentinelconverCarName = "Sentinel Convert."
local sptsoracleCarName = "Oracle"
local sptsoraclexsCarName = "Oracle XS"
local sptsfusiladeCarName = "Fusilade"
local sptscometCarName = "Comet"
local spts9fcabrioCarName = "9F Cabrio"
local spts9fCarName = "9F"
local sptspenumbraCarName = "Penumbra"
local sptsfuroregtCarName = "Furore GT"
local sptscoquetteCarName = "Coquette"
local sptscarbonizzareCarName = "Carbonizzare"
local sptsjesterCarName = "Jester"
local sptsrapidgtCarName = "Rapid GT"
local sptsbuffaloCarName = "Buffalo"
local sptsbansheeCarName = "Banshee"
local sptssuranoCarName = "Surano"
local sptsschwartzerCarName = "Schwartzer"
local sptsfeltzerCarName = "Feltzer"
local sptselegyrh8CarName = "Elegy"
local sptskhamelionCarName = "Khamelion"

local showMenu = false

local buy = false
local timebuy = 99999
local CarName = "not set"

local spawned = false
local lPed
local ingotC

-------------------------------------------------------------------------------------------------------------------

--Pay System
function Pay(pay)

local playerPed = PLAYER.PLAYER_PED_ID()

		if (PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_zero"))) then
			model = 0
		elseif (PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_one"))) then                                
			model = 1                                         
		elseif (PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_two"))) then
			model = 2
		end
	
		local statname = "SP"..model.."_TOTAL_CASH"
		local hash = GAMEPLAY.GET_HASH_KEY(statname)
		local bool, val = STATS.STAT_GET_INT(hash, 0, -1)

		STATS.STAT_SET_INT(hash, val - pay, true)

end

------------------------------------------------------------------------------

function ArmoredPacksCbmMod.tick()

	local playerPed = PLAYER.PLAYER_PED_ID()
	local playerPedinV = PED.IS_PED_IN_ANY_VEHICLE(playerPed, false)
	local playerCoords = ENTITY.GET_ENTITY_COORDS(playerPed, true)
	local buyPoint = GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS(playerCoords.x, playerCoords.y, playerCoords.z, -480.889, -2697.060, 8.760, true	)
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local location = ENTITY.GET_ENTITY_COORDS( playerPed, nil )
	
	--SHOW MENU FLAG
	if (not playerPedinV and buyPoint < 2 and not showMenu) then
		if PED._IS_PED_DEAD(lPed, true) then
			notify("The Dealer is not here, come back later.")
		else
			notify("Welcome, find anything you like? PRESS E")
		
			if get_key_pressed(Keys.E) then
				showMenu = true
			end
		end
	end

	--SHOW MENU
	if(showMenu == true) then
		APCbmGUI.tick()
	end

	--CLOSE MENU
	if(buyPoint > 2 and get_key_pressed(Keys.E)) then
		showMenu = false
	elseif(buyPoint > 10 and showMenu == true) then
		showMenu = false
	end

	--PLAYER & DEALER DISTANCE
	if(buyPoint > 5 and showMenu == true) then
		notify("PRESS E to close the Menu")
	end

	--SPAWN/DESPAWN DEALER
	if(spawned == false and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,-481.640, -2697.659, 8.760, false ) < 250 ) then
		spawnChineseDealer()
		spawned = true
	elseif(spawned == true and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,-481.640, -2697.659, 8.760, false ) > 250 ) then
		PED.DELETE_PED(lPed)
		PED.DELETE_PED(cPed[0])
		PED.DELETE_PED(cPed[1])
		PED.DELETE_PED(cPed[2])
		PED.DELETE_PED(cPed[3])
		PED.DELETE_PED(cPed[4])
		PED.DELETE_PED(cPed[5])
		PED.DELETE_PED(cPed[6])
		PED.DELETE_PED(cPed[7])
		PED.DELETE_PED(cPed[8])
		PED.DELETE_PED(cPed[9])
		PED.DELETE_PED(cPed[10])
		PED.DELETE_PED(cPed[11])
		PED.DELETE_PED(cPed[12])
		PED.DELETE_PED(cPed[13])
		PED.DELETE_PED(cPed[14])
		PED.DELETE_PED(cPed[15])
		PED.DELETE_PED(cPed[16])
		PED.DELETE_PED(cPed[17])
		PED.DELETE_PED(cPed[18])
		PED.DELETE_PED(cPed[19])
		PED.DELETE_PED(cPed[20])
		PED.DELETE_PED(cPed[21])
		PED.DELETE_PED(cPed[22])
		PED.DELETE_PED(cPed[23])
		PED.DELETE_PED(cPed[24])
		PED.DELETE_PED(cPed[25])
		PED.DELETE_PED(cPed[26])
		laobanMoney = 0
		spawned = false
	end
		
	
end

--DEALER SPAWN
function spawnChineseDealer()

	local weapon = GAMEPLAY.GET_HASH_KEY("WEAPON_BULLPUPRIFLE")
	local weapon2 = GAMEPLAY.GET_HASH_KEY("WEAPON_SNIPERRIFLE")
	local weapon3 = GAMEPLAY.GET_HASH_KEY("WEAPON_RPG")

	---LAOBAN---
	local laoban = GAMEPLAY.GET_HASH_KEY("G_M_M_ChiBoss_01")
	STREAMING.REQUEST_MODEL(laoban)
	while(not STREAMING.HAS_MODEL_LOADED(laoban)) do
		wait(50)
	end
	lPed = PED.CREATE_PED(1, laoban, -481.640, -2697.659, 8.760, 292, true, true)
	PED.SET_PED_CAN_SWITCH_WEAPON(lPed, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(lPed, weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(lPed, GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(lPed, false)
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(laoban)
	laobanMoney = (GAMEPLAY.GET_RANDOM_INT_IN_RANGE(20000,100000))
	PED.SET_PED_MONEY(lPed, laobanMoney)


	---COLD---
	cold = GAMEPLAY.GET_HASH_KEY("G_M_M_ChiCold_01")

	STREAMING.REQUEST_MODEL(cold)
	
	while(not STREAMING.HAS_MODEL_LOADED(cold)) do
		wait(50)
	end
	
	cPed = {}
	
	cPed[0] = PED.CREATE_PED(1, cold, -481.513, -2696.879, 11.848, 305, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[0], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[0], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[0], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[0], false)
	
	cPed[1] = PED.CREATE_PED(1, cold, -476.383, -2688.153, 8.761, 223, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[1], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[1], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[1], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[1], false)
	
	cPed[2] = PED.CREATE_PED(1, cold, -482.740, -2702.558, 8.760, 327, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[2], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[2], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[2], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[2], false)
	
	cPed[3] = PED.CREATE_PED(1, cold, -477.017, -2692.987, 14.494, 294, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[3], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[3], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[3], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[3], false)

	cPed[4] = PED.CREATE_PED(1, cold, -476.737, -2692.466, 21.744, 267, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[4], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[4], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[4], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[4], false)

	cPed[5] = PED.CREATE_PED(1, cold, -494.301, -2707.481, 14.494, 219, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[5], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[5], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[5], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[5], false)

	cPed[6] = PED.CREATE_PED(1, cold, -494.083, -2687.021, 17.368, 45, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[6], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[6], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[6], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[6], false)

	cPed[7] = PED.CREATE_PED(1, cold, -501.397, -2702.813, 14.494, 136, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[7], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[7], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[7], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[7], false)

	cPed[8] = PED.CREATE_PED(1, cold, -488.137, -2704.798, 14.494, 185, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[8], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[8], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[8], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[8], false)

	cPed[9] = PED.CREATE_PED(1, cold, -484.132, -2697.717, 17.374, 245, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[9], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[9], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[9], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[9], false)

	cPed[10] = PED.CREATE_PED(1, cold, -487.618, -2700.714, 17.374, 227, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[10], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[10], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[10], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[10], false)

	cPed[11] = PED.CREATE_PED(1, cold, -494.176, -2701.657, 20.680, 213, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[11], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[11], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[11], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[11], false)

	cPed[12] = PED.CREATE_PED(1, cold, -499.865, -2716.556, 8.758, 225, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[12], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[12], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[12], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[12], false)

	cPed[13] = PED.CREATE_PED(1, cold, -510.298, -2708.531, 8.760, 137, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[13], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[13], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[13], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[13], false)

	cPed[14] = PED.CREATE_PED(1, cold, -498.030, -2681.907, 8.760, 52, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[14], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[14], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[14], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[14], false)

	cPed[15] = PED.CREATE_PED(1, cold, -457.049, -2677.182, 8.761, 238, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[15], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[15], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[15], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[15], false)

	cPed[16] = PED.CREATE_PED(1, cold, -431.687, -2651.799, 8.761, 231, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[16], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[16], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[16], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[16], false)

	cPed[17] = PED.CREATE_PED(1, cold, -450.814, -2635.935, 8.761, 41, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[17], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[17], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[17], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[17], false)

	cPed[18] = PED.CREATE_PED(1, cold, -392.383, -2607.383, 13.640, 161, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[18], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[18], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[18], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[18], false)

	cPed[19] = PED.CREATE_PED(1, cold, -394.855, -2593.529, 13.663, 138, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[19], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[19], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[19], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[19], false)

	cPed[20] = PED.CREATE_PED(1, cold, -410.701, -2625.060, 8.761, 239, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[20], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[20], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[20], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[20], false)

	cPed[21] = PED.CREATE_PED(1, cold, -416.991, -2628.957, 8.761, 156, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[21], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[21], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[21], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[21], false)

	cPed[22] = PED.CREATE_PED(1, cold, -434.642, -2642.749, 8.761, 138, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[22], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[22], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[22], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[22], false)

	cPed[23] = PED.CREATE_PED(1, cold, -427.278, -2667.056, 26.877, 315, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[23], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[23], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[23], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[23], false)

	cPed[24] = PED.CREATE_PED(1, cold, -430.361, -2661.680, 24.500, 328, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[24], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[24], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[24], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[24], false)

	cPed[25] = PED.CREATE_PED(1, cold, -435.329, -2665.982, 20.342, 94, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[25], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[25], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[25], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[25], false)

	cPed[26] = PED.CREATE_PED(1, cold, -398.245, -2614.124, 8.795, 226, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(cPed[26], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(cPed[26], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(cPed[26], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(cPed[26], false)			

	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(cold)
	
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY("ingot"))
	
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY("ingot"))) do
		wait(50)
	end
	
	ingotC = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY("ingot"), -471.850, -2703.931, 6.000, 264, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(ingotC)
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(ingotC)
	
end

--VEHICLE SPAWN
function spawnChineseVehicle(modelString) 

	print (timebuy)
	print(TIME.GET_CLOCK_DAY_OF_MONTH())
	print(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)

if(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
	
	local cost
		
	timebuy = TIME.GET_CLOCK_DAY_OF_MONTH()
		
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY(modelString))
		
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY(modelString))) do
		wait(50)
	end
		
	local vehC = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY(modelString), -462.602, -2699.252, 6.000, 311, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(vehC)
		
			VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(vehC, false) 		
			VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(vehC, true)
			VEHICLE.SET_VEHICLE_IS_STOLEN(vehC, false)
			VEHICLE.SET_VEHICLE_IS_WANTED(vehC, false)
			VEHICLE.SET_VEHICLE_MOD_KIT(vehC, 0)
			VEHICLE.SET_VEHICLE_MOD(vehC, 16, 2, true)
			VEHICLE.SET_VEHICLE_WHEEL_TYPE(vehC, 120)
			VEHICLE.SET_VEHICLE_WINDOW_TINT(vehC, 4) 
			VEHICLE.SET_CAN_RESPRAY_VEHICLE(vehC, true) 
			VEHICLE.SET_VEHICLE_CUSTOM_PRIMARY_COLOUR(vehC, 255, 255, 255)
			VEHICLE.SET_VEHICLE_CUSTOM_PRIMARY_COLOUR(vehC, 211, 211, 211)
			VEHICLE.SET_VEHICLE_TYRES_CAN_BURST(vehC, true) 
			VEHICLE.SET_VEHICLE_WHEELS_CAN_BREAK(vehC, true) 			
			VEHICLE.SET_VEHICLE_NUMBER_PLATE_TEXT(vehC, "L0TU5")
		
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(modelString))

	if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("kuruma")) then cost = sptskurumaCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("sentinel")) then cost = sptssentinelxsCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("sentinel2")) then cost = sptssentinelconverCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("oracle")) then cost = sptsoracleCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("oracle2")) then cost = sptsoraclexsCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("fusilade")) then cost = sptsfusiladeCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("comet2")) then cost = sptscometCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("ninef2")) then cost = spts9fcabrioCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("ninef")) then cost = spts9fCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("penumbra")) then cost = sptspenumbraCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("furore")) then cost = sptsfuroregtCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("coquette")) then cost = sptscoquetteCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("carbonizzare")) then cost = sptscarbonizzareCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("jester")) then cost = sptsjesterCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("rapidgt")) then cost = sptsrapidgtCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("rapidgt2")) then cost = sptsrapidgtconverCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("buffalo")) then cost = sptsbuffaloCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("banshee")) then cost = sptsbansheeCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("surano")) then cost = sptssuranoCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("schwarzer")) then cost = sptsschwartzerCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("feltzer")) then cost = sptsfeltzerCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("elegy2")) then cost = sptselegyrh8Cost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("khamelion")) then cost = sptskhamelionCost
	end
	
	if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("kuruma")) then CarName = sptskurumaCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("sentinel")) then CarName = sptssentinelxsCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("sentinel2")) then CarName = sptssentinelconverCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("oracle")) then CarName = sptsoracleCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("oracle2")) then CarName = sptsoraclexsCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("fusilade")) then CarName = sptsfusiladeCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("comet2")) then CarName = sptscometCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("ninef2")) then CarName = spts9fcabrioCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("ninef")) then CarName = spts9fCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("penumbra")) then CarName = sptspenumbraCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("furore")) then CarName = sptsfuroregtCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("coquette")) then CarName = sptscoquetteCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("carbonizzare")) then CarName = sptscarbonizzareCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("jester")) then CarName = sptsjesterCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("rapidgt")) then CarName = sptsrapidgtCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("buffalo")) then CarName = sptsbuffaloCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("banshee")) then CarName = sptsbansheeCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("surano")) then CarName = sptssuranoCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("schwarzer")) then CarName = sptsschwartzerCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("feltzer")) then CarName = sptsfeltzerCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("elegy2")) then CarName = sptselegyrh8CarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("khamelion")) then CarName = sptskhamelionCarName
	end
	
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(vehC)
		
	Pay(cost)
	buy = true
	notify("Thank you, Your " .. CarName .. " is already delivered. Stay safe!")
		
elseif(TIME.GET_CLOCK_DAY_OF_MONTH() == timebuy) then
	notify("Wait for another shipment")
end
		wait(5)
		
		
end


------------------------------------------------------------------------------
return ArmoredPacksCbmMod

-- Credits to: Alexander Blade & headscript--