﻿-- ArmoredPacksRumMod by 2S v2.2.0

-- NOTE:
-- Please do not distribute this code without permission.
-- You can edit this file only for personal use. 
-- If this code is re-released in your mod, please add credits.
-- Thanks..

-------------------------------------------------------------------------------------------------------------------
local ArmoredPacksRumMod = {}
function ArmoredPacksRumMod.unload()	
	UI.REMOVE_BLIP(blip)
end

local Notification = {}

function Notification.unload() end
function Notification.init() end
function Notification.tick() end

function notify(msg) 
	UI._SET_NOTIFICATION_TEXT_ENTRY("STRING")
	UI._ADD_TEXT_COMPONENT_STRING(msg)
	UI._DRAW_NOTIFICATION(FALSE, FALSE)
end

--DISPLAY BLIP
local blip = UI.ADD_BLIP_FOR_COORD(-493.733,-1763.057,18.785)
		UI.SET_BLIP_COLOUR(blip, 1)
		UI.SET_BLIP_SPRITE(blip, 426)
		UI.SET_BLIP_NAME_FROM_TEXT_FILE(blip, "Russian Mafia Dealer")
		UI.SET_BLIP_SCALE(blip, 1)
		UI.SET_BLIP_AS_SHORT_RANGE(blip, true)

-------------MENU KEYS----------------
--NUMPAD
local openMenukey = Keys.E
local upKey = Keys.NumPad8
local downKey = Keys.NumPad2
local selectKey = Keys.NumPad5
local cancelKey = Keys.NumPad0

--ARROW KEYS
local arrowupKey = Keys.Up
local arrowdownKey = Keys.Down
local arrowselectKey = Keys.Return
local arrowcancelKey = Keys.Back

-------------------------------------------------------------------------------------------------------------------
--DO NOT EDIT BEYOND THIS POINT------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------

function mainRumInit()
	APRumGUI = APRumGUIinit()

	--MENU
	APRumGUI.mainMenu("main", "", "RUSSIAN MAFIA - ARMORED CAR", 0.17, 0.1, 0.234, 0.0522, 0.003, 0.35, 2)
	APRumGUI.addButton("main", "Armd. Stockade $101000", spawnRussianVehicle, "stockade", false, 0.35, 0)
	APRumGUI.addButton("main", "Armd. Duke O'Death $286000", spawnRussianVehicle,"dukes2", false, 0.35, 0)
	APRumGUI.addButton("main", "Armd. Kuruma $540000", spawnRussianVehicle,"kuruma2", false, 0.35, 0)
	APRumGUI.addButton("main", "Armd. Insurgent $750000", spawnRussianVehicle,"insurgent2", false, 0.35, 0)
	APRumGUI.addButton("main", "NEXT >", APRumGUI.setActiveMenu, "menu2", false, 0.35, 1)
	
	APRumGUI.mainMenu("menu2", "main", "RUSSIAN MAFIA - ARMORED CAR AND SUIT", 0.17, 0.1, 0.234, 0.0522, 0.003, 0.35, 2)
	APRumGUI.addButton("menu2", "Armd. Insurgent Weaponized $810000", spawnRussianVehicle,"insurgent", false, 0.35, 0)
	APRumGUI.addButton("menu2", "Armd. Riot $169000", spawnRussianVehicle,"riot", false, 0.35, 0)
	APRumGUI.addButton("menu2", "Armd. Mesa $187000", spawnRussianVehicle,"mesa3", false, 0.35, 0)
	APRumGUI.addButton("menu2", "Armd. Guardian $355500", spawnRussianVehicle,"guardian", false, 0.35, 0)
	APRumGUI.addButton("menu2", "Armd. Technical Weaponized $434000", spawnRussianVehicle,"technical", false, 0.35, 0)
	APRumGUI.addButton("menu2", "Advanced Bomb Suit (ABS) $170000", AdvancedBombSuit,"", false, 0.35, 0)
	APRumGUI.addButton("menu2", "PREV <", APRumGUI.setActiveMenu, "main", false, 0.35, 1)	
end

local ArmoredPacksRumMod = {}

function ArmoredPacksRumMod.unload()
end
function ArmoredPacksRumMod.init()
mainRumInit()

	--NUMPAD
	local E = openMenukey
	local numpad8 = upKey
	local numpad2 = downKey
	local numpad5 = selectKey
	local numpad0 = cancelKey
	
	--ARROW KEYS
	local keyup = arrowupKey
	local keydown = arrowdownKey
	local keyenter = arrowselectKey
	local keybackspace = arrowcancelKey

	APRumGUI.updateSelection = {["menuOpen"] = {["keys"] = {E},["menu"] = "main"},["menuUp"] = {["keys"] = {numpad8,keyup}}, 
		["menuDown"] = {["keys"] = {numpad2,keydown}},["menuCancel"] = {["keys"] = {numpad0,keybackspace}},["select"] = {["keys"] = {numpad5,keyenter}}}
end
function ArmoredPacksRumMod.tick()
	

	
		APRumGUI.tick()
		
end

-------------------------------------------------------------------------------------------------------------------

function APRumGUIinit()
	APRumGUI = {}
	APRumGUI.menu = {}
	APRumGUI.buttons = {}
	APRumGUI.updateSelection = {["menuOpen"] = {["keys"] = {},["menu"] = ""},["menuUp"] = {["keys"] = {}},
		["menuDown"] = {["keys"] = {}},["menuCancel"] = {["keys"] = {}},["select"] = {["keys"] = {}}}
	APRumGUI.activeButton = 1
	APRumGUI.activeMenu = ""
	APRumGUI.IndexStatus = {["text"] = "", ["time"] = 0}

	function APRumGUI.mainMenu(menuName, prevMenu, title, xmin, ymin, xmax, ymax, Space, textScale, font)
		if(APRumGUI.menu[menuName] == nil) then
			APRumGUI.menu[menuName] = {}
			lastOffset = ymin + ymax + Space
		end

		APRumGUI.menu[menuName] = {["prevMenu"] = prevMenu,["title"] = title,["xmin"] = xmin,["ymin"] = ymin,
			["xmax"] = xmax,["ymax"] = ymax,["spacing"] = Space,["textScale"] = textScale,
			["font"] = font,["lastOffset"] = lastOffset,["numButtons"] = 0}
	end
	
	function APRumGUI.addButton(mainMenu, text, funct, args, selectable, textScale, font)
		if(APRumGUI.buttons[mainMenu] == nil or APRumGUI.buttons[mainMenu]["settings"] == nil) then
			APRumGUI.buttons[mainMenu] = {["settings"] = {}}
		end

		local currButtonNum = #APRumGUI.buttons[mainMenu].settings + 1
		APRumGUI.menu[mainMenu].numButtons = currButtonNum

		if(selectable) then
			selectableOn = false
		else
		    selectableOn = nil
		end

		APRumGUI.buttons[mainMenu].settings[currButtonNum] = {["mainMenu"] = mainMenu,["text"] = text,["funct"] = funct,
			["args"] = args,["font"] = font,["xmin"] = APRumGUI.menu[mainMenu].xmin,
			["ymin"] = APRumGUI.menu[mainMenu].lastOffset,["xmax"] = APRumGUI.menu[mainMenu].xmax,
			["ymax"] = APRumGUI.menu[mainMenu].ymax,["textScale"] = textScale,
			["selectable"] = selectable,["selectableOn"] = selectableOn}

		APRumGUI.menu[mainMenu]["lastOffset"] = (APRumGUI.menu[mainMenu].lastOffset + APRumGUI.menu[mainMenu].ymax + APRumGUI.menu[mainMenu].spacing)
	end

	function APRumGUI.setActiveMenu(menuName)
		APRumGUI.activeButton = 1
		APRumGUI.activeMenu = menuName
	end

	function APRumGUI.drawIndex()
		if(nextDrawTime == nil or prevText ~= APRumGUI.IndexStatus.text) then
			nextDrawTime = GAMEPLAY.GET_GAME_TIMER() + APRumGUI.IndexStatus.time
		end

		if(nextDrawTime > GAMEPLAY.GET_GAME_TIMER()) then
			prevText = APRumGUI.IndexStatus.text
			UI.SET_TEXT_FONT(0)
			UI.SET_TEXT_SCALE(0.0, 0.35)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_WRAP(0, 1)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(10, 10, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(APRumGUI.IndexStatus.text)
			UI._DRAW_TEXT(xmin , 0.5)
		else
			APRumGUI.IndexStatus = {["text"] = "", ["time"] = 0}
			nextDrawTime = nil
		end
	end

	function addButtonText(text, xmin, ymin, textScale, font)
		if(text ~= nil and xmin ~= nil and ymin ~= nil and textScale ~= nil and font ~= nil) then
			UI.SET_TEXT_FONT(font)
			UI.SET_TEXT_SCALE(0.0, 0.30)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(text)
			UI._DRAW_TEXT(xmin , ymin - 0.0125)
		else
			print("text: ", text, ", xmin: ", xmin, ", ymin: ", ymin, ", textScale: ", textScale, ", font: ", font)
		    APRumGUI.setActiveMenu("")
		end
	end

	function APRumGUI.drawAPRumGUI()
		if(APRumGUI.activeMenu ~= "" and APRumGUI.activeMenu ~= nil) then
			local name = APRumGUI.activeMenu

			if(APRumGUI.menu[name] ~= nil) then
				local xmin = APRumGUI.menu[name].xmin
				local ymin = APRumGUI.menu[name].ymin
				local xmax = APRumGUI.menu[name].xmax
				local ymax = APRumGUI.menu[name].ymax
				
				local text = APRumGUI.menu[name].title
				local textScale = APRumGUI.menu[name].textScale
				local font = APRumGUI.menu[name].font
				local colors = {["r"] = 0, ["g"] = 0, ["b"] = 0, ["o"] = 255}

				addButtonText(text, xmin, ymin, textScale, font)
				GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);

				if(APRumGUI.buttons[name] ~= nil) then
					for i, v in pairs(APRumGUI.buttons[name].settings) do
						local buttonSettings = APRumGUI.buttons[name].settings[i]
						local xmin = buttonSettings.xmin
						local ymin = buttonSettings.ymin
						local xmax = buttonSettings.xmax
						local ymax = buttonSettings.ymax
						
						local font = buttonSettings.font
						local text = buttonSettings.text
						local textScale = buttonSettings.textScale
						local colors = {["r"] = 25, ["g"] = 50, ["b"] = 80, ["o"] = 180}

						if(buttonSettings.selectableOn == true) then
							text = buttonSettings.text .. " [ON]"
						elseif(buttonSettings.selectableOn == false) then
							text = buttonSettings.text .. " [OFF]"
						end
						
						if(i == APRumGUI.activeButton) then
							colors = {["r"] = 140, ["g"] = 150, ["b"] = 200, ["o"] = 200}
						end

						addButtonText(text, xmin, ymin, textScale, font)
						GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);
					end
				else
					APRumGUI.setActiveMenu("")
				end
			else
				APRumGUI.setActiveMenu("")
			end
		end
	end

	function APRumGUI.updateIndexStatus(text, time)
		APRumGUI.IndexStatus = {["text"] = text, ["time"] = time}
	end

	function APRumGUI.isButtonselectableOn()
		local activeButton = APRumGUI.buttons[APRumGUI.activeMenu].settings[APRumGUI.activeButton]
		if(activeButton.selectable) then
			return activeButton.selectableOn
		elseif(activeButton.selectable == flse) then
			print("Button \"", APRumGUI.buttons[APRumGUI.activeMenu].settings[APRumGUI.activeButton].text, "\"")
		    return nil
		end
	end

	function APRumGUI.toggleButtonState()
		local activeButton = APRumGUI.buttons[APRumGUI.activeMenu].settings[APRumGUI.activeButton]
		
		if(APRumGUI.isButtonselectableOn() and activeButton.selectable) then
			activeButton.selectableOn = false
		elseif(APRumGUI.isButtonselectableOn() == false and activeButton.selectable) then
			activeButton.selectableOn = true
			print("toggled on")
		end
	end

	function APRumGUI.tick()
		APRumGUI.drawIndex()
		APRumGUI.drawAPRumGUI()

		for i, key in pairs(APRumGUI.updateSelection.menuOpen.keys) do
			if(get_key_pressed(key)) then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					if(APRumGUI.activeMenu == APRumGUI.updateSelection.menuOpen.menu) then
						APRumGUI.setActiveMenu(APRumGUI.menu[APRumGUI.activeMenu].prevMenu)
					else
					    APRumGUI.setActiveMenu(APRumGUI.updateSelection.menuOpen.menu)
					    APRumGUI.currentSelection = 1
					end
				end
			
			end
		end

		for k, key in pairs(APRumGUI.updateSelection.menuUp.keys) do
			if(get_key_pressed(key) and APRumGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APRumGUI.activeButton = APRumGUI.activeButton - 1

					if(APRumGUI.activeButton <= 0) then
						APRumGUI.activeButton = APRumGUI.menu[APRumGUI.activeMenu].numButtons
					end
				end
			
			end
		end

		for k, key in pairs(APRumGUI.updateSelection.menuDown.keys) do
			if(get_key_pressed(key) and APRumGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APRumGUI.activeButton = APRumGUI.activeButton + 1
					if(APRumGUI.activeButton > APRumGUI.menu[APRumGUI.activeMenu].numButtons) then
						APRumGUI.activeButton = 1
					end
				end
			
			end
		end

		for k, key in pairs(APRumGUI.updateSelection.select.keys) do
			if(get_key_pressed(key) and APRumGUI.activeMenu ~= "") then
			   if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
				local currButton = APRumGUI.buttons[APRumGUI.activeMenu].settings[APRumGUI.activeButton]
				
				if(type(currButton.funct) == "function" and type(currButton.args) == "table") then
					APRumGUI.toggleButtonState()
					currButton.funct(currButton.args[1], currButton.args[2], currButton.args[3], currButton.args[4], currButton.args[5], currButton.args[6], currButton.args[7], currButton.args[8], currButton.args[9], currButton.args[10], currButton.args[11], currButton.args[12], currButton.args[13], currButton.args[14], currButton.args[15], currButton.args[16], currButton.args[17], currButton.args[18], currButton.args[19], currButton.args[20])

				elseif(type(currButton.funct) == "function" and type(currButton.args) == "string" or type(currButton.args) == "number"or type(currButton.args) == "boolean") then
					APRumGUI.toggleButtonState()
					currButton.funct(currButton.args)
					
				elseif(currButton.args == nil) then
					APRumGUI.toggleButtonState()
					currButton.funct()

				else
					print("function: ", currButton.funct, ", args: ", currButton.args)
				end
			   end
			
			end
		end

		for k, key in pairs(APRumGUI.updateSelection.menuCancel.keys) do
			if(get_key_pressed(key) and APRumGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APRumGUI.setActiveMenu(APRumGUI.menu[APRumGUI.activeMenu].prevMenu)
				end
			
			end
		end
	end

	return APRumGUI
end

-------------------------------------------------------------------------------------------------------------------

--PRICES
	--ARMORED
local armdStockadeCost = 101000
local armddukesCost = 286000
local armdkurumaCost = 540000
local armdinsurgetCost = 750000
local armdinsurgentwpnzCost = 810000
local armdriotCost = 169000
local armdguardianCost = 355500
local absCost = 170000

	--MILITARY
local mltrytechnicalwpnzCost = 434000

	--OFF_ROAD
local ormesamwCost = 187000

--CARNAME
	--ARMORED
local armdStockadeCarName = "Stockade"
local armddukesCarName = "Duke O'Death"
local armdkurumaCarName = "Armored Kuruma"
local armdinsurgetCarName = "Insurgent"
local armdinsurgentwpnzCarName = "Insurgent Weaponized"
local armdriotCarName = "Riot"
local armdguardianCarName = "Armored Guardian"

	--MILITARY
local mltrytechnicalwpnzCarName = "Armored Technical"

	--OFF_ROAD
local ormesamwCarName = "Armored Mesa"

local showMenu = false

local buy = false
local timebuy = 99999
local CarName = "not set"

local spawned = false
local bPed
local dubstaR

local cost = 0
local hasArmor = {}
hasArmor[0] = false
hasArmor[1] = false
hasArmor[2] = false
local ArmorEquipped = false

-------------------------------------------------------------------------------------------------------------------

--Pay System
function Pay(pay)

local playerPed = PLAYER.PLAYER_PED_ID()

		if (PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_zero"))) then
			model = 0
		elseif (PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_one"))) then                                
			model = 1                                         
		elseif (PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_two"))) then
			model = 2
		end
	
		local statname = "SP"..model.."_TOTAL_CASH"
		local hash = GAMEPLAY.GET_HASH_KEY(statname)
		local bool, val = STATS.STAT_GET_INT(hash, 0, -1)

		STATS.STAT_SET_INT(hash, val - pay, true)

end

------------------------------------------------------------------------------

function ArmoredPacksRumMod.tick()

	local playerPed = PLAYER.PLAYER_PED_ID()
	local playerPedinV = PED.IS_PED_IN_ANY_VEHICLE(playerPed, false)
	local playerCoords = ENTITY.GET_ENTITY_COORDS(playerPed, true)
	local buyPoint = GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS(playerCoords.x, playerCoords.y, playerCoords.z, -493.733, -1763.057, 18.785, true)
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local location = ENTITY.GET_ENTITY_COORDS( playerPed, nil )
	
	--SHOW MENU FLAG
	if (not playerPedinV and buyPoint < 2 and not showMenu) then
		if PED._IS_PED_DEAD(bPed, true) then
			notify("The Dealer is not here, come back later.")
		else
			notify("Hi, what do you want?             PRESS E")
		
			if get_key_pressed(Keys.E) then
				showMenu = true
			end
		end
	end
	
	--SHOW MENU
	if(showMenu == true) then
		APRumGUI.tick()
	end

	--CLOSE MENU
	if(buyPoint > 2 and get_key_pressed(Keys.E)) then
		showMenu = false
	elseif(buyPoint > 10 and showMenu == true) then
		showMenu = false
	end

	--PLAYER & DEALER DISTANCE
	if(buyPoint > 5 and showMenu == true) then
		notify("PRESS E to close the Menu")
	end

	--SPAWN/DESPAWN DEALER
	if(spawned == false and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,-493.733, -1763.057, 18.785, false ) < 150 ) then
		spawnRussianDealer()
		spawned = true
	elseif(spawned == true and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,-493.733, -1763.057, 18.785, false ) > 150 ) then
		PED.DELETE_PED(bPed)
		PED.DELETE_PED(gPed[0])
		PED.DELETE_PED(gPed[1])
		PED.DELETE_PED(gPed[2])
		PED.DELETE_PED(gPed[3])
		PED.DELETE_PED(gPed[4])
		PED.DELETE_PED(gPed[5])
		PED.DELETE_PED(gPed[6])
		PED.DELETE_PED(gPed[7])
		PED.DELETE_PED(gPed[8])
		PED.DELETE_PED(gPed[9])
		PED.DELETE_PED(gPed[10])
		PED.DELETE_PED(gPed[11])
		PED.DELETE_PED(gPed[12])
		PED.DELETE_PED(gPed[13])
		PED.DELETE_PED(gPed[14])
		PED.DELETE_PED(gPed[15])
		PED.DELETE_PED(gPed[16])
		PED.DELETE_PED(gPed[17])
		PED.DELETE_PED(gPed[18])
		PED.DELETE_PED(gPed[19])
		PED.DELETE_PED(gPed[20])
		bossMoney = 0
		spawned = false
	end
		
	--EQUIP ABS
	if(playerPedinV and get_key_pressed(Keys.T) and ArmorEquipped == false) then
		equipArmor()
		print("Equip")
	elseif(playerPedinV and get_key_pressed(Keys.G) and ArmorEquipped == true) then
		removeArmor()
		print("Remove")
	end
	
	--ARMOR
	print(PED.GET_PED_ARMOUR(playerPed))
	if(PED.GET_PED_ARMOUR(playerPed)  == 1) then
		removeArmor()
	end
	
end

--ABS
function setArmor(i)
	if(i == true)then
		local playerPed = PLAYER.PLAYER_PED_ID()
		PED.ADD_ARMOUR_TO_PED(playerPed,10000)
		PED.SET_AI_WEAPON_DAMAGE_MODIFIER(0.001)
	elseif(i == false)then
		PED.RESET_AI_WEAPON_DAMAGE_MODIFIER()
	end
end

function equipArmor()

	local playerPed = PLAYER.PLAYER_PED_ID()
		if (hasArmor[0] == true and PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_zero"))) then
			PED.SET_PED_COMPONENT_VARIATION(playerPed,6,5 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,8,5 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,3,5 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,4,5 , 0, 0)
			ArmorEquipped = true
			print("one")
			setArmor(true)
		elseif (hasArmor[1] == true and PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_one"))) then                                
			PED.SET_PED_COMPONENT_VARIATION(playerPed,8,3 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,9,3 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,4,4 , 0, 0)
			ArmorEquipped = true
			print("two")
			setArmor(true)
		elseif (hasArmor[2] == true and PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_two"))) then
			PED.SET_PED_COMPONENT_VARIATION(playerPed,6,2 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,8,2 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,3,2 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,4,2 , 0, 0)
			ArmorEquipped = true
			print("three")
			setArmor(true)
		end	
		
		
end

function removeArmor()

	local playerPed = PLAYER.PLAYER_PED_ID()
		if (hasArmor[0] == true and PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_zero"))) then
			PED.SET_PED_COMPONENT_VARIATION(playerPed,6,0 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,8,0 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,3,0 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,4,0 , 0, 0)
			ArmorEquipped = false
			hasArmor[0] = false
			setArmor(false)
			ArmorEquipped = false
		elseif (hasArmor[1] == true and PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_one"))) then                                
			PED.SET_PED_COMPONENT_VARIATION(playerPed,8,0 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,9,0 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,4,0 , 0, 0)
			ArmorEquipped = false
			hasArmor[1] = false
			setArmor(false)
			ArmorEquipped = false
		elseif (hasArmor[2] == true and PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_two"))) then
			PED.SET_PED_COMPONENT_VARIATION(playerPed,6,0 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,8,0 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,3,0 , 0, 0)
			PED.SET_PED_COMPONENT_VARIATION(playerPed,4,0 , 0, 0)
			ArmorEquipped = false
			hasArmor[2] = false
			setArmor(false)
			ArmorEquipped = false
		end	
		
		
end


function AdvancedBombSuit() 
	local playerPed = PLAYER.PLAYER_PED_ID()

		if (PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_zero"))) then
			hasArmor[0] = true
		elseif (PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_one"))) then                                
			hasArmor[1] = true
		elseif (PED.IS_PED_MODEL(playerPed, GAMEPLAY.GET_HASH_KEY("player_two"))) then
			hasArmor[2] = true
		end
	notify("PRESS T to EQUIP and PRESS G to REMOVE the ABS")	
	notify("You can only Equip and Remove ABS while inside the vehicle")
		
	Pay(absCost)
end

--DEALER SPAWN
function spawnRussianDealer()

	local weapon = GAMEPLAY.GET_HASH_KEY("WEAPON_ADVANCEDRIFLE")
	local weapon2 = GAMEPLAY.GET_HASH_KEY("WEAPON_MG")
	local weapon3 = GAMEPLAY.GET_HASH_KEY("WEAPON_SNIPERRIFLE")
	local weapon4 = GAMEPLAY.GET_HASH_KEY("WEAPON_RPG")

	---BOSS---
	local boss = GAMEPLAY.GET_HASH_KEY("G_M_M_ArmBoss_01")
	STREAMING.REQUEST_MODEL(boss)
	while(not STREAMING.HAS_MODEL_LOADED(boss)) do
		wait(50)
	end
	bPed = PED.CREATE_PED(1, boss, -493.733, -1763.057, 18.785, 351, true, true)
	PED.SET_PED_CAN_SWITCH_WEAPON(bPed, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(bPed, weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(bPed, GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(bPed, false)
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(boss)
	bossMoney = (GAMEPLAY.GET_RANDOM_INT_IN_RANGE(8000,100000))
	PED.SET_PED_MONEY(bPed, bossMoney)

	---GOON---
	goon = GAMEPLAY.GET_HASH_KEY("G_M_M_ArmGoon_01")

	STREAMING.REQUEST_MODEL(goon)
	
	while(not STREAMING.HAS_MODEL_LOADED(goon)) do
		wait(50)
	end
	
	gPed = {}
	
	gPed[0] = PED.CREATE_PED(1, goon, -495.432, -1758.152, 18.576, 3, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[0], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[0], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[0], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[0], false)
	
	gPed[1] = PED.CREATE_PED(1, goon, -487.713, -1759.355, 18.371, 4, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[1], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[1], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[1], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[1], false)
	
	gPed[2] = PED.CREATE_PED(1, goon, -497.020, -1745.498, 18.968, 51, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[2], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[2], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[2], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[2], false)
	
	gPed[3] = PED.CREATE_PED(1, goon, -487.504, -1745.530, 19.045, 309, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[3], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[3], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[3], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[3], false)

	gPed[4] = PED.CREATE_PED(1, goon, -484.429, -1765.651, 21.761, 277, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[4], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[4], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[4], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[4], false)

	gPed[5] = PED.CREATE_PED(1, goon, -512.697, -1748.559, 19.243, 242, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[5], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[5], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[5], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[5], false)

	gPed[6] = PED.CREATE_PED(1, goon, -466.712, -1736.956, 19.805, 104, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[6], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[6], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[6], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[6], false)

	gPed[7] = PED.CREATE_PED(1, goon, -480.397, -1740.435, 18.645, 356, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[7], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[7], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[7], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[7], false)
	
	gPed[8] = PED.CREATE_PED(1, goon, -480.743, -1750.835, 21.232, 20, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[8], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[8], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[8], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[8], false)

	gPed[9] = PED.CREATE_PED(1, goon, -448.499, -1741.607, 27.057, 26, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[9], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[9], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[9], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[9], false)

	gPed[10] = PED.CREATE_PED(1, goon, -459.557, -1743.870, 27.057, 13, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[10], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[10], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[10], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[10], false)

	gPed[11] = PED.CREATE_PED(1, goon, -470.986, -1746.523, 27.057, 26, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[11], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[11], weapon4, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[11], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[11], false)

	gPed[12] = PED.CREATE_PED(1, goon, -448.831, -1730.337, 28.388, 35, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[12], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[12], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[12], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[12], false)

	gPed[13] = PED.CREATE_PED(1, goon, -489.612, -1746.119, 19.045, 355, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[13], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[13], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[13], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[13], false)

	gPed[14] = PED.CREATE_PED(1, goon, -493.985, -1746.765, 18.968, 327, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[14], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[14], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[14], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[14], false)

	gPed[15] = PED.CREATE_PED(1, goon, -486.425, -1728.311, 25.036, 195, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[15], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[15], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[15], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[15], false)

	gPed[16] = PED.CREATE_PED(1, goon, -483.976, -1715.001, 28.288, 286, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[16], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[16], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[16], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[16], false)

	gPed[17] = PED.CREATE_PED(1, goon, -516.233, -1759.762, 27.978, 315, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[17], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[17], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[17], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[17], false)

	gPed[18] = PED.CREATE_PED(1, goon, -475.438, -1757.870, 23.244, 80, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[18], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[18], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[18], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[18], false)

	gPed[19] = PED.CREATE_PED(1, goon, -476.388, -1754.719, 23.244, 31, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[19], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[19], weapon4, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[19], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[19], false)

	gPed[20] = PED.CREATE_PED(1, goon, -520.594, -1731.477, 21.901, 242, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gPed[20], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gPed[20], weapon4, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gPed[20], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gPed[20], false)

	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(goon)
	
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY("dubsta"))
	
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY("dubsta"))) do
		wait(50)
	end
	
	dubstaR = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY("dubsta"), -504.719, -1726.340, 19.449, 191, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(dubstaR)
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(dubstaR, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(dubstaR, false)
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(dubstaR)
	
end

--VEHICLE SPAWN
function spawnRussianVehicle(modelString) 

	print (timebuy)
	print(TIME.GET_CLOCK_DAY_OF_MONTH())
	print(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)

if(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
	
	local cost
		
	timebuy = TIME.GET_CLOCK_DAY_OF_MONTH()
		
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY(modelString))
		
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY(modelString))) do
		wait(50)
	end
		
	local vehR = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY(modelString), -510.352, -1735.238, 19.098, 315, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(vehR)
		
			VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(vehR, false) 		
			VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(vehR, true)
			VEHICLE.SET_VEHICLE_IS_STOLEN(vehR, false)
			VEHICLE.SET_VEHICLE_IS_WANTED(vehR, false)
			VEHICLE.SET_VEHICLE_MOD_KIT(vehR, 0)
			VEHICLE.SET_VEHICLE_MOD(vehR, 11, 3, true) 
			VEHICLE.SET_VEHICLE_MOD(vehR, 12, 2, true) 
			VEHICLE.SET_VEHICLE_MOD(vehR, 13, 2, true)
			VEHICLE.SET_VEHICLE_MOD(vehR, 15, 3, true) 
			VEHICLE.SET_VEHICLE_MOD(vehR, 16, 4, true)
			VEHICLE.SET_VEHICLE_WHEEL_TYPE(vehR, 120)
			VEHICLE.SET_VEHICLE_WINDOW_TINT(vehR, 1) 
			VEHICLE.SET_CAN_RESPRAY_VEHICLE(vehR, true) 
			VEHICLE.SET_VEHICLE_TYRES_CAN_BURST(vehR, false) 
			VEHICLE.SET_VEHICLE_WHEELS_CAN_BREAK(vehR, false) 			
			VEHICLE.SET_VEHICLE_CUSTOM_PRIMARY_COLOUR(vehR, 0, 0, 0)
			VEHICLE.SET_VEHICLE_CUSTOM_SECONDARY_COLOUR(vehR, 0, 0, 0)
			VEHICLE.SET_VEHICLE_NUMBER_PLATE_TEXT(vehR, "4RM0R3D")
		
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(modelString))

	if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("stockade")) then cost = armdStockadeCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("dukes2")) then cost = armddukesCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("kuruma2")) then cost = armdkurumaCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("insurgent2")) then cost = armdinsurgetCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("insurgent")) then cost = armdinsurgentwpnzCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("riot")) then cost = armdriotCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("guardian")) then cost = armdguardianCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("technical")) then cost = mltrytechnicalwpnzCost
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mesa3")) then cost = ormesamwCost
	end
		
	if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("stockade")) then CarName = armdStockadeCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("dukes2")) then CarName = armddukesCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("kuruma2")) then CarName = armdkurumaCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("insurgent2")) then CarName = armdinsurgetCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("insurgent")) then CarName = armdinsurgentwpnzCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("riot")) then CarName = armdriotCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("guardian")) then CarName = armdguardianCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("technical")) then CarName = mltrytechnicalwpnzCarName
	elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mesa3")) then CarName = ormesamwCarName
	end

	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(vehR)
		
	Pay(cost)
	buy = true
	notify("Your " .. CarName .. " is already delivered. Thank you!")
		
elseif(TIME.GET_CLOCK_DAY_OF_MONTH() == timebuy) then
	notify("Wait for another shipment")
end
		wait(5)
				
end


------------------------------------------------------------------------------
return ArmoredPacksRumMod

-- Credits to: Alexander Blade & headscript--