VERSION 5.00
Begin VB.UserControl bkDLControl 
   BorderStyle     =   1  'Fixed Single
   CanGetFocus     =   0   'False
   ClientHeight    =   300
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4650
   ScaleHeight     =   300
   ScaleWidth      =   4650
   ToolboxBitmap   =   "bkDLControl.ctx":0000
End
Attribute VB_Name = "bkDLControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False



Option Explicit

Private m_sFileURL As String, m_sSaveFilePath As String, blnDownloading As Boolean, sngPct As Single, _
    m_blnFailRedirect As Boolean, m_sSaveFileName As String, m_blnShowProgress As Boolean, _
    blnSuccess As Boolean, m_lFileSize As Long, m_sConn As String, m_lBytesRead As Long, _
    m_sCache As String, m_sRedirect As String, m_sMIMEType As String, m_blnRenameRedirect As Boolean
    

Event Click()
Event DblClick()
Event MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event DLProgress(Percent As Single, BytesRead As Long, TotalBytes As Long)
Event DLCanceled()
Event DLError(E As bkDLError, Error As String)
Event DLComplete(Bytes As Long)
Event DLConnected(ConnAddr As String)
Event DLRedirect(ConnAddr As String)
Event DLCacheFile(FileName As String)
Event DLMIMEType(MIMEType As String)
Event DLFileSize(Bytes As Long)
Event DLBeginDownload()

Public Enum bkDLError
    bkDLEUnavailable = 1
    bkDLERedirect = 2
    bkDLEZeroLength = 3
    bkDLESaveError = 4
    bkDLEUnknown = 99
End Enum

Public Property Get BackColor() As OLE_COLOR
Attribute BackColor.VB_Description = "Returns/sets the background color used to display text and graphics in an object."
Attribute BackColor.VB_ProcData.VB_Invoke_Property = ";Appearance"
Attribute BackColor.VB_UserMemId = -501
    BackColor = UserControl.BackColor
End Property

Public Property Let BackColor(ByVal New_BackColor As OLE_COLOR)
    UserControl.BackColor() = New_BackColor
    PropertyChanged "BackColor"
End Property

Public Property Get ForeColor() As OLE_COLOR
Attribute ForeColor.VB_Description = "Returns/sets the foreground color used to display text and graphics in an object."
Attribute ForeColor.VB_ProcData.VB_Invoke_Property = ";Appearance"
    ForeColor = UserControl.ForeColor
End Property

Public Property Let ForeColor(ByVal New_ForeColor As OLE_COLOR)
    UserControl.ForeColor() = New_ForeColor
    PropertyChanged "ForeColor"
End Property

Public Property Get Enabled() As Boolean
Attribute Enabled.VB_Description = "Returns/sets a value that determines whether an object can respond to user-generated events."
Attribute Enabled.VB_UserMemId = -514
    Enabled = UserControl.Enabled
End Property

Public Property Let Enabled(ByVal New_Enabled As Boolean)
    UserControl.Enabled() = New_Enabled
    PropertyChanged "Enabled"
End Property

Public Property Get Font() As Font
Attribute Font.VB_Description = "Returns a Font object."
Attribute Font.VB_ProcData.VB_Invoke_Property = ";Font"
Attribute Font.VB_UserMemId = -512
    Set Font = UserControl.Font
End Property

Public Property Set Font(ByVal New_Font As Font)
    Set UserControl.Font = New_Font
    PropertyChanged "Font"
End Property


Public Property Get BorderStyle() As Integer
Attribute BorderStyle.VB_Description = "Returns/sets the border style for an object."
Attribute BorderStyle.VB_ProcData.VB_Invoke_Property = ";Appearance"
Attribute BorderStyle.VB_UserMemId = -504
    BorderStyle = UserControl.BorderStyle
End Property

Public Property Let BorderStyle(ByVal New_BorderStyle As Integer)
    UserControl.BorderStyle() = New_BorderStyle
    PropertyChanged "BorderStyle"
End Property

Public Property Get BytesRead() As Long
Attribute BytesRead.VB_MemberFlags = "400"
    BytesRead = m_lBytesRead
End Property


Public Property Get CacheFile() As String
Attribute CacheFile.VB_MemberFlags = "400"
    CacheFile = m_sCache
End Property
    

Public Property Get ConnectionAddress() As String
Attribute ConnectionAddress.VB_MemberFlags = "400"
    ConnectionAddress = m_sConn
End Property


Public Property Get MIMEType() As String
Attribute MIMEType.VB_MemberFlags = "400"
    MIMEType = m_sMIMEType
End Property

Public Property Get RedirectFile() As String
Attribute RedirectFile.VB_MemberFlags = "400"
    RedirectFile = m_sRedirect
End Property


Public Sub Refresh()
Attribute Refresh.VB_Description = "Forces a complete repaint of a object."
Attribute Refresh.VB_UserMemId = -550
    UserControl.Refresh
End Sub


Private Sub UserControl_AsyncReadComplete(AsyncProp As AsyncProperty)
    On Error GoTo CompleteError
    Dim bFile() As Byte, FN As Long
 
    With AsyncProp
        If .BytesRead <> 0 Then
           
            FN = FreeFile
            bFile = .Value
            If m_blnRenameRedirect And m_sRedirect <> vbNullString Then
                SetRedirectName
            End If
            Open m_sSaveFileName For Binary Access Write As #FN
            Put #FN, , bFile
            Close #FN
            blnSuccess = True
            RaiseEvent DLComplete(.BytesRead)
            Kill m_sCache
            blnDownloading = False
        Else
          
            SendError bkDLEZeroLength, "Zero bytes retrieved"
        End If
    End With
    Exit Sub
CompleteError:
    Debug.Print Err.Number
    SendError bkDLESaveError, Err.Description & " [" & m_sSaveFileName & "]"
End Sub

Private Sub UserControl_AsyncReadProgress(AsyncProp As AsyncProperty)

    With AsyncProp
        Select Case .StatusCode
            Case vbAsyncStatusCodeConnecting
                m_sConn = .Status
                RaiseEvent DLConnected(.Status)
            Case vbAsyncStatusCodeRedirecting
                m_sRedirect = .Status
                If m_blnFailRedirect Then
                    UserControl.CancelAsyncRead m_sSaveFileName
                    SendError bkDLERedirect, "Redirected to " & .Status
 
                Else
                    RaiseEvent DLRedirect(.Status)
                End If
            Case vbAsyncStatusCodeDownloadingData, vbAsyncStatusCodeEndDownloadData
                If .BytesMax > 0 Then
                    sngPct = CSng(.BytesRead / .BytesMax)
                Else
                    sngPct = 0!
                End If
                m_lBytesRead = .BytesRead
      
                RaiseEvent DLProgress(sngPct, .BytesRead, .BytesMax)
            Case vbAsyncStatusCodeMIMETypeAvailable
                
                m_sMIMEType = .Status
                RaiseEvent DLMIMEType(.Status)
            Case vbAsyncStatusCodeCacheFileNameAvailable

                m_sCache = .Status
                RaiseEvent DLCacheFile(.Status)
            Case vbAsyncStatusCodeBeginDownloadData

                m_lFileSize = .BytesMax
                RaiseEvent DLFileSize(.BytesMax)
                RaiseEvent DLBeginDownload
            Case vbAsyncStatusCodeError
                Debug.Print "ERROR: ", .Status, Now
                SendError bkDLEUnknown, CStr(.Value)
        End Select
    End With
    UserControl.Refresh
End Sub


Private Sub UserControl_Click()
    RaiseEvent Click
End Sub

Private Sub UserControl_DblClick()
    RaiseEvent DblClick
End Sub

Private Sub UserControl_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseDown(Button, Shift, X, Y)
End Sub

Private Sub UserControl_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseMove(Button, Shift, X, Y)
End Sub

Private Sub UserControl_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseUp(Button, Shift, X, Y)
End Sub


Public Property Get FileSize()
Attribute FileSize.VB_MemberFlags = "400"
    FileSize = m_lFileSize
End Property


Public Property Get FileURL() As String
Attribute FileURL.VB_Description = "URL of file to be Downloaded"
Attribute FileURL.VB_ProcData.VB_Invoke_Property = ";Misc"
Attribute FileURL.VB_MemberFlags = "400"
    FileURL = m_sFileURL
End Property

Public Property Let FileURL(ByVal New_FileURL As String)
    m_sFileURL = New_FileURL

    SetFileName
    PropertyChanged "FileURL"
End Property


Public Property Get SaveFileName() As String
Attribute SaveFileName.VB_ProcData.VB_Invoke_Property = ";Misc"
Attribute SaveFileName.VB_MemberFlags = "400"
    SaveFileName = m_sSaveFileName
End Property

Public Property Get SaveFilePath() As String
Attribute SaveFilePath.VB_Description = "Path to Save downloaded file to"
Attribute SaveFilePath.VB_ProcData.VB_Invoke_Property = ";Misc"
    SaveFilePath = m_sSaveFilePath
End Property

Public Property Let SaveFilePath(ByVal New_SaveFilePath As String)
    m_sSaveFilePath = New_SaveFilePath
    SetFileName
    PropertyChanged "SaveFilePath"
End Property

Private Sub UserControl_InitProperties()
    Set Font = Ambient.Font
    m_sFileURL = vbNullString
    m_sSaveFilePath = vbNullString
    m_blnFailRedirect = True
    m_blnRenameRedirect = True
    InitDL
    m_blnShowProgress = True
End Sub


Private Sub UserControl_Paint()
    If m_blnShowProgress And sngPct > 0! Then
        UserControl.Line (0, 0)-(UserControl.Width * sngPct, UserControl.Height), UserControl.ForeColor, BF
    End If
End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    UserControl.BackColor = PropBag.ReadProperty("BackColor", &H8000000F)
    UserControl.ForeColor = PropBag.ReadProperty("ForeColor", &H80000012)
    UserControl.Enabled = PropBag.ReadProperty("Enabled", True)
    Set Font = PropBag.ReadProperty("Font", Ambient.Font)
    UserControl.BorderStyle = PropBag.ReadProperty("BorderStyle", 1)
    m_sFileURL = PropBag.ReadProperty("FileURL", vbNullString)
    m_sSaveFilePath = PropBag.ReadProperty("SaveFilePath", vbNullString)
    m_blnFailRedirect = PropBag.ReadProperty("FailOnRedirect", True)
    m_blnRenameRedirect = PropBag.ReadProperty("RenameOnRedirect", True)
    m_blnShowProgress = PropBag.ReadProperty("ShowProgress", True)
End Sub

Private Sub UserControl_Terminate()
    If blnDownloading Then
        On Error Resume Next
        UserControl.CancelAsyncRead m_sSaveFileName
    End If
End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    PropBag.WriteProperty "BackColor", UserControl.BackColor, &H8000000F
    PropBag.WriteProperty "ForeColor", UserControl.ForeColor, &H80000012
    PropBag.WriteProperty "Enabled", UserControl.Enabled, True
    PropBag.WriteProperty "Font", Font, Ambient.Font
    PropBag.WriteProperty "BorderStyle", UserControl.BorderStyle, 1
    PropBag.WriteProperty "FileURL", m_sFileURL, vbNullString
    PropBag.WriteProperty "SaveFilePath", m_sSaveFilePath, vbNullString
    PropBag.WriteProperty "FailOnRedirect", m_blnFailRedirect, True
    PropBag.WriteProperty "RenameOnRedirect", m_blnRenameRedirect, True
    PropBag.WriteProperty "ShowProgress", m_blnShowProgress, True
End Sub

Public Function BeginDownload(Optional Wait As Boolean = False) As Boolean
    If blnDownloading Then Exit Function

    If m_sFileURL = vbNullString Or m_sSaveFilePath = vbNullString Then Exit Function
    On Error GoTo BeginDownloadError

    UserControl.AsyncRead m_sFileURL, vbAsyncTypeByteArray, m_sSaveFileName, vbAsyncReadForceUpdate
    blnDownloading = True
  
    InitDL
    If Wait Then

        DoWait
        BeginDownload = blnSuccess
    Else
        BeginDownload = True
    End If
    Exit Function
BeginDownloadError:
    SendError bkDLEUnavailable, Err.Description
    MsgBox Err & "Error: " & vbCrLf & Err.Description, vbCritical, "bkDLControl Internal Error: " & CStr(Err.Number)
End Function

Private Sub InitDL()
    m_lFileSize = 0&
    m_lBytesRead = 0&
    m_sConn = vbNullString
    m_sCache = vbNullString
    m_sRedirect = vbNullString
    m_sMIMEType = vbNullString
    blnSuccess = False
End Sub

Private Sub DoWait()
    Do
        DoEvents
    Loop Until Not blnDownloading
End Sub

Public Sub CancelDownload()
    If Not blnDownloading Then Exit Sub

    On Error Resume Next
    UserControl.CancelAsyncRead m_sSaveFileName
    On Error GoTo 0
    sngPct = 0!
    Refresh
    blnDownloading = False
    RaiseEvent DLCanceled
End Sub


Public Property Get FailOnRedirect() As Boolean
    FailOnRedirect = m_blnFailRedirect
End Property

Public Property Let FailOnRedirect(NewFail As Boolean)
    m_blnFailRedirect = NewFail
    PropertyChanged "FailOnRedirect"
End Property


Public Property Get RenameOnRedirect() As Boolean
Attribute RenameOnRedirect.VB_ProcData.VB_Invoke_Property = ";Behavior"
    RenameOnRedirect = m_blnRenameRedirect And Not m_blnFailRedirect
End Property

Public Property Let RenameOnRedirect(NewRename As Boolean)
    m_blnRenameRedirect = NewRename
    PropertyChanged "RenameOnRedirect"
End Property

Public Property Get ShowProgress() As Boolean
Attribute ShowProgress.VB_ProcData.VB_Invoke_Property = ";Behavior"
    ShowProgress = m_blnShowProgress
End Property

Public Property Let ShowProgress(NewShowProgress As Boolean)
    m_blnShowProgress = NewShowProgress
    PropertyChanged "ShowProgress"
End Property


Private Function getFullPath(strPath As String, strFile As String, Optional strDelim As String = "\") As String
    If Right$(strPath, 1) = strDelim Then
        getFullPath = strPath & strFile
    Else
        getFullPath = strPath & strDelim & strFile
    End If
End Function

Private Function getFileFromPath(strPath As String, Optional strDelim As String = "\") As String
Dim iPos As Integer
    iPos = InStrRev(strPath, strDelim)
    If iPos = 0 Then
        getFileFromPath = strPath
    Else
        getFileFromPath = Mid$(strPath, iPos + 1)
    End If
End Function

Private Sub SetFileName()
    If m_sFileURL = vbNullString Or m_sSaveFilePath = vbNullString Then
        m_sSaveFileName = vbNullString
    Else
        m_sSaveFileName = getFullPath(m_sSaveFilePath, getFileFromPath(Replace$(m_sFileURL, "/", "\")))
    End If
End Sub

Private Sub SetRedirectName()
    m_sSaveFileName = getFullPath(m_sSaveFilePath, getFileFromPath(Replace$(m_sRedirect, "/", "\")))
End Sub

Private Sub SendError(E As bkDLError, strMessage As String)
    sngPct = 0!
    Refresh
    blnDownloading = False
    RaiseEvent DLError(E, strMessage)
    RaiseEvent DLComplete(0&)
End Sub
