local LD = require("design.LevelDesignLibrary")
local timers, monitors, thisObj
local completed = false
local sphereTrigger = false
local TempleMonitor, BrazierLMonitor, BrazierRMonitor, FloorMonitor, viewingTemple, viewingBrazierLeft, viewingBrazierRight, viewingFloor, viewTimer, coolDownTimer
local phase = 1
local step = 1
local stepActive = false
local coolDownActive = false
local timers_LoadLibrary = function()
  if timers == nil then
    timers = require("level.timer")
  end
end
local monitors_LoadLibrary = function()
  if monitors == nil then
    monitors = require("level.MonitorLibrary")
  end
end
function OnScriptLoaded(level, obj)
  thisObj = obj
  SoundInit()
  game.SubObject.Sleep(thisObj)
end
function OnFirstStart(level, obj)
  GameObjects.PocketRiftdbang.LuaObjectScript.Disable()
end
function OnSaveCheckpoint(level, obj)
  return {completed = completed}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  completed = savedInfo.completed
end
function OnUpdate(level, obj)
  if phase == 1 then
    ConditionsRight(1, 1, viewingTemple)
    ConditionsWrong(1, 1, viewingTemple)
    ConditionsRight(1, 2, viewingBrazierLeft)
    ConditionsWrong(1, 2, viewingBrazierLeft)
    ConditionsRight(1, 3, viewingTemple)
    ConditionsWrong(1, 3, viewingTemple)
    ConditionsRight(1, 4, viewingBrazierRight)
    ConditionsWrong(1, 4, viewingBrazierRight)
    ConditionsRight(1, 5, viewingBrazierLeft)
    ConditionsWrong(1, 5, viewingBrazierLeft)
  end
  if phase == 2 then
    ConditionsRight(2, 1, viewingTemple)
    ConditionsWrong(2, 1, viewingTemple)
    ConditionsRight(2, 2, viewingFloor)
    ConditionsWrong(2, 2, viewingFloor)
    ConditionsRight(2, 3, viewingBrazierRight)
    ConditionsWrong(2, 3, viewingBrazierRight)
    ConditionsRight(2, 4, viewingBrazierLeft)
    ConditionsWrong(2, 4, viewingBrazierLeft)
    ConditionsRight(2, 5, viewingTemple)
    ConditionsWrong(2, 5, viewingTemple)
  end
  if phase == 1 and step == 6 then
    phase = 2
    step = 1
    LookSound()
  elseif phase == 2 and step == 6 then
    phase = 0
    step = 0
    LookSound()
    ShowTreasure()
    CleanUpCEB()
  end
  if 100 < step and coolDownActive == false then
    CoolDownTimerStart()
    coolDownActive = true
  end
end
function ConditionsRight(phaseValue, stepValue, viewTarget)
  if phaseValue == phase and stepValue == step and viewTarget == true and sphereTrigger == true and stepActive == false then
    StepStartActions()
  end
end
function StepStartActions()
  stepActive = true
  ViewTimerStart()
end
function ViewTimerStart()
  viewTimer:Restart()
end
function ConditionsWrong(phaseValue, stepValue, viewTarget)
  if phaseValue == phase and stepValue == step and viewTarget == true and sphereTrigger == true and stepActive == false then
    stepInterruptActions()
  end
end
function stepInterruptActions()
  stepActive = false
  ViewTimerReset()
end
function ViewTimerReset()
  viewTimer:Reset()
end
function CreateLookAtMonitor(object, LookAt, LookAway)
  monitors_LoadLibrary()
  local lookAtMonitor = monitors.CreateLookAtMonitor(object:GetWorldPosition())
  lookAtMonitor:SetMinPercentFromScreenEdge(70)
  lookAtMonitor:OnLookAt(LookAt)
  lookAtMonitor:OnLookAway(LookAway)
  return lookAtMonitor
end
function SequenceCompleted()
  LookSound()
end
function CoolDownTimerStart()
  coolDownTimer:Restart()
end
function CoolDownTimerReset()
  coolDownTimer:Reset()
  coolDownActive = false
end
function ShowTreasure()
  GameObjects.PocketRiftdbang.LuaObjectScript.Enable()
end
function AdvanceStep()
  step = step + 1
  ViewTimerReset()
  CoolDownTimerReset()
  CoolDownTimerStart()
  stepActive = false
end
function ResetSteps()
  step = 1
end
function LookAtTemple()
  viewingTemple = true
end
function LookAwayTemple()
  viewingTemple = false
end
function LookAtBrazierLeft()
  viewingBrazierLeft = true
end
function LookAwayBrazierLeft()
  viewingBrazierLeft = false
end
function LookAtBrazierRight()
  viewingBrazierRight = true
end
function LookAwayBrazierRight()
  viewingBrazierRight = false
end
function LookAtFloor()
  viewingFloor = true
end
function LookAwayFloor()
  viewingFloor = false
end
function SphereTriggerEntered()
  if completed then
    return
  end
  if sphereTrigger == false then
    sphereTrigger = true
    game.SubObject.Wake(thisObj)
    if not TempleMonitor then
      TempleMonitor = CreateLookAtMonitor(GameObjects.TempleTarget, LookAtTemple, LookAwayTemple)
    else
      TempleMonitor:Start()
    end
    if not BrazierLMonitor then
      BrazierLMonitor = CreateLookAtMonitor(GameObjects.BrazierLeftTarget, LookAtBrazierLeft, LookAwayBrazierLeft)
    else
      BrazierLMonitor:Start()
    end
    if not BrazierRMonitor then
      BrazierRMonitor = CreateLookAtMonitor(GameObjects.BrazierRightTarget, LookAtBrazierRight, LookAwayBrazierRight)
    else
      BrazierRMonitor:Start()
    end
    if not FloorMonitor then
      FloorMonitor = CreateLookAtMonitor(GameObjects.FloorTarget, LookAtFloor, LookAwayFloor)
    else
      FloorMonitor:Start()
    end
    if not viewTimer then
      timers_LoadLibrary()
      viewTimer = timers.StartLevelTimer(1, AdvanceStep)
      viewTimer:Reset()
    end
    if not coolDownTimer then
      timers_LoadLibrary()
      coolDownTimer = timers.StartLevelTimer(2.4, ResetSteps)
      coolDownTimer:Reset()
    end
  end
end
function SphereTriggerExited()
  if completed then
    return
  end
  if sphereTrigger == true then
    sphereTrigger = false
    game.SubObject.Sleep(thisObj)
    viewTimer:Reset()
    coolDownTimer:Reset()
    TempleMonitor:Stop()
    BrazierLMonitor:Stop()
    BrazierRMonitor:Stop()
    FloorMonitor:Stop()
    viewingTemple = nil
    viewingBrazierLeft = nil
    viewingBrazierRight = nil
    viewingFloor = nil
    phase = 1
    step = 1
    stepActive = false
    coolDownActive = false
  end
end
function CleanUpCEB()
  completed = true
  if viewTimer.running then
    viewTimer:Stop()
  end
  viewTimer = nil
  if coolDownTimer.running then
    coolDownTimer:Stop()
  end
  coolDownTimer = nil
  TempleMonitor:Stop()
  TempleMonitor:Terminate()
  TempleMonitor = nil
  BrazierLMonitor:Stop()
  BrazierLMonitor:Terminate()
  BrazierLMonitor = nil
  BrazierRMonitor:Stop()
  BrazierRMonitor:Terminate()
  BrazierRMonitor = nil
  FloorMonitor:Stop()
  FloorMonitor:Terminate()
  FloorMonitor = nil
  GameObjects.CEB_V1:FindSingleGOByName("SphereProxTrig"):HideEntityVolume()
  GameObjects.CEB_V1:FindSingleGOByName("ViewTargets"):HideEntityVolume()
  game.SubObject.Sleep(thisObj)
end
local soundEmitter
local soundEvents = {
  isLooping = false,
  OnLook = "SND_MECH_Bell_Puzzle_Hit_Oneshot"
}
function SoundInit()
  if completed then
    return
  end
  soundEmitter = GameObjects.CEB_V1:FindSingleSoundEmitterByName("SNDLook")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(soundEvents[key]))
    end
  end
end
function LookSound()
  LD.PlaySound(soundEmitter, soundEvents.OnLook)
end
