local LD = require("design.LevelDesignLibrary")
local corner01Breakable, corner02Breakable, corner03Breakable, corner04Breakable, topBreakable, pebbleBreakable, baseBreakable
local corner01Broken = false
local corner02Broken = false
local corner03Broken = false
local corner04Broken = false
local topBreakableBroken = false
local brokenCount = 0
local brokenWhole = false
local thisObj
function OnScriptLoaded(level, obj)
  corner01Breakable = obj:FindSingleGOByName("tall_base_a_pristine_break"):GetBreakable()
  corner02Breakable = obj:FindSingleGOByName("tall_base_b_pristine_break"):GetBreakable()
  corner03Breakable = obj:FindSingleGOByName("tall_base_c_pristine_break"):GetBreakable()
  corner04Breakable = obj:FindSingleGOByName("tall_base_d_pristine_break"):GetBreakable()
  topBreakable = obj:FindSingleGOByName("tall_base_top_break"):GetBreakable()
  pebbleBreakable = obj:FindSingleGOByName("clmn_pebbles_ref")
  baseBreakable = obj:FindSingleGOByName("base_break"):GetBreakable()
  thisObj = obj
  SoundInit()
  game.SubObject.Sleep(obj)
end
function pebbleFalls()
  pebbleBreakable:PlayAnimToEnd()
end
function BreakPiece()
  if not brokenWhole then
    brokenCount = brokenCount + 1
    BreakPillar()
  end
end
function BreakWhole()
  if not brokenWhole then
    brokenCount = brokenCount + 2
    BreakPillar()
  end
end
function BreakPillar()
  if 2 <= brokenCount and not brokenWhole then
    brokenWhole = true
    if corner01Breakable.Broken == false then
      corner01Breakable:Break()
    end
    if corner02Breakable.Broken == false then
      corner02Breakable:Break()
    end
    if corner03Breakable.Broken == false then
      corner03Breakable:Break()
    end
    if corner04Breakable.Broken == false then
      corner04Breakable:Break()
    end
    if topBreakable.Broken == false then
      topBreakable:Break()
    end
    if baseBreakable.Broken == false then
      baseBreakable:Break()
    end
    PlayBigBreakSound()
  else
    PlayBreakSound()
    pebbleFalls()
  end
end
local soundEmitterName, soundEmitter, SNDBreakColumn, SNDBreakCorner
function SoundInit()
  soundEmitterName = thisObj:FindLuaTableAttribute("soundEmitterName")
  SNDBreakColumn = "SND_BRK_Stone_Troll_Arena_Pillar_Explo_For800"
  SNDBreakCorner = "SND_BRK_Stone_Troll_Arena_Pillar_Corner_For800"
  if soundEmitterName ~= nil then
    soundEmitter = thisObj:FindSingleSoundEmitterByName(soundEmitterName)
  end
end
function PlayBreakSound()
  LD.PlaySound(soundEmitter, SNDBreakCorner)
end
function PlayBigBreakSound()
  LD.PlaySound(soundEmitter, SNDBreakColumn)
end
