local EL = require("camera.EasingLibrary")
local player
local bOpenedConstraint = false
function OnScriptLoaded(level, camera)
  player = game.Player.FindPlayer()
  camera.OrbitConstraint.RotationMax = 0
end
function OnStart(level, camera)
  if player == nil then
    player = game.Player.FindPlayer()
  end
end
function OnUpdate(level, camera)
  if player:HasMarker("BLOCKING") or player:HasMarker("ATTACKING") or player:HasMarker("Aiming") or player:HasMarker("ForceOpen") then
    bOpenedConstraint = true
    camera.OrbitConstraint.RotationMax = 360
  elseif bOpenedConstraint == true and (player.Pad.L3Down or player.Pad.DownDown or player.Pad.TouchDown or player.Pad.R1Down and player.Pad.R2Down) then
    bOpenedConstraint = false
    camera.OrbitConstraint.RotationMax = 0
  end
end
function OnTeardown(level, camera)
  camera.OrbitConstraint.RotationMax = 0
end
