local OutputTiltUp, OutputTiltDown
function OnScriptLoaded(level, camera)
end
function OnStart(level, camera)
  OutputTiltUp = game.Camera.GetOutputTiltUp()
  OutputTiltDown = game.Camera.GetOutputTiltDown()
  camera.TiltUp = OutputTiltUp
  camera.TiltDown = OutputTiltDown
  if game.Camera.GetPrimary().Position.X > 0.6 and game.Camera.GetPrimary().Position.X < 0.88 then
    camera.Position.X = game.Camera.GetPrimary().Position.X
  elseif game.Camera.GetPrimary().Position.X < 0.6 then
    camera.Position.X = 0.74
  else
    camera.Position.X = camera.initial.Position.X
  end
  if game.Camera.GetOrbitDistance() < 1.5 then
    camera.Distance = 1.5
  else
    camera.Distance = camera.initial.Distance
  end
end
function OnUpdate(level, camera)
  camera.TiltUp = game.Camera.GetOutputTiltUp()
  camera.TiltDown = game.Camera.GetOutputTiltDown()
end
function OnTeardown(level, camera)
  camera.TiltUp = camera.initial.TiltUp
  camera.TiltDown = camera.initial.TiltDown
  camera.Position.X = camera.initial.Position.X
end
function OnSaveCheckpoint(level)
end
function OnRestoreCheckpoint(level, go, tab)
end
