local CL = require("camera.CameraLibrary")
local orbitRotation, kInitialElevationMaxUp
local kElevationMaxUp = 5.9
function OnScriptLoaded(level, camera)
  kInitialElevationMaxUp = camera.initial.OrbitConstraint.ElevationMaxUp
end
function OnStart(level, camera)
end
local CameraUpdateElevationMaxUp = function(camera, driver, min, max, target)
  if max < min then
    if min < driver or driver < max then
      return
    end
  elseif min < max then
    if driver < min or max < driver then
      return
    end
  elseif max == min then
    return
  end
  local scale = CL.ElevationRange(min, max, driver)
  local trueDistance = kInitialElevationMaxUp - target
  local value = trueDistance * scale
  camera.OrbitConstraint.ElevationMaxUp = kInitialElevationMaxUp - value
end
local kLeftMin = -167
local kLeftMax = -178
local kRightMin = 150
local kRightMax = 167
function OnUpdate(level, camera)
  orbitRotation = game.Camera.GetOrbitRotationRelative()
  if orbitRotation > kRightMin then
    if orbitRotation > kRightMax then
      camera.OrbitConstraint.ElevationMaxUp = kElevationMaxUp
    else
      CameraUpdateElevationMaxUp(camera, orbitRotation, kRightMin, kRightMax, kElevationMaxUp)
    end
  elseif orbitRotation < kLeftMin then
    if orbitRotation < kLeftMax then
      camera.OrbitConstraint.ElevationMaxUp = kElevationMaxUp
    else
      CameraUpdateElevationMaxUp(camera, orbitRotation, kLeftMin, kLeftMax, kElevationMaxUp)
    end
  else
    camera.OrbitConstraint.ElevationMaxUp = kInitialElevationMaxUp
  end
end
