local DL = require("design.DesignerLibrary")
local CL = require("camera.CameraLibrary")
local EL = require("camera.EasingLibrary")
local reticleTarget, targetDistance, orbitElevation
local bConstraintOpened = false
local player, playerVelocity
local m_ConstraintBlendTableClosed = {}
local m_ConstraintBlendTableOpen = {}
function OnScriptLoaded(level, camera)
  player = game.Player.FindPlayer()
  playerVelocity = player:GetVelocity()
  camera.OrbitConstraint.RotationMax = 72
  EL.SetupEaseTable(m_ConstraintBlendTableClosed)
  EL.SetBlendValue(camera, m_ConstraintBlendTableClosed, "OrbitConstraint.RotationMax", 72)
  EL.SetDuration(m_ConstraintBlendTableClosed, 1.6)
  EL.SetupEaseTable(m_ConstraintBlendTableOpen)
  EL.SetBlendValue(camera, m_ConstraintBlendTableOpen, "OrbitConstraint.RotationMax", 360)
  EL.SetDuration(m_ConstraintBlendTableOpen, 0.4)
end
function OnStart(level, camera)
  if player == nil then
    player = game.Player.FindPlayer()
  end
end
function OnUpdate(level, camera)
  playerVelocity = player:GetVelocity()
  local boat_intent = game.Camera.GetBoatIntent() > 0.1
  if bConstraintOpened == false then
    if _G.gVFSBoatVelocity.value == true and playerVelocity:Length() < _G.gVFSBoatVelocityValue.value or _G.gVFSBoatStickIntent.value == true and boat_intent == false then
      EL.SetStartValue(camera, m_ConstraintBlendTableOpen)
      EL.SetProgress(m_ConstraintBlendTableOpen, true)
      EL.SetProgress(m_ConstraintBlendTableClosed, false)
      bConstraintOpened = true
      print("Camera: Open boat constraint.")
    end
  elseif _G.gVFSBoatVelocity.value == true and playerVelocity:Length() > _G.gVFSBoatVelocityValue.value or _G.gVFSBoatStickIntent.value == true and boat_intent == true then
    EL.SetStartValue(camera, m_ConstraintBlendTableClosed)
    EL.SetProgress(m_ConstraintBlendTableOpen, false)
    EL.SetProgress(m_ConstraintBlendTableClosed, true)
    bConstraintOpened = false
    print("Camera: Close boat constraint.")
  end
  EL.EaseEverything(level, m_ConstraintBlendTableClosed, camera, "InAndOut", "Quad")
  EL.EaseEverything(level, m_ConstraintBlendTableOpen, camera, "InAndOut", "Cubic")
end
function OnTeardown(level, camera)
  camera.OrbitConstraint.RotationMax = 360
end
