local timer = require("level.timer")
local CL = require("camera.CameraLibrary")
local EL = require("camera.EasingLibrary")
local DL = require("design.DesignerLibrary")
local kEnemyRadius = 30
local targetFStop = 3
local playerCreature = game.Player.FindPlayer()
local enemiesNearby
local bCriticalHealth = false
local bPrevFrameCritical = false
local playerHitPoints
local kCriticalHealthThreshold = 20
local kParryDuration = 0.6
local kNEUTRAL = 0
local kPARRYING = 1
local CombatState = kNEUTRAL
local bCanSwitchStates = true
local bEnteredParryState = false
local parryBlendTable = {}
EL.SetupEaseTable(parryBlendTable)
local parryReturnBlendTable = {}
EL.SetupEaseTable(parryReturnBlendTable)
local holdWideShotTimer = timer.StartLevelTimer(20)
holdWideShotTimer:Stop()
local hitBlurTimer = timer.StartLevelTimer(1.6)
hitBlurTimer:Stop()
local parryTimer = timer.StartLevelTimer(2)
parryTimer:Stop()
local parryReturnTimer = timer.StartLevelTimer(kParryDuration * 2)
parryReturnTimer:Stop()
local dodgeRollTimer = timer.StartLevelTimer(1.2)
dodgeRollTimer:Stop()
local dodgeRollReturnTimer = timer.StartLevelTimer(1.8)
dodgeRollReturnTimer:Stop()
function OnScriptLoaded(level, camera)
  camera.Position.X = camera.initial.Position.X
  camera.Position.Y = camera.initial.Position.Y
  camera.Distance = camera.initial.Distance
  camera.PanLeft = camera.initial.PanLeft
  camera.PanRight = camera.initial.PanRight
  camera.TiltUp = camera.initial.TiltUp
  camera.TiltDown = camera.initial.TiltDown
  CombatState = kNEUTRAL
  bCanSwitchStates = true
end
local PlayerHealthBlur = function(camera)
  if playerHitPoints <= kCriticalHealthThreshold then
    bCriticalHealth = true
  else
    if bPrevFrameCritical == true then
      camera.FStop = camera.initial.FStop
    end
    if camera.FStop < camera.initial.FStop then
      camera.FStop = camera.initial.FStop
    end
    bCriticalHealth = false
    hitBlurTimer:Restart()
    hitBlurTimer:Stop()
    return
  end
  if bCriticalHealth == true and bPrevFrameCritical == false and hitBlurTimer.running == false and hitBlurTimer.running == false then
    hitBlurTimer:Start()
  end
  if hitBlurTimer.running == true and camera.FStop > targetFStop then
    camera.FStop = targetFStop
  elseif hitBlurTimer.fired == true and camera.FStop < camera.initial.FStop then
    camera.FStop = camera.FStop + 0.1
  end
  bPrevFrameCritical = bCriticalHealth
end
function OnUpdate(level, camera)
  playerCreature = CL.FindPlayerSafetyCheck(playerCreature)
  enemiesNearby = playerCreature:FindEnemies(kEnemyRadius)
  for _, i in pairs(enemiesNearby) do
    if CombatState < kPARRYING and bCanSwitchStates == true and i:HasMarker("Recoil") then
      local parryAngle = DL.FrontAngle(playerCreature, i)
      if parryAngle < -15 then
        CombatState = kPARRYING
      end
    end
    if CombatState == kPARRYING then
      if parryTimer.running == false and parryTimer.fired == false and bEnteredParryState == false then
        bEnteredParryState = true
        bCanSwitchStates = false
        if camera.name == "CBT_SuperClose_Far" then
          EL.SetBlendValue(camera, parryBlendTable, "PanLeft", 4)
          EL.SetBlendValue(camera, parryBlendTable, "PanRight", 4)
        else
          EL.SetBlendValue(camera, parryBlendTable, "PanLeft", 8)
          EL.SetBlendValue(camera, parryBlendTable, "PanRight", 8)
          EL.SetBlendValue(camera, parryBlendTable, "Distance", 2)
        end
        EL.SetStartValue(camera, parryBlendTable)
        EL.SetDuration(parryBlendTable, kParryDuration)
        EL.SetProgress(parryBlendTable, true)
        parryTimer:Start()
      end
      if parryTimer.fired == true then
        parryTimer:Reset()
        parryTimer:Stop()
        EL.SetBlendValue(camera, parryBlendTable, "PanLeft", camera.initial.PanLeft)
        EL.SetBlendValue(camera, parryBlendTable, "PanRight", camera.initial.PanRight)
        EL.SetBlendValue(camera, parryBlendTable, "Distance", camera.initial.Distance)
        EL.SetStartValue(camera, parryBlendTable)
        local duration = 2
        EL.SetDuration(parryBlendTable, duration)
        parryReturnTimer:Start()
        EL.SetProgress(parryBlendTable, true)
      end
      if parryReturnTimer.fired == true then
        CombatState = kNEUTRAL
        parryReturnTimer:Reset()
        parryReturnTimer:Stop()
        bEnteredParryState = false
        bCanSwitchStates = true
      end
    end
  end
  if EL.GetProgress(parryBlendTable) == true then
    EL.EaseEverything(level, parryBlendTable, camera, "InAndOut", "Quad")
  end
  playerHitPoints = playerCreature:GetHitPoints()
  PlayerHealthBlur(camera)
end
