local CL = require("camera.CameraLibrary")
local orbitRotation, orbitElevation
local player = game.Player.FindPlayer()
local panLeft, panRight
function OnScriptLoaded(level, camera)
  player = game.Player.FindPlayer()
  panLeft = camera.initial.PanLeft
  panRight = camera.initial.PanRight
  camera.PanLeft = 0
  camera.PanRight = 0
end
function OnStart(level, camera)
  if player == nil then
    player = game.Player.FindPlayer()
  end
end
local CameraUpdatePan = function(camera, driver, min, max, target)
  if max < min then
    if min < driver or driver < max then
      return
    end
  elseif min < max then
    if driver < min or max < driver then
      return
    end
  elseif max == min then
    return
  end
  local scale = CL.ElevationRange(min, max, driver)
  camera.PanLeft = target * scale
  camera.PanRight = target * scale
end
function OnUpdate(level, camera)
  orbitRotation = game.Camera.GetOrbitRotationRelative()
  orbitElevation = game.Camera.GetOrbitElevation()
  CL.CameraUpdateAttribute(camera, orbitElevation, 8, 60, "tilt", 10)
  CL.CameraUpdateAttribute(camera, orbitElevation, -8, -70, "tilt", -10)
  CameraUpdatePan(camera, orbitRotation, 0, 80, panLeft)
  CameraUpdatePan(camera, orbitRotation, -0, -80, panRight)
end
