local timer = require("level.timer")
local hitBlurTimer = timer.StartLevelTimer(2.4)
hitBlurTimer:Stop()
local bCriticalHealth = false
local bLastHealthCritical = false
local playerHitPoints
local kCriticalHealthThreshold = 20
local originalFStop = 11
local targetFStop = 0.8
local playerCreature = game.Player.FindPlayer()
function OnScriptLoaded(level, camera)
end
function OnUpdate(level, camera)
  if playerCreature == nil then
    playerCreature = game.Player.FindPlayer()
  else
    playerHitPoints = playerCreature:GetHitPoints()
  end
  PlayerHealthBlur(playerHitPoints, camera)
end
function OnTeardown(level, camera)
end
function PlayerHealthBlur(playerHitPoints, camera)
  if playerHitPoints <= kCriticalHealthThreshold then
    if bLastHealthCritical == false then
      bCriticalHealth = true
    end
  else
    bCriticalHealth = false
    hitBlurTimer:Restart()
    hitBlurTimer:Stop()
  end
  if bCriticalHealth == true and hitBlurTimer.running == false then
    hitBlurTimer:Start()
  end
  if hitBlurTimer.running == true then
    if camera.FStop > targetFStop then
      camera.FStop = camera.FStop - 0.2
    end
  elseif hitBlurTimer.fired == true and camera.FStop < originalFStop then
    camera.FStop = camera.FStop + 0.1
  end
  bLastHealthCritical = bCriticalHealth
end
function OnSaveCheckpoint(level)
end
function OnRestoreCheckpoint(level, go, tab)
end
