local EL = require("camera.EasingLibrary")
local pad
local bConstraintOpened = false
local player = game.Player.FindPlayer()
local deadZoneMax = 0.11
local m_ConstraintBlendTableClosed = {}
local m_ConstraintBlendTableOpen = {}
local padAbsCorrectedY, padAbsCorrectedX
function OnScriptLoaded(level, camera)
  player = game.Player.FindPlayer()
  camera.OrbitConstraint.YawRange = 0
  pad = player.Pad
  EL.SetupEaseTable(m_ConstraintBlendTableClosed)
  EL.SetBlendValue(camera, m_ConstraintBlendTableClosed, "OrbitConstraint.YawRange", 0)
  EL.SetDuration(m_ConstraintBlendTableClosed, 0.2)
  EL.SetupEaseTable(m_ConstraintBlendTableOpen)
  EL.SetBlendValue(camera, m_ConstraintBlendTableOpen, "OrbitConstraint.YawRange", 180)
  EL.SetDuration(m_ConstraintBlendTableOpen, 0.2)
end
function OnStart(level, camera)
  if player == nil then
    player = game.Player.FindPlayer()
  end
end
function OnUpdate(level, camera)
  padAbsCorrectedY = math.abs(pad.CorrectedLeftStick.y)
  padAbsCorrectedX = math.abs(pad.CorrectedLeftStick.x)
  if bConstraintOpened == true then
    if (padAbsCorrectedY < padAbsCorrectedX or padAbsCorrectedY < deadZoneMax and padAbsCorrectedX > deadZoneMax) and player:HasMarker("Attacking") == false then
      EL.SetStartValue(camera, m_ConstraintBlendTableClosed)
      EL.SetProgress(m_ConstraintBlendTableOpen, false)
      EL.SetProgress(m_ConstraintBlendTableClosed, true)
      bConstraintOpened = false
    end
  elseif padAbsCorrectedY < deadZoneMax and padAbsCorrectedX < deadZoneMax or padAbsCorrectedY > padAbsCorrectedX or player:HasMarker("Attacking") then
    EL.SetStartValue(camera, m_ConstraintBlendTableOpen)
    EL.SetProgress(m_ConstraintBlendTableOpen, true)
    EL.SetProgress(m_ConstraintBlendTableClosed, false)
    bConstraintOpened = true
  end
  EL.EaseEverything(level, m_ConstraintBlendTableClosed, camera, "InAndOut", "Quad")
  EL.EaseEverything(level, m_ConstraintBlendTableOpen, camera, "InAndOut", "Cubic")
end
function OnSaveCheckpoint(level)
end
function OnRestoreCheckpoint(level, go, tab)
end
