local CL = require("camera.CameraLibrary")
local timer = require("level.timer")
local enemiesNearby
local fseImpactShake = {
  EffectName = "FSE_SHAKE_FROSTSLAM",
  Duration = 2
}
local player = game.Player.FindPlayer()
function OnScriptLoaded(level, camera)
  player = game.Player.FindPlayer()
  enemiesNearby = player:FindEnemies(10)
  camera.Position.Y = camera.initial.Position.Y
  camera.Pitch = camera.initial.Pitch
  camera.Distance = camera.initial.Distance
  camera.TiltDown = camera.initial.TiltDown
  camera.TiltUp = camera.initial.TiltUp
  timer.StartLevelTimer(0.1, camFrostSlamShake)
  for _, enemy in ipairs(enemiesNearby) do
    if CL.IsLargeCreature(enemy) == true and CL.FrontAngleXZ(enemy.WorldPosition) < camera.fov / 2 and CL.FrontAngleXZ(enemy.WorldPosition) > -1 * (camera.fov / 2) then
      print(enemy)
      camera.Position.Y = 0.85
      camera.Distance = 4.25
      camera.Pitch = -8
      camera.TiltUp = 8
      camera.TiltDown = 8
    end
  end
end
function OnUpdate(level, camera)
end
function OnTeardown(level, camera)
end
function camFrostSlamShake()
  game.FX.SubmitEffect(fseImpactShake)
end
