local playerCreature
local fTargetDamping = 0.94
local fOriginalDamping
local fIdleDamping = 0.8
local fJogDamping = 0.82
local fDefaultDamping = 0.82
local fReducedDamping = 0.38
local stickIntentL, stickIntentR, pad
function OnScriptLoaded(level, camera)
  playerCreature = game.Player.FindPlayer()
  pad = playerCreature.Pad
  fOriginalDamping = camera.BoomDamping
  if pad ~= nil then
    stickIntentL = pad.CorrectedLeftStick
    stickIntentR = pad.CorrectedRightStick
  end
end
function OnUpdate(level, camera)
  if pad ~= nil then
    stickIntentL = pad.CorrectedLeftStick
    stickIntentR = pad.CorrectedRightStick
    if playerCreature == nil then
      playerCreature = game.Player.FindPlayer()
    end
    if playerCreature:HasMarker("Attacking") and stickIntentR.x < 0.8 and stickIntentR.x > -0.8 and playerCreature:HasMarker("Blocking") ~= true then
      if camera.BoomDamping < fTargetDamping then
        camera.BoomDamping = camera.BoomDamping + 0.01
      end
    else
      if camera.name == "PLYR_FreeRoam_Idle" then
        if camera.BoomDamping > fIdleDamping then
          camera.BoomDamping = camera.BoomDamping - 0.01
        end
      elseif camera.name == "PLYR_FreeRoamJog" then
        if camera.BoomDamping > fJogDamping then
          camera.BoomDamping = camera.BoomDamping - 0.01
        end
      elseif camera.BoomDamping > fDefaultDamping then
        camera.BoomDamping = camera.BoomDamping - 0.01
      end
      if stickIntentL.y < 0 then
        if camera.BoomDamping > fReducedDamping then
          camera.BoomDamping = camera.BoomDamping - 0.05
        end
      elseif camera.BoomDamping < fDefaultDamping then
        camera.BoomDamping = camera.BoomDamping + 0.01
      end
    end
  end
end
function OnTeardown(level, camera)
  if camera ~= nil and fOriginalDamping ~= nil then
    camera.BoomDamping = fOriginalDamping
  end
end
function OnSaveCheckpoint(level)
end
function OnRestoreCheckpoint(level, go, tab)
end
