local CL = require("camera.CameraLibrary")
local orbitRotation, player, fov, fovTarget
function OnScriptLoaded(level, camera)
  player = game.Player.FindPlayer()
  fov = camera.initial.AngleOfView
  fovTarget = 69
end
function OnStart(level, camera)
  if player == nil then
    player = game.Player.FindPlayer()
  end
end
local CameraUpdateFov = function(camera, driver, min, max, target)
  if max < min then
    if min < driver or driver < max then
      return
    end
  elseif min < max then
    if driver < min or max < driver then
      return
    end
  elseif max == min then
    return
  end
  local scale = CL.ElevationRange(min, max, driver)
  camera.AngleOfView = (target - fov) * scale + fov
end
function OnUpdate(level, camera)
  orbitRotation = game.Camera.GetOrbitRotationRelative()
  if 0 < orbitRotation then
    CameraUpdateFov(camera, orbitRotation, 3, 32, fovTarget)
  else
    CameraUpdateFov(camera, orbitRotation, -3, -32, fovTarget)
  end
end
