local recenterTable
function OnScriptLoaded(level, camera)
  local angle = GetZiplineData("angle")
  if angle ~= nil then
    angle = angle * -1
    recenterTable = {
      TimeStart = 0,
      TimeDuration = 2,
      LockRecenter = 0.4,
      PitchRange = -1,
      YawRange = 180,
      TriggerUp = 0,
      TriggerDown = -45,
      ReturnUp = angle,
      ReturnDown = angle,
      MoveStart = 0,
      MoveDistance = 15
    }
    camera.OrbitConstraint.ReturnUp = angle
    camera.OrbitConstraint.ReturnDown = angle
  end
end
function OnStart(level, camera)
  if recenterTable ~= nil then
    game.Camera.Recenter(recenterTable)
  end
end
function GetZiplineData(attribute)
  local player = game.Player.FindPlayer()
  local traverseLinkInfo = player:GetNearbyTraverseLinks()
  local zipline
  for _, link in ipairs(traverseLinkInfo) do
    if link.TraverseLinkType == "kZipline" then
      zipline = link
      break
    end
  end
  if zipline ~= nil then
    if attribute == "angle" then
      return zipline.YAngleStartToEnd
    elseif attribute == "length" then
      return zipline.TraverseLength
    end
  end
end
