local profile = require("core.profile")
local timer = require("level.timer")
local CNL = require("camera.CameraNavigationLibrary")
local CCbtL = require("camera.CameraCombatLibrary")
local CkCL = require("camera.CameraConstantsLibrary")
local DL = require("design.DesignerLibrary")
local UICALLS = require("ui.uicalls")
local offscreen = require("camera.offscreen")
local CameraCriticalHealth, DisableUIElements, isEnemyInTable
engine.SetIncrementalGCTime(250)
local gVFSPlainNavCam = engine.VFSBool.New("Use Plain Nav Cam")
local gVFSDebugOffScreenIndicator = engine.VFSBool.New("Debug OffScreen Indicators")
local gVFSCombatYawRecenter = engine.VFSBool.New("COMBAT: Recenter Yaw on Attack")
_G.gVFSCombatSlowVertical = engine.VFSBool.New("COMBAT: Slow-Limited Vertical on Attack")
_G.gVFSBoatStickIntent = engine.VFSBool.New("Boat - Stick Intent Only")
_G.gVFSBoatVelocity = engine.VFSBool.New("Boat - Velocity Only")
_G.gVFSBoatVelocityValue = engine.VFSFloat.New("Boat - Min Speed for Follow Cam", 0, 12, 0.1)
local gVFSDisableEnemyAssist = engine.VFSBool.New("Disable Enemy Assist")
gVFSDisableEnemyAssist.value = true
gVFSCombatYawRecenter.value = true
_G.gVFSCombatSlowVertical.value = true
_G.gVFSBoatStickIntent.value = true
_G.gVFSBoatVelocityValue.value = 3
gVFSDebugOffScreenIndicator.value = false
local gVFSAlternativeOffscreenIndicators = engine.VFSInt.New("RENO: Alternative Offscreen Indicators (0 = OFF) ", 0, 5)
gVFSAlternativeOffscreenIndicators.value = 1
local player
local playerPosition = engine.Vector.New()
local strThreatLevel, enemiesNearby, enemyCount, inCombat, son, playerHealth
local bIsCritical = false
local kCriticalLevel = 20
local heartbeatTimer = timer.StartLevelTimer(4)
heartbeatTimer:Stop()
local boatNavIdleTimer = timer.StartLevelTimer(0.1)
boatNavIdleTimer:Stop()
local fseHeartbeat = {
  EffectName = "FSE_sway_HeartBeatZolly_2_40",
  Duration = 3
}
function OnScriptLoaded(level)
  offscreen.Init(gVFSAlternativeOffscreenIndicators)
  player = game.Player.FindPlayer()
end
function OnStart(level)
  if player == nil then
    player = game.Player.FindPlayer()
  end
end
function CameraCriticalHealth(playersHealth)
  if playersHealth <= 0 then
    if heartbeatTimer then
      heartbeatTimer:Stop()
      heartbeatTimer:Reset()
    end
    return
  end
  if playersHealth < kCriticalLevel and bIsCritical == false then
    game.FX.SubmitEffect(fseHeartbeat)
    bIsCritical = true
    heartbeatTimer:Start()
  elseif playersHealth > kCriticalLevel and heartbeatTimer.fired == true then
    bIsCritical = false
  end
end
function DisableUIElements(thisEnemy)
  engine.SendHook("OnHideGenericOffScreenIndicator", thisEnemy)
  engine.SendHook("OnHideGenericOffScreenIndicatorAggressive", thisEnemy)
end
function isEnemyInTable(enemy, myTable)
  for _, member in pairs(myTable) do
    if member.name == enemy then
      return true
    end
  end
  return false
end
function OnUpdate(level)
  if player == nil then
    player = game.Player.FindPlayer()
  else
    if gVFSPlainNavCam.value == true then
      game.Camera.SubmitCameraByName("PLYR_Nav_Plain")
    end
    enemiesNearby = player:FindEnemies(CkCL.kCombatRadius)
    strThreatLevel = CCbtL.GetThreatLevel(enemiesNearby)
    enemyCount = CCbtL.TargetingPlayerCount(enemiesNearby)
    playerPosition = player:GetWorldPosition()
    playerHealth = player:GetHitPoints()
    inCombat = game.Combat.GetCombatStatus()
    if player:IsInVehicle() == true then
      if player:HasMarker("Exit") ~= true then
        game.Camera.SubmitCameraByName("PLYR_Boat_Idle")
        if game.World.IsInsideCameraZone(playerPosition, "CamBoatZoneNear*") then
          game.Camera.SubmitCameraByName("PLYR_Boat_Forward_Near")
        elseif game.World.IsInsideCameraZone(playerPosition, "CamBoatZoneTight*") then
          game.Camera.SubmitCameraByName("PLYR_Boat_Forward_Tight")
        end
        local boat_intent = game.Camera.GetBoatIntent() > 0.1
        if boat_intent == true then
          game.Camera.SubmitCameraByName("PLYR_Boat_Reverse")
          game.Camera.SubmitCameraByName("PLYR_Boat_Forward")
        end
      end
    elseif inCombat == true and player:HasMarker("Climbing") == false then
      CCbtL.UpdateEnemyAssistCombatNavCamera(strThreatLevel, enemyCount)
    end
    CNL.BaseNavCamUpdate(player, playerPosition, level)
    if son == nil then
      son = game.AI.FindSon()
    end
    CNL.UpdateNavigationStateCamera(player, playerPosition, son)
    CameraCriticalHealth(playerHealth)
    if game.UI.GetOffScreenIndicatorsEnabled ~= nil then
      if game.UI.GetOffScreenIndicatorsEnabled() then
        offscreen.UpdateOffScreenIndicator()
      end
    else
      offscreen.UpdateOffScreenIndicator()
    end
  end
end
function LuaHook_TurtleRise()
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  riv475:CallScript("CameraTurtleRising")
end
function LuaHook_GoToTheMountain()
  local for200 = game.FindLevel("For200_House")
  for200:CallScript("QuestRiverPassParentStart")
end
function LuaHook_EvadeRecenter()
  game.Camera.CancelRecenter()
end
function LuaHook_RecenterAttack()
  local playerTargetCreature
  if player:GetTargetCreature() ~= nil then
    playerTargetCreature = player:GetTargetCreature():GetName()
  end
  if #player:FindEnemies(6) > 0 and playerTargetCreature ~= nil then
    if playerTargetCreature == "troll00" or playerTargetCreature == "troll10" or playerTargetCreature == "troll20" then
      game.Camera.Recenter({
        TimeStart = 0,
        TimeDuration = 0.8,
        PitchRange = -1,
        YawRange = 360,
        TriggerDown = 0,
        ReturnDown = 8,
        TriggerUp = 0,
        ReturnUp = 10,
        EaseIn = -1,
        EaseOut = 1,
        LockRecenter = 0.2
      })
    else
      game.Camera.Recenter({
        TimeStart = 0,
        TimeDuration = 2,
        PitchRange = -1,
        YawRange = 360,
        TriggerDown = -32,
        ReturnDown = -18,
        TriggerUp = 28,
        ReturnUp = -5,
        EaseIn = -1,
        EaseOut = 1,
        LockRecenter = 0.2
      })
    end
  end
end
function LuaHook_RecenterAttackYaw()
  if game.UI.GetUserAttackRecenter() == true and gVFSCombatYawRecenter.value == true and game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_DragonArena*") ~= true then
    game.Camera.Recenter({
      TimeStart = 0,
      TimeDuration = 1.2,
      PitchRange = 90,
      YawRange = -1,
      TriggerLeft = 35,
      ReturnLeft = 30,
      TriggerRight = -35,
      ReturnRight = -30,
      EaseIn = -1,
      EaseOut = 1,
      LockRecenter = 0,
      HoldOrientation = 1
    })
  end
end
function LuaHook_RecenterAimTrack()
  game.Camera.Recenter({
    TimeStart = 0,
    TimeDuration = 0.4,
    PitchRange = 90,
    YawRange = -1,
    TriggerLeft = 6,
    ReturnLeft = 4,
    TriggerRight = -6,
    ReturnRight = -4,
    EaseIn = -1,
    EaseOut = 1,
    LockRecenter = 0,
    HoldOrientation = 1
  })
end
function LuaHook_RecenterHitReact()
end
function LuaHook_LockCamera()
  game.Camera.Recenter({
    TimeStart = 0,
    TimeDuration = 0.5,
    PitchRange = 0,
    YawRange = 0,
    ReturnLeft = 180,
    ReturnRight = -180,
    ReturnUp = 90,
    ReturnDown = -90,
    LockRecenter = 1
  })
end
function LuaHook_csRecenter_2Seconds()
  game.Camera.Recenter({
    TimeStart = 0,
    TimeDuration = 2,
    PitchRange = 90,
    YawRange = -1,
    TriggerLeft = 0,
    ReturnLeft = 0,
    TriggerRight = 0,
    ReturnRight = 0,
    LockRecenter = 0.2
  })
end
function LuaHook_csCamCrackClimbEnterUp()
  local playerPos = game.Player.FindPlayer():GetWorldPosition()
  if game.World.IsInsideCameraZone(playerPos, "CamZone_ClimbEnter_RS_HorizUp*") then
    print("navClimbEnterUp_csCam_RS_UpHoriz")
    game.Camera.Recenter({
      TimeStart = 0.1,
      TimeDuration = 2.2,
      LockRecenter = 0.2,
      PitchRange = -1,
      ReturnDown = -30,
      ReturnUp = -30,
      YawRange = 180
    })
  elseif game.World.IsInsideCameraZone(playerPos, "CamZone_ClimbEnter_LS_HorizUp*") then
    print("navClimbEnterUp_csCam_LS_UpHoriz")
    game.Camera.Recenter({
      TimeStart = 0.1,
      TimeDuration = 2.2,
      LockRecenter = 0.2,
      PitchRange = -1,
      ReturnDown = -30,
      ReturnUp = -30,
      YawRange = 180
    })
  elseif game.World.IsInsideCameraZone(playerPos, "CamZone_HammerClimbEnter_FirstTunnel") then
    game.Camera.Recenter({
      RotationSpace = 1,
      TimeStart = 0,
      TimeDuration = 1.6,
      LockRecenter = 0.2,
      YawRange = -1,
      TriggerLeft = 83.8,
      ReturnLeft = 83.8,
      ReturnRight = 83.8,
      TriggerRight = 83.8,
      PitchRange = -1,
      ReturnDown = 6.8,
      ReturnUp = 6.8
    })
  elseif game.World.IsInsideCameraZone(playerPos, "CamZone_HammerClimbEnter_SecondTunnel") then
    return
  else
    game.Camera.Recenter({
      TimeStart = 0.1,
      TimeDuration = 2.2,
      LockRecenter = 0.2,
      PitchRange = -1,
      ReturnDown = 20,
      ReturnUp = 20,
      YawRange = 180
    })
  end
end
function LuaHook_csCamCrackClimbExitDown()
  print("Camera: No crack climb enter zone found. Using default navClimbExitDown_csCam_Default.")
  game.Camera.Recenter({
    TimeStart = 0.1,
    TimeDuration = 1.2,
    LockRecenter = 0,
    PitchRange = -1,
    ReturnDown = -4,
    ReturnUp = -4,
    YawRange = 360
  })
end
function LuaHook_csCamCrackClimbEnterDown()
  game.Camera.Recenter({
    TimeStart = 0,
    TimeDuration = 3,
    LockRecenter = 0,
    PitchRange = -1,
    ReturnDown = -30,
    ReturnUp = -30,
    YawRange = -1,
    ReturnLeft = 22,
    ReturnRight = -22
  })
end
function LuaHook_csCamCrackClimbExitUp()
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_DoNotRecenter") ~= true then
    game.Camera.Recenter({
      TimeStart = 0,
      TimeDuration = 1.2,
      LockRecenter = 0.8,
      PitchRange = -1,
      TriggerUp = 32,
      TriggerDown = -40,
      ReturnDown = -7,
      ReturnUp = -7,
      YawRange = 360,
      TriggerLeft = 45,
      TriggerRight = -45,
      ReturnLeft = 12,
      ReturnRight = -12
    })
  end
end
function LuaHook_csCamRopeClimbExitUp()
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_DoNotRecenter") ~= true then
    game.Camera.Recenter({
      TimeStart = 0,
      TimeDuration = 1.2,
      LockRecenter = 0.8,
      PitchRange = -1,
      TriggerUp = 32,
      TriggerDown = -40,
      ReturnDown = -7,
      ReturnUp = -7,
      YawRange = 360,
      TriggerLeft = 45,
      TriggerRight = -45,
      ReturnLeft = 12,
      ReturnRight = -12
    })
  end
end
function LuaHook_camElevationReset()
  game.Camera.Recenter({
    TimeStart = 0,
    TimeDuration = 1.5,
    LockRecenter = 0,
    PitchRange = -1,
    ReturnDown = -12,
    ReturnUp = -12,
    YawRange = 360
  })
end
function LuaHook_ZoomSnap()
  game.Camera.ZoomSnap(0.2)
end
function LuaHook_cam180Recenter()
  local currentOrbitWorld = game.Camera.GetOrbitRotation()
  local orbit180 = currentOrbitWorld + 182
  game.Camera.Recenter({
    RotationSpace = 1,
    TimeStart = 0,
    TimeDuration = 0.35,
    LockRecenter = 1,
    PitchRange = 90,
    YawRange = -1,
    ReturnLeft = orbit180,
    ReturnRight = orbit180,
    EaseIn = -1,
    EaseOut = 1
  })
end
function LuaHook_cam180RecenterViaDriver()
  local cameraWorldSpaceForward = engine.Vector.New(0, 0, -1)
  local quickTurnDirection = player:GetAnimDriver("QuickTurnDir")
  local qtDvec = engine.Vector.New(quickTurnDirection.ValueX, quickTurnDirection.ValueY, quickTurnDirection.ValueZ)
  qtDvec = qtDvec:Normalized()
  print("[Camera] Quick turn driver vector: ", qtDvec)
  local quickTurnAngle = DL.GetAngleBetweenVector(qtDvec, cameraWorldSpaceForward)
  print("[Camera] Quick Turn World Space Angle: ", quickTurnAngle)
  game.Camera.Recenter({
    RotationSpace = 1,
    TimeStart = 0,
    TimeDuration = 0.35,
    LockRecenter = 1,
    PitchRange = 90,
    YawRange = -1,
    TriggerLeft = quickTurnAngle,
    ReturnLeft = quickTurnAngle,
    TriggerRight = quickTurnAngle,
    ReturnRight = quickTurnAngle,
    EaseIn = -1,
    EaseOut = 1
  })
end
function LuaHook_StartTendrilCameras()
  local alf370 = game.FindLevel("Alf370_MoatScripting")
  if alf370 ~= nil then
    alf370:CallScript("StartRevealCameras")
  end
end
function LuaHook_csDoorSpreadOpenOverride()
  local overrideCsCam
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_SpreadDoorOverride_LookUp*") then
    overrideCsCam = {
      Animation = "DoorSpreadOpen_csCamUp",
      IgnoreCollision = 1,
      TweenIn = {
        Time = 1,
        EaseIn = 1,
        EaseOut = 1
      },
      TweenOut = {
        Time = 1.2,
        EaseIn = 1,
        EaseOut = 1
      },
      Priority = 1100,
      SynchJoint = "camJoint",
      TweenOutIgnoreRotation = 1
    }
    game.Camera.StartCamera(overrideCsCam)
  end
end
function LuaHook_DoorPushStayOpenOverride()
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_PushDoor_Override_Helheim*") then
    local hel200 = game.FindLevel("Hel200_EntranceDoor")
    if hel200 ~= nil then
      hel200:CallScript("StartOneShot_GhostsReturn")
    end
  end
end
function LuaHook_csBuddyBoostOverrideStand()
  local overrideCsCam
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_Boost_Left*") then
    overrideCsCam = {
      Animation = "navBuddyBoostSon01_camLookLeft",
      IgnoreCollision = 1,
      TweenIn = {
        Time = 0.6,
        EaseIn = 1,
        EaseOut = 1
      },
      TweenOut = {
        Time = 1.8,
        EaseIn = 1,
        EaseOut = 1
      },
      Priority = 1100,
      SynchJoint = "camJoint",
      TweenOutIgnoreRotation = 1
    }
    game.Camera.StartCamera(overrideCsCam)
    timer.StartLevelTimer(5.3, function()
      game.Camera.Recenter({
        TimeStart = 0,
        TimeDuration = 2.2,
        EaseIn = 1,
        EaseOut = 1,
        Lock = 1,
        YawRange = -1,
        PitchRange = -1,
        TriggerLeft = 38,
        TriggerRight = 38,
        ReturnLeft = 38,
        ReturnRight = 38,
        ReturnUp = 19,
        ReturnDown = 19
      })
    end)
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Boost_Right*") then
    overrideCsCam = {
      Animation = "navBuddyBoostSon0_camLookRight",
      IgnoreCollision = 1,
      TweenIn = {
        Time = 0.6,
        EaseIn = 1,
        EaseOut = 1
      },
      TweenOut = {
        Time = 1.8,
        EaseIn = 1,
        EaseOut = 1
      },
      Priority = 1100,
      SynchJoint = "camJoint",
      TweenOutIgnoreRotation = 1
    }
    game.Camera.StartCamera(overrideCsCam)
    timer.StartLevelTimer(5.3, function()
      game.Camera.Recenter({
        TimeStart = 0,
        TimeDuration = 2.2,
        EaseIn = 1,
        EaseOut = 1,
        Lock = 1,
        YawRange = -1,
        PitchRange = -1,
        TriggerLeft = -32,
        TriggerRight = -32,
        ReturnLeft = -32,
        ReturnRight = -32,
        ReturnUp = 19,
        ReturnDown = 19
      })
    end)
  end
end
function LuaHook_csBuddyBoostOverrideCrawl()
  local overrideCsCam
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_Boost_Left*") then
    overrideCsCam = {
      Animation = "navBuddyBoostSon0_camLookLeft",
      IgnoreCollision = 1,
      TweenIn = {
        Time = 0.6,
        EaseIn = 1,
        EaseOut = 1
      },
      TweenOut = {
        Time = 1.8,
        EaseIn = 1,
        EaseOut = 1
      },
      Priority = 1100,
      SynchJoint = "camJoint",
      TweenOutIgnoreRotation = true
    }
    game.Camera.StartCamera(overrideCsCam)
    timer.StartLevelTimer(5.3, function()
      game.Camera.Recenter({
        TimeStart = 0,
        TimeDuration = 2.2,
        EaseIn = 1,
        EaseOut = 1,
        Lock = 1,
        YawRange = -1,
        PitchRange = -1,
        TriggerLeft = 38,
        TriggerRight = 38,
        ReturnLeft = 38,
        ReturnRight = 38,
        ReturnUp = 8,
        ReturnDown = 8
      })
    end)
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Boost_Right*") then
    overrideCsCam = {
      Animation = "navBuddyBoostSon00_camLookRight",
      IgnoreCollision = 1,
      TweenIn = {
        Time = 0.6,
        EaseIn = 1,
        EaseOut = 1
      },
      TweenOut = {
        Time = 1.8,
        EaseIn = 1,
        EaseOut = 1
      },
      Priority = 1100,
      SynchJoint = "camJoint",
      TweenOutIgnoreRotation = true
    }
    game.Camera.StartCamera(overrideCsCam)
    timer.StartLevelTimer(5.3, function()
      game.Camera.Recenter({
        TimeStart = 0,
        TimeDuration = 2.2,
        EaseIn = 1,
        EaseOut = 1,
        Lock = 1,
        YawRange = -1,
        PitchRange = -1,
        TriggerLeft = -32,
        TriggerRight = -32,
        ReturnLeft = -32,
        ReturnRight = -32,
        ReturnUp = 8,
        ReturnDown = 8
      })
    end)
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Boost_Custom_Alf690*") then
    timer.StartLevelTimer(5.3, function()
      game.Camera.Recenter({
        TimeStart = 0,
        TimeDuration = 2.2,
        EaseIn = 1,
        EaseOut = 1,
        Lock = 1,
        RotationSpace = 1,
        YawRange = -1,
        PitchRange = -1,
        TriggerLeft = 42,
        TriggerRight = 42,
        ReturnLeft = 42,
        ReturnRight = 42,
        ReturnUp = 10,
        ReturnDown = 10
      })
    end)
  end
end
function LuaHook_csAproachRecenterTraversePath()
  if inCombat == false then
    local playerPos = player:GetWorldPosition()
    local interactPosition = player:GetBestTraversePathChoicePosition()
    local toInteract = interactPosition - playerPos
    local interactFwd = player:GetBestTraversePathChoiceForward()
    local cameraWorldSpaceForward = engine.Vector.New(0, 0, 1)
    if 0 < toInteract:Dot(interactFwd) then
      print("Approaching from Front")
    else
      print("Approaching from Behind")
    end
    local interactAngle = DL.GetAngleBetweenVector(interactFwd, cameraWorldSpaceForward)
    print("Interact Angle: ", interactAngle)
    if game.World.IsInsideCameraZone(playerPos, "CamFrontPress_Lookdown") then
      game.Camera.Recenter({
        RotationSpace = 1,
        TimeStart = 0,
        TimeDuration = 2.2,
        LockRecenter = 1,
        YawRange = -1,
        TriggerLeft = 0,
        TriggerRight = 0,
        ReturnLeft = interactAngle,
        ReturnRight = interactAngle,
        PitchRange = -1,
        ReturnUp = -50,
        ReturnDown = -50
      })
    else
      game.Camera.Recenter({
        RotationSpace = 1,
        TimeStart = 0,
        TimeDuration = 1.2,
        LockRecenter = 1,
        YawRange = -1,
        TriggerLeft = 0,
        TriggerRight = 0,
        ReturnLeft = interactAngle,
        ReturnRight = interactAngle,
        PitchRange = -1,
        ReturnUp = -14,
        ReturnDown = -14
      })
    end
  end
end
function LuaHook_CameraGapJumpRecenter()
  game.Camera.Recenter({
    TimeStart = 0,
    TimeDuration = 1,
    LockRecenter = 0.4,
    PitchRange = -1,
    ReturnDown = -6,
    ReturnUp = -0,
    YawRange = 4
  })
end
function LuaHook_TransitionHH()
  game.FX.SubmitEffect({
    EffectName = "FSE_sway_KeepAlive_Mild",
    Duration = 2,
    TweenInTime = 0.35,
    TweenOutTime = 1
  })
end
function LuaHook_CrusherDeathEarlyFade()
  timer.StartLevelTimer(0.01, function()
    UICALLS.UI_Event_Fade_To_Black(0.5)
  end)
end
function LuaHook_SnakeBellyEnterFadeOut()
  UICALLS.UI_Event_Fade_To_Black(0.2)
end
function LuaHook_SnakeBellyExitFadeOut()
  UICALLS.UI_Event_Fade_To_Black(0.2)
  local snakebelly = game.FindLevel("Cal800_SnakeBelly")
  snakebelly:CallScript("FadeToBlack")
end
function LuaHook_AlfheimTendril180()
  local playerPos = player:GetWorldPosition()
  if game.World.IsInsideCameraZone(playerPos, "CamZone_TendrilChop_First") then
    game.Camera.Recenter({
      TimeStart = 0,
      TimeDuration = 3,
      YawRange = -1,
      TriggerLeft = -166,
      TriggerRight = -166,
      ReturnLeft = -166,
      ReturnRight = -166,
      PitchRange = -1,
      ReturnDown = 4,
      ReturnUp = 4,
      RotationSpace = 1
    })
  elseif game.World.IsInsideCameraZone(playerPos, "CamZone_TendrilChop_Second") then
    game.Camera.Recenter({
      TimeStart = 0,
      TimeDuration = 3,
      YawRange = -1,
      TriggerLeft = -72,
      TriggerRight = -72,
      ReturnLeft = -72,
      ReturnRight = -72,
      PitchRange = -1,
      ReturnDown = 4,
      ReturnUp = 4,
      RotationSpace = 1
    })
  end
end
function LuaHook_csBoatEnterOverrideCameraNoMimir()
  local overrideCsCam
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_BoatOverride_Close*") then
    if player:HasMarker("Left") then
      overrideCsCam = {
        Animation = "navBoatEnterPushOffL_closeVer",
        IgnoreCollision = 1,
        TweenIn = {
          Time = 1,
          EaseIn = 1,
          EaseOut = 1
        },
        TweenOut = {
          Time = 1.2,
          EaseIn = 1,
          EaseOut = 1
        },
        Priority = 1002,
        SynchJoint = "camJoint"
      }
      game.Camera.StartCamera(overrideCsCam)
    elseif player:HasMarker("Right") then
      overrideCsCam = {
        Animation = "navBoatEnterPushOffR_closeVer",
        IgnoreCollision = 1,
        TweenIn = {
          Time = 1,
          EaseIn = 1,
          EaseOut = 1
        },
        TweenOut = {
          Time = 1.2,
          EaseIn = 1,
          EaseOut = 1
        },
        Priority = 1002,
        SynchJoint = "camJoint"
      }
      game.Camera.StartCamera(overrideCsCam)
    end
  end
end
function LuaHook_csBoatEnterOverrideCameraWithMimir()
  local overrideCsCam
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_BoatOverride_Close*") then
    if player:HasMarker("Left") then
      overrideCsCam = {
        Animation = "navBoatEnterPushOffLMimir_closeVer",
        IgnoreCollision = 1,
        On = 0,
        Off = 0.65,
        TweenIn = {
          Time = 1,
          EaseIn = 1,
          EaseOut = 1
        },
        TweenOut = {
          Time = 1.2,
          EaseIn = 1,
          EaseOut = 1
        },
        Priority = 1002,
        SynchJoint = "camJoint"
      }
      game.Camera.StartCamera(overrideCsCam)
    elseif player:HasMarker("Right") then
      overrideCsCam = {
        Animation = "navBoatEnterPushOffRMimir_closeVer",
        IgnoreCollision = 1,
        On = 0,
        Off = 0.65,
        TweenIn = {
          Time = 1,
          EaseIn = 1,
          EaseOut = 1
        },
        TweenOut = {
          Time = 1.2,
          EaseIn = 1,
          EaseOut = 1
        },
        Priority = 1002,
        SynchJoint = "camJoint"
      }
      game.Camera.StartCamera(overrideCsCam)
    end
  end
end
function LuaHook_DeepSnowDeathCamera()
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_DeepSnowDeathZone*") then
    local overrideDeathCsCam = {
      Animation = "DeathF0_deepSnow",
      On = 0,
      Off = 1,
      TweenIn = {
        Time = 0.8,
        EaseIn = 1,
        EaseOut = 1
      },
      TweenOut = {
        Time = 0.5,
        EaseIn = 1,
        EaseOut = 1
      },
      SynchJoint = "camJoint",
      Priority = 1010
    }
    game.Camera.StartCamera(overrideDeathCsCam)
  end
end
return profile.WrapLibrary({
  OnScriptLoaded = OnScriptLoaded,
  OnStart = OnStart,
  OnUpdate = OnUpdate,
  CameraCriticalHealth = CameraCriticalHealth,
  DisableUIElements = DisableUIElements,
  isEnemyInTable = isEnemyInTable
})
