local CAMSEQ = require("camera.camerasequencer_withstages")
local sequencedmove
local Action_TiltAndPitch = {
  Adjustment = {
    TiltUp = 8,
    TiltDown = 8,
    ["OrbitConstraint.ElevationMaxUp"] = 8,
    ["OrbitConstraint.ElevationMaxDown"] = 8,
    ["Position.Y"] = 1.53
  }
}
local Action_PullOut = {
  Adjustment = {
    ["OrbitConstraint.RotationLeft"] = -125,
    ["OrbitConstraint.RotationRight"] = -125,
    Distance = 2.4,
    fov = 84,
    PanLeft = -8,
    PanRight = -8
  }
}
local Action_StartTiltingDown = {
  Adjustment = {TiltUp = 3, TiltDown = 3}
}
local Action_StepOver = {
  Adjustment = {
    ["Position.X"] = 1.12
  }
}
local ModifyCameraConstraint = function(camera)
  local orbitrotation = game.Camera.GetOrbitRotation()
  camera.OrbitConstraint.RotationLeft = orbitrotation
  camera.OrbitConstraint.RotationRight = orbitrotation
end
local Action_LookAtKidV2 = {
  Adjustment = {
    ["Position.X"] = 0.38,
    ["Position.Y"] = 1.58,
    Distance = 1.21,
    TiltUp = 0,
    TiltDown = 0,
    ["OrbitConstraint.ElevationMaxDown"] = -3,
    ["OrbitConstraint.ElevationMaxUp"] = -3,
    ["OrbitConstraint.RotationLeft"] = -129,
    ["OrbitConstraint.RotationRight"] = -129,
    FStop = 8,
    FocusDistance = 3
  }
}
local Action_SlowZoom = {
  Adjustment = {fov = 65}
}
function OnScriptLoaded(level, camera)
end
function OnStart(level, camera)
  ModifyCameraConstraint(camera)
  sequencedmove = CAMSEQ.CameraSequencerWithStages.New(camera)
  sequencedmove:CreateStage("Random")
  local offset = -0.5
  sequencedmove:AddToStage("Random", Action_TiltAndPitch, 4.8, 1.7 + offset, "Action_TiltAndPitch")
  sequencedmove:AddToStage("Random", Action_PullOut, 3.4, 2.2 + offset, "Action_PullOut")
  sequencedmove:AddToStage("Random", Action_StepOver, 2.8, 2.4 + offset, "Action_StepOver")
  sequencedmove:AddToStage("Random", Action_StartTiltingDown, 1.5, 6.9 + offset, "Action_StartTiltingDown")
  sequencedmove:AddToStage("Random", Action_SlowZoom, 3, 7.9 + offset, "Action_SlowZoom")
  sequencedmove:AddToStage("Random", Action_LookAtKidV2, 4.1, 7.9 + offset, "Action_LookAtKidV2")
  sequencedmove:Start(camera)
end
function OnUpdate(level, camera)
  sequencedmove:Update(level, camera)
end
