local CAMSEQ = require("camera.camerasequencer")
local sequencedmove
local Action_WidenUp = {
  Adjustment = {fov = 90}
}
local Action_TiltUp = {
  Adjustment = {TiltUp = 15.6, TiltDown = 15.6}
}
local Action_ZoomIn = {
  Adjustment = {
    fov = 54,
    TiltUp = 27,
    TiltDown = 27
  }
}
local Action_LookAtSon = {
  Adjustment = {
    Yaw = -24,
    TiltUp = -16.25,
    TiltDown = -16.25,
    Pitch = 11.7,
    Roll = 0.5,
    ["Position.X"] = 0.32
  }
}
function OnScriptLoaded(level, camera)
  camera.Distance = camera.initial.Distance
  camera.AngleOfView = camera.initial.AngleOfView
  camera.Yaw = camera.initial.Yaw
  camera.Pitch = camera.initial.Pitch
end
function OnStart(level, camera)
  sequencedmove = CAMSEQ.CameraSequencer.New(camera)
  sequencedmove:AddToSequence(Action_WidenUp, 1.2, 0.2, "Action_WidenUp")
  sequencedmove:AddToSequence(Action_TiltUp, 1.4, 0.2, "Action_TiltUp")
  sequencedmove:AddToSequence(Action_ZoomIn, 2.3, 3.8, "Action_ZoomIn")
  sequencedmove:AddToSequence(Action_LookAtSon, 1.8, 7.3, "Action_LookAtSon")
  sequencedmove:Start(camera)
end
function OnUpdate(level, camera)
  sequencedmove:Update(level, camera)
end
