local CAMSEQ = require("camera.camerasequencer_withstages")
local sequencedmove
local Action_Swing = {
  Adjustment = {
    ["OrbitConstraint.RotationLeft"] = -180,
    ["OrbitConstraint.RotationRight"] = -180,
    ["OrbitConstraint.ElevationMaxUp"] = -5,
    ["OrbitConstraint.ElevationMaxDown"] = -5
  }
}
local Action_OnlyTilt = {
  Adjustment = {
    TiltUp = 92,
    TiltDown = 92,
    ["OrbitConstraint.ElevationMaxUp"] = -12,
    ["OrbitConstraint.ElevationMaxDown"] = -12,
    Roll = 2,
    PanLeft = -18,
    PanRight = -18
  }
}
local Action_HammerTimeFov = {
  Adjustment = {fov = 85}
}
local Action_CloserLookAtBuckle = {
  Adjustment = {fov = 61.9}
}
local Action_Wobble = {}
local Action_SlopZoomTilt = {}
local Action_Resettle = {
  Adjustment = {
    ["OrbitConstraint.RotationLeft"] = -232,
    ["OrbitConstraint.RotationRight"] = -232,
    ["OrbitConstraint.ElevationMaxUp"] = -8,
    ["OrbitConstraint.ElevationMaxDown"] = -8,
    PanLeft = 0,
    PanRight = 0,
    TiltUp = 0,
    TiltDown = 0,
    fov = 78.56,
    Distance = 2.13
  }
}
local ModifyCameraConstraint = function(camera)
  local orbitrotation = game.Camera.GetOrbitRotation()
  camera.OrbitConstraint.RotationLeft = orbitrotation
  camera.OrbitConstraint.RotationRight = orbitrotation
end
local AdjustForPlayersWorldRotation = function()
  local orbitRotation = game.Camera.GetOrbitRotation()
  if 0 < orbitRotation and orbitRotation < 180 then
    Action_Swing.Adjustment["OrbitConstraint.RotationLeft"] = 180
    Action_Swing.Adjustment["OrbitConstraint.RotationRight"] = 180
    Action_Resettle.Adjustment["OrbitConstraint.RotationLeft"] = 130.112
    Action_Resettle.Adjustment["OrbitConstraint.RotationRight"] = 130.112
  end
end
function OnScriptLoaded(level, camera)
end
function OnStart(level, camera)
  ModifyCameraConstraint(camera)
  AdjustForPlayersWorldRotation()
  sequencedmove = CAMSEQ.CameraSequencerWithStages.New(camera)
  sequencedmove:CreateStage("Random")
  sequencedmove:AddToStage("Random", Action_Wobble, 12, 0, "Action_Wobble")
  sequencedmove:AddToStage("Random", Action_Swing, 3.3, 0, "Action_Swing")
  sequencedmove:AddToStage("Random", Action_OnlyTilt, 2.6, 1.4, "Action_OnlyTilt")
  sequencedmove:AddToStage("Random", Action_SlopZoomTilt, 0, 1.4, "Action_SlopZoomTilt")
  sequencedmove:AddToStage("Random", Action_HammerTimeFov, 3, 1.8, "Action_HammerTimeFov")
  sequencedmove:AddToStage("Random", Action_CloserLookAtBuckle, 3, 5.2, "Action_CloserLookAtBuckle")
  sequencedmove:AddToStage("Random", Action_Resettle, 3.6, 9.75, "Action_Resettle")
  sequencedmove:Start(camera)
end
function OnUpdate(level, camera)
  sequencedmove:Update(level, camera)
end
