local CAMSEQ = require("camera.camerasequencer_withstages")
local sequencedmove, player, hammerState
local PushState = {
  NotPushing = 0,
  BarelyPushing = 1,
  Early = 2,
  Mid = 3,
  OneMorePush = 4
}
local Action_OOF_RandomPush_01 = {
  Adjustment = {
    ["Position.X"] = -0.2,
    ["Position.Y"] = 0.2,
    ["Position.Y"] = 0.3,
    Yaw = -21,
    Pitch = -41,
    Distance = 1.5,
    fov = 82,
    TiltUp = 24.8,
    TiltDown = 24.8
  }
}
local Action_OOF_Random2 = {
  Adjustment = {
    ["Position.X"] = 0.3,
    ["Position.Y"] = 1,
    Yaw = 72,
    Pitch = 2,
    Distance = 0.7,
    fov = 82,
    TiltUp = 3.56,
    TiltDown = 3.56
  }
}
function OnScriptLoaded(level, camera)
  player = game.Player.FindPlayer()
  hammerState = PushState.NotPushing
end
function OnStart(level, camera)
  sequencedmove = CAMSEQ.CameraSequencerWithStages.New(camera)
  sequencedmove:CreateStage("PushIn")
  sequencedmove:CreateStage("Random")
  sequencedmove:AddToStage("PushIn", Action_OOF_RandomPush_01, 5, 5, "Action_OOF_RandomPush_01")
  sequencedmove:AddToStage("Random", Action_OOF_Random2, 5, 6.8, "Action_OOF_Random2")
  sequencedmove:Start(camera)
end
local PrintHammerState = function(percentage)
  for name, value in pairs(PushState) do
    if value == hammerState then
      print("hammerState is:", name, " move percentage is: ", percentage)
    end
  end
end
local CheckHammerPushPercentage = function()
  if player:IsPlayingMove("MOV_HammerFallPush") then
    local movepercentage = player:GetActiveMovePercent()
    if 0.9 < movepercentage then
      hammerState = PushState.OneMorePush
    elseif 0.55 < movepercentage then
      hammerState = PushState.Mid
    elseif 0.2 <= movepercentage then
      hammerState = PushState.Early
    elseif movepercentage == 0 then
      hammerState = PushState.NotPushing
    else
      hammerState = PushState.BarelyPushing
    end
    PrintHammerState(movepercentage)
  else
    hammerState = PushState.NotPushing
  end
end
function OnUpdate(level, camera)
  sequencedmove:Update(level, camera)
  CheckHammerPushPercentage()
end
