local CAMSEQ = require("camera.camerasequencer_withstages")
local sequencedmove
local Action_OOF_RandomPush_01 = {
  Adjustment = {
    ["Position.X"] = -0.2,
    ["Position.Y"] = 0.2,
    ["Position.Y"] = 0.3,
    Yaw = -21,
    Pitch = -41,
    Distance = 1.5,
    fov = 82,
    TiltUp = 24.8,
    TiltDown = 24.8
  }
}
local Action_OOF_Random2 = {
  Adjustment = {
    ["Position.X"] = 0.3,
    ["Position.Y"] = 1,
    Yaw = 72,
    Pitch = 2,
    Distance = 0.7,
    fov = 82,
    TiltUp = 3.56,
    TiltDown = 3.56
  }
}
local Action_OOF_DistanceFoVMix = {
  Adjustment = {
    ["Position.Y"] = 0.5,
    Distance = 2.288,
    Pitch = -4,
    FStop = 2.4
  }
}
function OnScriptLoaded(level, camera)
end
function OnStart(level, camera)
  sequencedmove = CAMSEQ.CameraSequencerWithStages.New(camera)
  sequencedmove:CreateStage("second")
  sequencedmove:CreateStage("first")
  sequencedmove:AddToStage("first", Action_OOF_RandomPush_01, 1, 0, "Action_OOF_RandomPush_01")
  sequencedmove:AddToStage("second", Action_OOF_Random2, 1, 3, "Action_OOF_Random2")
  sequencedmove:AddToStage("second", Action_OOF_DistanceFoVMix, 1, 0, "Action_OOF_DistanceFoVMix")
  sequencedmove:Start(camera)
end
function OnUpdate(level, camera)
  sequencedmove:UpdateWithPrints(level, camera)
end
