local EL = require("camera.EasingLibrary")
local bTriggered = false
local tbl_EaseTable = {}
local tbl_Snapshot = {}
local cam
local duration = 3
local ReturnBack = function()
  EL.SetStartValue(cam, tbl_Snapshot)
  EL.SetProgress(tbl_Snapshot, true)
end
local ResetTheLoop = function()
  bTriggered = false
end
function OnScriptLoaded(level, camera)
  cam = camera
  bTriggered = false
  EL.SetupEaseTable(tbl_EaseTable)
  camera.Distance = camera.initial.Distance
  camera.AngleOfView = camera.initial.AngleOfView
  EL.SetBlendValue(camera, tbl_EaseTable, "Distance", 8)
  EL.SetBlendValue(camera, tbl_EaseTable, "FStop", 1.8)
  EL.SetDuration(tbl_EaseTable, duration)
  EL.SetCallback(tbl_EaseTable, ReturnBack)
end
function OnUpdate(level, camera)
  if bTriggered == false then
    EL.CopyBlendTable(tbl_EaseTable, tbl_Snapshot)
    EL.TakeSnapshot(cam, tbl_Snapshot)
    EL.SetCallback(tbl_Snapshot, ResetTheLoop)
    EL.SetProgress(tbl_EaseTable, true)
    bTriggered = true
  end
  EL.EaseEverything(level, tbl_EaseTable, camera, "InAndOut", "Quad")
  EL.EaseEverything(level, tbl_Snapshot, camera, "InAndOut", "Quad")
end
