local EL = require("camera.EasingLibrary")
local CDBGL = require("camera.CameraDebugLibrary")
local bTriggered = false
local tbl_EaseTable = {}
local tbl_Snapshot = {}
local cam
local duration = 8
function ReturnBack()
  EL.SetStartValue(cam, tbl_Snapshot)
  EL.SetProgress(tbl_Snapshot, true)
end
function OnScriptLoaded(level, camera)
  cam = camera
  EL.SetupEaseTable(tbl_EaseTable)
  EL.SetBlendValue(camera, tbl_EaseTable, "Distance", 12)
  EL.SetDuration(tbl_EaseTable, duration)
  EL.SetCallback(tbl_EaseTable, ReturnBack)
  CDBGL.CameraDebugLibraryInit()
end
function OnUpdate(level, camera)
  CDBGL.CheckButtonState()
  if CDBGL.IsTriangleReleased() and not bTriggered then
    EL.CopyBlendTable(tbl_EaseTable, tbl_Snapshot)
    EL.TakeSnapshot(cam, tbl_Snapshot)
    EL.SetCallback(tbl_Snapshot, nil)
    EL.SetProgress(tbl_EaseTable, true)
    bTriggered = true
  end
  EL.EaseEverything(level, tbl_EaseTable, camera, "InAndOut", "Quad")
  EL.EaseEverything(level, tbl_Snapshot, camera, "InAndOut", "Quad")
  CDBGL.UpdateButtonState()
end
function OnTeardown(level, camera)
end
