local DL = require("design.DesignerLibrary")
local timers = require("level.timer")
local color = require("core.color")
local parent, thisObj, player, axeObject, concussionParamsHero, concussionParamsAI
local triggerDelay = 1
local triggerReady = false
local triggerDistanceHero = 1.25
local triggerDistanceAxe = 2
local mineDetonated = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  parent = obj:GetEffectObjectCreator()
  for gameobj in game.Player.FindPlayer():IterateActiveWeapons() do
    if gameobj.Weapon:GetName() == "axe00" then
      axeObject = gameobj.Weapon
    end
  end
  timers.StartLevelTimer(triggerDelay, ActivateMine)
end
function OnUpdate(level, obj)
  local distHero = DL.GetDistanceBetweenTwoObjects(thisObj, player)
  engine.DrawText2D("DistHero: " .. distHero, 200, 200, color.yellow)
  if distHero <= triggerDistanceHero and triggerReady == true and mineDetonated == false then
    ExplodeMine()
  end
  local distAxe = DL.GetDistanceBetweenTwoObjects(thisObj, axeObject)
  if distAxe <= triggerDistanceAxe and axeObject.ThrowOutStatus == tweaks.tThrowOutStatus.eThrownWeaponStatus.kTOSStuck and mineDetonated == false then
    ExplodeMineWithAxe()
  end
end
function ActivateMine()
  if triggerReady == false then
    triggerReady = true
  end
end
function ExplodeMine()
  mineDetonated = true
  local mineLocation = thisObj:GetWorldPosition()
  concussionParamsHero = {
    Tweak = "CNC_FIREMODE_PROXIMITY_MINE_EXPLODE",
    WorldLocation = mineLocation,
    GameObject = parent,
    EnemyId = parent:GetID()
  }
  game.Combat.PlayConcussion(concussionParamsHero)
  CleanUp()
end
function ExplodeMineWithAxe()
  mineDetonated = true
  local mineLocation = thisObj:GetWorldPosition()
  concussionParamsAI = {
    Tweak = "CNC_FIREMODE_PROXIMITY_MINE_EXPLODE_HIT_AI",
    WorldLocation = mineLocation,
    GameObject = player,
    EnemyId = player:GetID()
  }
  game.Combat.PlayConcussion(concussionParamsAI)
  CleanUp()
end
function CleanUp()
  thisObj:Destroy()
end
