local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local player, baldur, hazardTimer, hazardFX, concussionParams
local concussionFired = false
local concussionRepeatTimer
local concussionCount = 0
local hazardHealth = 0
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  baldur = LD.GetSingleAIByMarker("baldur00")
end
function OnStart(level, obj)
  concussionParams = {
    Tweak = "CNC_ICEMODE_LEAPSTOMP_RADIAL_HAZARD_LUA",
    WorldLocation = obj:GetWorldPosition(),
    GameObject = obj,
    EnemyId = baldur:GetID()
  }
  concussionCount = 30
  hazardFX = game.FX.Spawn("Baldur_IceMode_LeapStomp_Hazard", nil, {
    AutoDelete = true,
    EffectCreator = obj,
    Scale = 2.5
  })
  hazardFX:SetWorldPosition(obj:GetWorldPosition())
  hazardHealth = 2
end
function OnUpdate(level, obj)
  if concussionFired == false and 0 < concussionCount then
    game.Combat.PlayConcussion(concussionParams)
    concussionRepeatTimer = timers.StartLevelTimer(0.5, function()
      concussionFired = false
    end)
    concussionCount = concussionCount - 1
    concussionFired = true
  elseif concussionCount == 0 then
    CleanUp(obj)
  end
  if player:IsPlayingMove("MOV_CSBaldurUppercutToBeatdown_Enter") then
    concussionCount = 0
    CleanUp(obj)
  end
end
function OnHitByConcussion(level, obj, concussionOwner, hitFlags, context)
  print("Hit")
  print(context)
  local fireBlast = engine.Hash("FIRE_BLAST")
  if fireBlast == context and concussionOwner == player then
    hazardHealth = hazardHealth - 1
    if hazardHealth == 0 then
      CleanUp(obj)
    end
  end
end
function CleanUp(obj)
  print("Removing Hazard")
  if hazardTimer ~= nil then
    hazardTimer:Stop()
  end
  if concussionRepeatTimer ~= nil then
    concussionRepeatTimer:Stop()
  end
  if hazardFX ~= nil then
    hazardFX:Remove()
  end
  if obj ~= nil then
    obj:Destroy()
  end
end
