local statemachine = require("ai.statemachine")
local tablex = require("core.tablex")
local picklelib = require("core.pickle")
local DL = require("design.DesignerLibrary")
local locomotion = require("creature.locomotion")
locomotion.Install()
constants = {}
global = {}
global.target = nil
global.navData = {}
global.navData.stopDistance = 0.5
global.navData.startDistance = 1
global.navData.isStrafing = true
global.navData.navSpeedJog = 0
global.navData.navSpeedWalk = 0
global.navBank = "NB_OffensiveBank"
global.awarenessBroadcastRange = 100
global.awarenessReceiveRange = 30
global.fightConstants = {}
global.fightConstants.FirstRadiusMinDistance = 6
global.fightConstants.FirstRadiusMaxDistance = 8
global.fightConstants.SecondRadiusMinDistance = 10
global.fightConstants.SecondRadiusMaxDistance = 15
global.fightConstants.AggressiveRange = 7
global.fightConstants.DesiredRadius = 1
global.fightConstants.MinCostSavingsToSwitch = 0.2
global.fightConstants.MinRepositionTime = 2
global.fightConstants.MinRepositionTime = 6
global.aggroState = ""
global.DTree = "DTR_BALDURDRAGON00_OFFENSIVE"
global.targetParams = "FIND_TARGET_PARAMETERS_COMBAT_KRATOS_ONLY"
function detectAggroStateFromSpawnMove(ai)
  local spawnContext = ai:GetContext()
  if DL.CheckCreatureContext(spawnContext, "INCOMBAT") then
    global.aggroState = "INCOMBAT"
  elseif DL.CheckCreatureContext(spawnContext, "UNAWARE") then
    global.aggroState = "UNAWARE"
  elseif DL.CheckCreatureContext(spawnContext, "NONHOSTILE") then
    global.aggroState = "NONHOSTILE"
  elseif DL.CheckCreatureContext(spawnContext, "PASSIVE") then
    global.aggroState = "PASSIVE"
  end
end
function OnAIPostSpawn(ai)
  global.navData.navSpeedWalk = ai:LookupFloatConstant("NAV_SPEED_WALK")
  global.navData.navSpeedJog = ai:LookupFloatConstant("NAV_SPEED_JOG")
  detectAggroStateFromSpawnMove(ai)
  ai:HideJoint(ai:GetJointIndex("JOYoke1"))
  ai:HideJoint(ai:GetJointIndex("JOChainAttachGround1"))
end
function drawDebugTable(debugTable)
  table.insert(debugTable, {"--", "--"})
  table.insert(debugTable, {
    "State String:",
    global.aggroState
  })
  table.insert(debugTable, {
    "Walk Speed",
    global.navData.navSpeedWalk
  })
  table.insert(debugTable, {
    "Jog Speed",
    global.navData.navSpeedJog
  })
  table.insert(debugTable, {"--", "--"})
  for k, v in pairs(global.fightConstants) do
    table.insert(debugTable, {
      "Constants." .. k,
      v
    })
  end
  table.insert(debugTable, {"--", "--"})
  for k, v in tablex.SortedPairs(global.LeashDecision) do
    table.insert(debugTable, {
      "Leash." .. k,
      v
    })
  end
  table.insert(debugTable, {"--", "--"})
  table.insert(debugTable, {
    "Use Leashing: " .. tostring(global.useLeashing)
  })
  engine.DrawDebugTable(debugTable)
end
function OnAIUpdate(ai)
  locomotion.CreateDrivers(ai)
  statemachine.UpdateAll(state_machines, ai, global, constants)
  local debugTable = statemachine.GetDebugTable(state_machines, ai)
  if debugTable then
    drawDebugTable(debugTable)
  end
end
state_machines = {
  require("baldurdragon00.leashBrain"),
  require("baldurdragon00.brain")
}
function _G.OnAICreateLuaState(ai)
  statemachine.StartAll(ai, state_machines, ai, global, constants)
  _G.OnAICreateLuaState = nil
end
picklelib.Install()
function Pickle(GO)
  return {
    global = global
  }
end
function Unpickle(GO, t)
  global = t.global
end
