local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, emitterDecal, emitterIceBlast, emitterDecalTimer, emitterIceBlastTimer
local decalLifeTime = 2
local iceBlastLifeTime = 0.25
function OnScriptLoaded(level, obj)
  thisObj = obj
  if thisObj ~= nil then
    emitterDecal = thisObj:FindSingleSoundEmitterByName("SNDDecal_Ice_ground")
    emitterIceBlast = thisObj:FindSingleSoundEmitterByName("SNDBandit_IceBlast_Exit_linkJoint")
    if emitterDecal ~= nil then
      LD.PlaySound(emitterDecal, "SND_CHR_Helwalker_Ice_Ground_FX_LP")
      emitterDecalTimer = StartLevelTimer(decalLifeTime, OnDecalTimerDone)
      emitterDecalTimer:Restart()
    else
      print("FIX ME: SCRIPT CANNOT FIND EMITTER SNDDecal_Ice_ground")
    end
    if emitterIceBlast ~= nil then
      LD.PlaySound(emitterIceBlast, "SND_CHR_Helwalker_Ice_Blast_Wave_LP")
      emitterIceBlastTimer = StartLevelTimer(iceBlastLifeTime, OnIceBlastTimerDone)
      emitterIceBlastTimer:Restart()
    else
      print("FIX ME: SCRIPT CANNOT FIND EMITTER SNDBandit_IceBlast_Exit_linkJoint")
    end
  end
  game.SubObject.Sleep(obj)
end
function OnDecalTimerDone()
  LD.StopSound(emitterDecal, "SND_CHR_Helwalker_Ice_Ground_FX_LP")
end
function OnIceBlastTimerDone()
  LD.StopSound(emitterIceBlast, "SND_CHR_Helwalker_Ice_Blast_Wave_LP")
end
