local statemachine = require("ai.statemachine")
local positioning = require("behavior.positioning")
local EquipmentBrain = statemachine.StateMachine.New("Bandit00_Equipment")
local DEFAULTEQUIPMENT = EquipmentBrain:State("DefaultEquipment")
local SHIELDED = EquipmentBrain:State("Shielded")
local NOTHING = EquipmentBrain:State("Nothing")
function EquipmentBrain:OnBrainInit(ai, global, constants)
  positioning.AddStandardPositioningZone("Shielded", constants.fightPosDataShielded, constants.fightKnowledgeInputs)
  positioning.AddStandardPositioningZone("HeroSlowed", constants.fightPosDataHeroSlowed, constants.fightKnowledgeInputs)
end
function SHIELDED:Enter(ai, global, constants)
  global.currentEquipmentFightConstants = constants.fightConstantsShield
  ai:SetNavBank(constants.ShieldBank)
  ai:SetStance(constants.ShieldStance)
  global.navBank = constants.ShieldBank
  global.currentEquipmentNavBank = constants.ShieldBank
  global.currentEquipmentDTree = constants.ShieldDTree
  global.DTree = constants.ShieldDTree
  if global.target ~= nil and global.target:PickupIsAcquired("Debuff_Hero_Frost") then
    constants.CurrentZoneSet = constants.HeroSlowedZoneSet
  else
    constants.CurrentZoneSet = constants.ShieldZoneSet
  end
end
function SHIELDED:Update(ai, global, constants)
  if global.target ~= nil and global.target:PickupIsAcquired("Debuff_Hero_Frost") then
    constants.CurrentZoneSet = constants.HeroSlowedZoneSet
  else
    constants.CurrentZoneSet = constants.ShieldZoneSet
  end
end
function SHIELDED.Hooks:LuaHook_Shield_MeleeFrost(ai, global, constants)
  if not ai:PickupIsAcquired("GruntShieldFrostState") then
    ai:PickupAcquire("GruntShieldFrostState")
    ai:PickupSetStage("GruntShieldFrostState", 0)
  end
  if ai:PickupIsActive("GruntShieldFrostState") and ai:PickupGetStage("GruntShieldFrostState") <= 3 and ai:PickupGetStage("GruntShieldFrostState") < 3 then
    ai:PickupIncrementStage("GruntShieldFrostState")
  end
end
function DEFAULTEQUIPMENT:Enter(ai, global, constants)
  global.DTree = constants.DefaultDTree
  global.currentEquipmentNavBank = constants.DefaultNavBank
  global.navBank = constants.DefaultNavBank
  ai:SetStance(constants.DefaultStance)
  ai:SetNavBank(constants.DefaultNavBank)
  if global.target ~= nil and global.target:PickupIsAcquired("Debuff_Hero_Frost") then
    constants.CurrentZoneSet = constants.HeroSlowedZoneSet
    ai:SetAggressivePriority(4)
  else
    constants.CurrentZoneSet = constants.DefaultZoneSet
    ai:RevertAggressivePriority()
  end
end
function DEFAULTEQUIPMENT:Update(ai, global, constants)
  if not ai:PickupIsAcquired("GruntSword") and ai:IsInNavigationMove() then
    ai:TriggerMoveEvent("kLEUnsheatheSword")
  end
  if global.target ~= nil and global.target:PickupIsAcquired("Debuff_Hero_Frost") then
    constants.CurrentZoneSet = constants.HeroSlowedZoneSet
    ai:SetAggressivePriority(4)
  else
    constants.CurrentZoneSet = constants.DefaultZoneSet
    ai:RevertAggressivePriority()
  end
end
function EquipmentBrain:SelectNextState(ai, global, constants)
  if global.aggroState ~= "INCOMBAT" then
    return NOTHING
  end
  if ai:PickupIsAcquired("GruntShield") then
    return SHIELDED
  else
    return DEFAULTEQUIPMENT
  end
end
return EquipmentBrain
