local statemachine = require("ai.statemachine")
local poilib = require("behavior.poi")
local FWP = require("behavior.followWayPoints")
local DL = require("design.DesignerLibrary")
local locomotion = require("creature.locomotion")
local lookAtConsts = require("game.lookAtConsts")
locomotion.Install()
local lookAtOverride
local Brain = statemachine.StateMachine.New("Brok00")
local Idle = Brain:State("Idle")
_G.thisLookAtEntry = nil
_G.lookAtPriorityOverrides = {}
constants = {}
global = {}
local breathEffect
function SetupPOIStates(POIState)
  local poiSearchParameters_Auto = {
    FindArgs = {
      "BROK",
      "AUTO",
      MatchAll = true
    },
    Filter = function(poi, ads, ai, global, constants)
      return true
    end
  }
  function POIState:GetSearchParameters(ai, global, constants)
    local parameters = {}
    table.insert(parameters, poiSearchParameters_Auto)
    return parameters
  end
  return {
    SetupPOIStates = SetupPOIStates
  }
end
local UsePOI = poilib.NewPOIState(Brain, "UsePOI")
poilib.AllowPOIFromStates(Idle)
SetupPOIStates(UsePOI)
function Idle:Update(ai, global, constants)
  if global.LTW_Destinations ~= nil then
    self.finalPosition, self.motionParams = FWP.CalculateLeadTheWayPosition(ai, global, constants, game.Player.FindPlayer(), self.motionParams)
    if global.LTW_DefaultParameters.HoldEndPosition == false and global.LTW_DestinationIndex == #global.LTW_Destinations and global.LTW_Destinations[global.LTW_DestinationIndex].WorldPosition:Distance(ai.WorldPosition) < global.LTW_DefaultParameters.DefaultDistanceToActivateNextPoint then
      global.LTW_Destinations = nil
    end
  else
    self.motionParams.Position = ai.WorldPosition
    self.motionParams.ApproachSpeed = 4
    self.motionParams.StopDistance = 0.75
    self.motionParams.Strafe = false
  end
  DL.RotationSpeedAugmentLogic(ai, global, self.motionParams, self.finalPosition)
  locomotion.SetActuator(ai, {
    Destination = self.motionParams.Position,
    Facing = self.motionParams.Facing,
    Strafe = self.motionParams.Strafe,
    Speed = self.motionParams.ApproachSpeed,
    StopDistance = self.motionParams.StopDistance,
    StartDistance = self.motionParams.StartDistance
  })
end
function Idle:OnBrainInit(ai, global, constants)
  self.motionParams = {}
  self.finalPosition = nil
end
function OnAIPostSpawn(ai)
  if breathEffect == nil then
    breathEffect = game.FX.Spawn("FX_kratos_Breath", nil, {
      Joint = "JOJaw1",
      GameObject = ai,
      DeleteWithCreature = true
    })
    breathEffect:SetAnimFloatChannelDriver(ai, "sliderfloatchannels._breathefxintensity")
  end
  ai:SetAIDeathCallback(ai, "DeathBehavior")
  _G.thisLookAtEntry = game.AddGlobalLookAtTarget(ai, engine.Vector.New(0, 1.3, 0), lookAtConsts.TargetType.FriendlyAI)
  _G.lookAtPriorityOverrides.FriendlyAI = ai:AddLookAtPriorityOverride(lookAtConsts.TargetType.FriendlyAI, lookAtConsts.Priority.Medium)
  _G.lookAtPriorityOverrides.Hero = ai:AddLookAtPriorityOverride(lookAtConsts.TargetType.Hero, lookAtConsts.Priority.High)
  _G.lookAtPriorityOverrides.kid = ai:AddLookAtPriorityOverride(lookAtConsts.TargetType.Kid, lookAtConsts.Priority.Ignore)
end
function OnAIUpdate(ai)
  locomotion.CreateDrivers(ai)
  statemachine.UpdateAll(creature_states, ai, global, constants)
  local debugTable = statemachine.GetDebugTable(creature_states, ai)
  if debugTable then
    engine.DrawDebugTable(debugTable)
  end
end
creature_states = {Brain}
function _G.OnAICreateLuaState(ai)
  statemachine.StartAll(ai, creature_states, ai, global, constants)
  _G.OnAICreateLuaState = nil
  FWP.RegisterWaypointCallback(ai, _G.global, constants)
end
function DeathBehavior(ai)
  if breathEffect ~= nil and breathEffect.Spawned then
    breathEffect:Remove()
    breathEffect = nil
  end
end
function Brain:SelectNextState(ai, global, constants)
  if poilib.IsPOIActive() then
    return UsePOI
  else
    return Idle
  end
end
function ForceLookAtTarget(ai, lookAtObj)
  lookAtOverride = lookAtObj
  game.ForceLookAtToObject(lookAtOverride)
end
function ClearForcedLookAt(lookAtObj)
  game.ClearForcedLookAtToObject()
end
