local statemachine = require("ai.statemachine")
local DL = require("design.DesignerLibrary")
local wander = require("behavior.wander")
local mock
local poilib = require("behavior.poi")
local Brain = statemachine.StateMachine.New("Deer00")
local NOTHING = Brain:State("Nothing")
local POI_WANDER = Brain:State("POI_Wander", wander.Wander)
function SetupPOIStates(POIState)
  local poiSearchParameters_Auto = {
    FindArgs = {
      "DEER00",
      "AUTO",
      MatchAll = true
    },
    Filter = function(poi, ads, ai, global, constants)
      return true
    end
  }
  function POIState:GetSearchParameters(ai, global, constants)
    local parameters = {}
    table.insert(parameters, poiSearchParameters_Auto)
    return parameters
  end
  return {
    SetupPOIStates = SetupPOIStates
  }
end
local UsePOI = poilib.NewPOIState(Brain, "UsePOI")
poilib.AllowPOIFromStates(POI_WANDER)
SetupPOIStates(UsePOI)
function POI_WANDER:init()
  self.ArrivalDistance = 2
  self.StopDistance = 1.5
  self.Radius = 15
  self.ApproachSpeed = 1.174
end
function POI_WANDER:Enter(ai, global, constants)
  DL.DebugPrint(ai, "POI_WANDER selected")
end
function POI_WANDER:Update(ai, global, constants)
  wander.Wander.Update(self, ai, global, constants)
  global.aggroState = "WANDER"
end
function Brain:SelectNextState(ai, global, constants)
  if poilib.IsPOIActive() then
    return UsePOI
  end
  return POI_WANDER
end
function NOTHING:Enter(ai, global, constants)
  DL.DebugPrint(ai, "NOTHING selected")
end
return Brain
