local picklelib = require("core.pickle")
local LD = require("design.LevelDesignLibrary")
constants = {}
global = {}
function OnAIPostSpawn(ai)
  ai:HideJoint(ai:GetJointIndex("CNrightWingPatch1"))
  ai:HideJoint(ai:GetJointIndex("CNrightWingPatch2"))
  ai:HideJoint(ai:GetJointIndex("CNleftWingPatch1"))
  ai:HideJoint(ai:GetJointIndex("CNleftWingPatch2"))
  ai:HideJoint(ai:GetJointIndex("CNunderBellyPatch5"))
  ai:HideJoint(ai:GetJointIndex("clothNode1"))
  ai:HideJoint(ai:GetJointIndex("clothNode2"))
  ai:HideJoint(ai:GetJointIndex("clothNode3"))
  ai:HideJoint(ai:GetJointIndex("clothNode4"))
  ai:HideJoint(ai:GetJointIndex("clothNode5"))
  ai:HideJoint(ai:GetJointIndex("clothNode6"))
  ai:HideJoint(ai:GetJointIndex("clothNode7"))
  ai:HideJoint(ai:GetJointIndex("CNwingCutClothPatch1"))
  ai:AddMarker("DragonMarker")
  global.target = game.Player.FindPlayer()
  ai:SetCombatTarget(global.target)
  ai:SetFocus(global.target)
end
function _G.OnAICreateLuaState(ai)
  _G.OnAICreateLuaState = nil
end
function LuaHook_Xpl200_PlayTakeOffWhoosh(ai)
  local level = game.FindLevel("Xpl100_HTTK")
  if level == nil then
    level = game.FindLevel("Xpl100_HTTK")
  end
  if level == nil then
    level = game.FindLevel("Xpl200_Funeral")
  end
  if level == nil then
    level = game.FindLevel("Xpl650_MasonTrailCave")
  end
  if level ~= nil then
    level:CallScript("LuaHook_PlayTakeOffWhoosh")
  end
end
picklelib.Install()
function Pickle(GO)
  return {
    global = global
  }
end
function Unpickle(GO, t)
  global = t.global
end
function LuaHook_Despawn(ai)
  ai:Destroy()
end
function LuaHook_CompleteQuest()
  local reginn = game.FindLevel("Xpl100_HTTK")
  local otr = game.FindLevel("Xpl200_Funeral")
  local fafnir = game.FindLevel("Xpl650_MasonTrailCave")
  if otr ~= nil then
    otr:CallScript("ReenableFastTravel")
    LD.CompleteQuest("Quest_WorldDragon_Otr_Objective_01_Return")
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Otr")
  elseif reginn ~= nil then
    LD.CompleteQuest("Quest_WorldDragon_Reginn_Objective_01_Return")
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Reginn")
  elseif fafnir ~= nil then
    LD.CompleteQuest("Quest_WorldDragon_Fafnir_Objective_01_Return")
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Fafnir")
  end
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_WorldDragon_Objective_01")
  if progress == 0 then
    game.QuestManager.StartQuest("Quest_WorldDragon_Parent")
    game.QuestManager.IncrementQuestProgress("Quest_WorldDragon_Objective_01", 1)
  elseif 0 < progress and progress < 3 then
    game.QuestManager.IncrementQuestProgress("Quest_WorldDragon_Objective_01", 1)
  end
  TrophyCheck()
  game.World.StoreCheckpoint()
end
function TrophyCheck()
  if game.QuestManager.GetQuestState("Quest_WorldDragon_Fafnir_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_WorldDragon_Reginn_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_WorldDragon_Otr_Parent") == "Complete" then
    AwardTrophy()
  end
end
function AwardTrophy()
  print("Trophy Awarded: Can't Hold Me Down")
  game.UnlockTrophy(22)
end
