local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
thisObj = nil
thisLevel = nil
player = nil
son = nil
startDestination = nil
previousDestination = nil
endDestination = nil
linePoints = {}
lineEffect = nil
lineEffectEnabled = false
lineCompleted = false
maxLifetime = 4
timeBetweenLines = 0.1
concussionFrequency = 1.25
concussionDelay = 0
attackLength = 12
timeLimit = 0
local groundDebugVectorOffset = engine.Vector.New(0, 1, 0)
local GOline, SNDLine
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  timeLimit = game.GetGameTime() + maxLifetime
  startDestination = obj.WorldPosition
  previousDestination = startDestination
  endDestination = LD.GetPointAlongLine(startDestination, thisObj.WorldPosition + thisObj:GetWorldForward() * attackLength, attackLength)
  GOline = thisObj:FindSingleGOByName("Shockwave")
  SNDLine = GOline:FindSingleSoundEmitterByName("SNDdraugrPowerArmShockwave00")
  GetNextConcussionLocation()
end
function GetNextConcussionLocation()
  if timeLimit < game.GetGameTime() then
    Cleanup()
    return
  end
  if lineEffect == nil and lineEffectEnabled then
    lineEffect = game.FX.Spawn("Draugr_Enchanted_Weapon_Line_Explode", thisLevel)
    lineEffect:AddPoint(previousDestination)
    table.insert(linePoints, previousDestination)
  end
  local nextLocation = LD.GetPointAlongLine(previousDestination, endDestination, concussionFrequency)
  if (startDestination - nextLocation):Length() > (startDestination - endDestination):Length() then
    nextLocation = endDestination
    lineCompleted = true
  end
  if PathIsObstructed(previousDestination + groundDebugVectorOffset, nextLocation + groundDebugVectorOffset) then
    Cleanup()
    return
  end
  if nextLocation ~= nil then
    local tempNextLoc = game.NavMesh.ClosestPoint(nextLocation)
    if tempNextLoc ~= nil then
      local nextLocation_y = tempNextLoc.y
      nextLocation = engine.Vector.New(nextLocation.x, nextLocation_y, nextLocation.z)
      if lineEffect ~= nil then
        lineEffect:AddPoint(nextLocation)
        table.insert(linePoints, nextLocation)
      end
      UpdateLineGOPosition()
      StartLevelTimer(concussionDelay, function()
        TriggerConcussion(nextLocation)
      end)
      previousDestination = nextLocation
    else
      lineCompleted = true
    end
  else
    lineCompleted = true
  end
  LD.CallFunctionAfterDelay(function()
    if not lineCompleted then
      GetNextConcussionLocation()
    else
      Cleanup()
    end
  end, timeBetweenLines)
end
function UpdateLineGOPosition()
  if GOline ~= nil and thisObj ~= nil then
    LD.TrackEmitterOnLine(linePoints, player, GOline, 100)
    LD.PlaySound(SNDLine, "SND_CHR_Draugr_Power_Enchanted_Hvy_Line_AttK_LP")
  end
end
function TriggerConcussion(nextLocation)
  if thisObj ~= nil then
    local owner = thisObj:GetEffectObjectCreator()
    local ownerID
    if owner ~= nil then
      ownerID = owner:GetID()
      local concussionParams = {
        Tweak = "CNC_DRAUGR_ENCHANTED_LINE",
        WorldLocation = nextLocation,
        Creature = owner,
        EnemyId = ownerID
      }
      game.Combat.PlayConcussion(concussionParams)
    end
  end
end
function PathIsObstructed(point01, point02)
  local collisionParams = {
    SourceGameObject = thisObj,
    ExcludeGameObject = thisObj,
    EntityType = game.CollisionType.New("kInvisibleBarrier", "kEnvironment")
  }
  local hit = game.World.RaycastCollision(point01, point02, collisionParams)
  if hit then
    if hit.GameObject:IsBreakable() then
      return false
    end
    return true
  end
  return false
end
function Cleanup()
  if thisObj ~= nil then
    thisObj:Destroy()
  end
  if lineEffect ~= nil then
    lineEffect:Remove()
  end
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
