local DL = require("design.DesignerLibrary")
local LD = require("design.LevelDesignLibrary")
function LuaHook_DraugrAllowDebug(ai, data)
end
function LuaHook_DraugrHeadSummon(ai, data)
  local headTurret = game.FX.Spawn("DraugrHeadTurret00")
  headTurret:SetWorldPosition(engine.Vector.New(0, 1.5, 0) + ai:GetWorldPosition())
end
function LuaHook_DraugrCancelTurretMode(ai, data)
  if ai:PickupIsActive("TurretMode") then
    ai:PickupRelinquish("TurretMode")
  end
end
function LuaHook_DraugrShieldParry(ai, data)
  ai:TriggerMoveEvent("kLEDraugrNavIdleFeatherOff")
  ai:TriggerMoveEvent("kLEDraugrNavJogFeatherOff")
  game.Audio.IncrementBanterFact("NumberOfParrys", 1, "Encounter")
  game.Audio.PlayBanterNonCritical("FailTactic_DraugrParry")
end
function LuaHook_DraugrEnchantWeaponOn(ai, data)
  ai:PickupAcquire("DraugrWeaponEnchant")
  if ai:PickupIsAcquired("DraugrOneHand") then
    ai:PickupSetStage("DraugrOneHand", 2)
  elseif ai:PickupIsAcquired("DraugrTwoHand") then
    ai:PickupSetStage("DraugrTwoHand", 2)
  elseif ai:PickupIsAcquired("DraugrDualWield") then
    ai:PickupSetStage("DraugrDualWield", 2)
  elseif ai:PickupIsAcquired("DraugrShield") then
    ai:PickupSetStage("DraugrShield", 2)
  end
  _G.global.powerArmEnchantAmmo = 3
end
function LuaHook_DraugrEnchantWeaponUse(ai, data)
  DraugrEnchantWeaponDecrement(ai, 1)
end
function LuaHook_DraugrEnchantWeaponDisable(ai, data)
  DraugrEnchantWeaponDecrement(ai, 5)
end
function DraugrEnchantWeaponDecrement(ai, amount)
  local ammo = _G.global.powerArmEnchantAmmo - amount
  _G.global.powerArmEnchantAmmo = ammo
  if ammo <= 0 and ai:PickupIsAcquired("DraugrWeaponEnchant") then
    ai:PickupRelinquish("DraugrWeaponEnchant")
    if ai:PickupIsAcquired("DraugrOneHand") then
      ai:PickupSetStage("DraugrOneHand", 1)
    elseif ai:PickupIsAcquired("DraugrTwoHand") then
      ai:PickupSetStage("DraugrTwoHand", 1)
    elseif ai:PickupIsAcquired("DraugrDualWield") then
      ai:PickupSetStage("DraugrDualWield", 1)
    elseif ai:PickupIsAcquired("DraugrShield") then
      ai:PickupSetStage("DraugrShield", 1)
    end
  end
end
function LuaDecision_DraugrWeaponType(ai, data)
  local global = _G.global
  local retVal
  if ai:PickupIsActive("DraugrOneHand") then
    return data:FindOutcomeBranchesEntry("OneHand")
  elseif ai:PickupIsActive("DraugrTwoHand") then
    return data:FindOutcomeBranchesEntry("TwoHand")
  elseif ai:PickupIsActive("DraugrDualWield") then
    return data:FindOutcomeBranchesEntry("DualWield")
  elseif ai:PickupIsActive("DraugrShield") then
    return data:FindOutcomeBranchesEntry("Shield")
  else
    return data:FindOutcomeBranchesEntry("Unarmed")
  end
end
function LuaHook_DraugrDualWieldOn(ai, data)
  if ai:PickupIsAcquired("DraugrOneHand") == true then
    ai:PickupRelinquish("DraugrOneHand")
  end
  if ai:PickupIsAcquired("DraugrDualWield") == false then
    ai:PickupAcquire("DraugrDualWield")
  end
end
function LuaHook_DraugrTwoHandOn(ai, data)
  if ai:PickupIsAcquired("DraugrOneHand") == true then
    ai:PickupRelinquish("DraugrOneHand")
  end
  if ai:PickupIsAcquired("DraugrTwoHand") == false then
    ai:PickupAcquire("DraugrTwoHand")
  end
end
function LuaHook_PowerLegEvade_CollisionCheck(ai, data)
  return DL.LuaHook_Evade_CollisionCheckShared(ai, data, 10, false)
end
function LuaHook_PowerBody_EnemiesCheck(ai, data)
  local retVal = "Valid"
  local player = game.Player.FindPlayer()
  local enemies = DL.FindLivingEnemies(player, 30)
  for i = #enemies, 1, -1 do
    if enemies[i]:PickupIsAcquired("DraugrPowerBodyShield") == false then
      table.remove(enemies, i)
    end
  end
  if 3 <= #enemies then
    retVal = "Invalid"
  end
  return data:FindOutcomeBranchesEntry(retVal)
end
function LuaHook_SpawnFromHiding()
  if game.FindLevel("For550_BrokenForest") then
    LD.StartCombatMusic("SND_MX_PRO_fight_1_in", "SND_MX_PRO_fight_1_out")
  end
end
