function SetupPOIStates(POIState)
  local poiSearchParameters_Auto = {
    FindArgs = {
      "DRAUGR",
      "AUTO",
      MatchAll = true
    },
    Filter = function(poi, ads, ai, global, constants)
      return true
    end
  }
  local poiSearchParameters_Precombat = {
    FindArgs = {
      "DRAUGR",
      "PRECOMBAT",
      MatchAll = true
    },
    Filter = function(poi, ads, ai, global, constants)
      return global.aggroState ~= "INAGGRO" and global.aggroState ~= "INCOMBAT"
    end
  }
  local poiSearchParameters_Bonfire = {
    FindArgs = {
      "DRAUGR",
      "BONFIRE",
      MatchAll = true
    },
    Filter = function(poi, ads, ai, global, constants)
      if ai:PickupIsAcquired("DraugrPowerArmsL") then
        return true
      end
      return false
    end
  }
  function POIState:GetSearchParameters(ai, global, constants)
    local parameters = {}
    table.insert(parameters, poiSearchParameters_Precombat)
    table.insert(parameters, poiSearchParameters_Bonfire)
    table.insert(parameters, poiSearchParameters_Auto)
    return parameters
  end
  local POI_PreCombat = POIState:TypeHandler("POI_PreCombat")
  local POI_Bonfire = POIState:TypeHandler("POI_Bonfire")
  function POI_PreCombat:IsAvailable(poi, ai, global, constants)
    return poi ~= nil and poi.Type == "PreCombat"
  end
  function POI_PreCombat:Enter(poi, ai, global, constants)
    self.poiPos = poi:GetWorldPosition()
    self.thisPOI = poi
  end
  function POI_PreCombat.Events:OnHitReaction(event, ai, global, constants)
    if self.thisPOI ~= nil then
      self.thisPOI:SendEvent("kEHitReaction")
    end
  end
  function POI_PreCombat:Update(poi, ai, global, constants)
    POIState:OnUpdateAwareness(ai, global, constants)
    self:ApproachPOI(ai, global, constants)
    if global.aggroState == "INAGGRO" or global.aggroState == "INCOMBAT" then
      poi:SendEvent("EndPOI")
    end
  end
  function POI_Bonfire:IsAvailable(poi, ai, global, constants)
    return poi ~= nil and poi.Type == "BONFIRE"
  end
  function POI_Bonfire:Enter(poi, ai, global, constants)
    self.poiPos = poi:GetWorldPosition()
    self.thisPOI = poi
    global.usePoiCooldown = 0
  end
  function POI_Bonfire.Events:OnHitReaction(event, ai, global, constants)
    if self.thisPOI ~= nil then
      if ai:GetHitPoints() <= 0 then
        self.thisPOI:SendEvent("kEDead")
      else
        self.thisPOI:SendEvent("kEHitReaction")
      end
    end
  end
  function POI_Bonfire:Update(poi, ai, global, constants)
    POIState:OnUpdateAwareness(ai, global, constants)
    self:ApproachPOI(ai, global, constants)
  end
  function POI_Bonfire:Exit(poi, ai, global, constants)
    global.usePOICooldown = constants.usePOICooldown
    self.currentDestination = nil
  end
end
return {
  SetupPOIStates = SetupPOIStates
}
