local statemachine = require("ai.statemachine")
local DL = require("design.DesignerLibrary")
local poilib = require("behavior.poi")
local earthdragon_poistates = require("EarthDragon00.poi")
local goPlayerCreature
local Brain = statemachine.StateMachine.New("EarthDragon00")
local NOTHING = Brain:State("Nothing")
local INCOMBAT = Brain:State("InCombat")
function Brain:OnBrainInit(ai, global, constants)
  goPlayerCreature = game.Player.FindPlayer()
end
local UsePOI = poilib.NewPOIState(Brain, "UsePOI")
poilib.AllowPOIFromStates(INCOMBAT, NOTHING)
earthdragon_poistates.SetupPOIStates(UsePOI)
function NOTHING:Enter(ai, global, constants)
  DL.DebugPrint(ai, "NOTHING selected")
  global.aggroState = "INCOMBAT"
end
function INCOMBAT:Enter(ai, global, constants)
  DL.DebugPrint(ai, "INCOMBAT selected")
end
function INCOMBAT:Update(ai, global, constants)
  if ai:HasMarker("BossStage_Pos1_Breath") then
    global.DTree = "DTR_EARTHDRAGON_OFFENSIVE_POSISTION01"
  elseif ai:HasMarker("BossStage_Pos3_Melee") then
    global.DTree = "DTR_EARTHDRAGON_OFFENSIVE_POSISTION03"
  elseif ai:HasMarker("BossStage_Pos3_Breath") then
    global.DTree = "DTR_EARTHDRAGON_OFFENSIVE_POSISTION03_ELECTRICMODE"
  elseif ai:HasMarker("BossStage_Pos2_Melee") then
    global.DTree = "DTR_EARTHDRAGON_OFFENSIVE_POSISTION02"
  elseif ai:HasMarker("BossStage_Pos2_Breath") then
    global.DTree = "DTR_EARTHDRAGON_OFFENSIVE_POSISTION02_ELECTRICMODE"
  elseif ai:HasMarker("BossStage_TugWar_Pos02_Melee") then
    global.DTree = "DTR_EARTHDRAGON_OFFENSIVE_TUGOFWAR02"
  elseif ai:HasMarker("BossStage_TugWar_Pos02_Breath") then
    global.DTree = "DTR_EARTHDRAGON_OFFENSIVE_TUGOFWAR02_ELECTRICMODE"
  else
    global.DTree = "DTR_EARTHDRAGON_NONE"
  end
  local dTreeParams = {
    DecisionTree = global.DTree,
    AggressiveStandardRecoveryTime = 0,
    NonAggressiveStandardRecoveryTime = 1
  }
  ai:RunDTree(dTreeParams)
  engine.DrawTextInWorld(ai:GetWorldPosition() + engine.Vector.New(0, 0, 0), "DRAGON UPDATE", 16776960)
end
local myLevel
function FLIPTHESWITCH(newLevel)
  myLevel = newLevel
end
function Brain:SelectNextState(ai, global, constants)
  if _G.global.target == nil and (goPlayerCreature:GetWorldPosition() - ai:GetWorldPosition()):Length() <= 150 then
    _G.global.target = goPlayerCreature
    ai:SetCombatTarget(_G.global.target)
  end
  if myLevel ~= nil then
    return INCOMBAT
  end
  if poilib.IsPOIActive() then
    return UsePOI
  elseif global.aggroState == "INCOMBAT" then
    return INCOMBAT
  else
    return NOTHING
  end
end
function INCOMBAT.Events:OnHitReaction(event, ai, global, constants)
  if ai:HasMarker("STUNBOMBFACE") then
    local currentHealth_Hidden = ai:MeterGetValue("DragonBossHealth_Hidden")
    ai:MeterSetValue("DragonBossHealth", currentHealth_Hidden)
    local l_level
    l_level = game.FindLevel("Peak550_DragonArena")
    if l_level ~= nil then
      l_level:CallScript("LuaHook_DamageHealthBar")
    end
  end
  local currentHealth_Hidden = ai:MeterGetValue("DragonBossHealth_Hidden")
  if currentHealth_Hidden < 300 then
    ai:MeterSetValue("DragonBossHealth", 300)
    ai:MeterSetValue("DragonBossHealth_Hidden", 300)
  end
end
return Brain
